/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.tutorials;

import eu.ewerkzeug.easytranscript3.commons.fx.alerts.TutorialEvent;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Content;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.FlowControl;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Highlight;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialSection;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialStep;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.MenuBarController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.CreateTranscriptController;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.skin.ScrollPaneSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.shape.Rectangle;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class CreateTranscriptTutorial
implements Tutorial {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateTranscriptTutorial.class);
    public static final String NAME = "CreateTranscript";
    private final MenuBarController menuBarController;
    private final CreateTranscriptController createTranscriptController;
    private final LicenseService licenseService;
    private final MessageService messageService;
    private ResourceBundle tutorialBundle;
    private boolean skipMenu;

    @PostConstruct
    public void init() {
        this.tutorialBundle = this.messageService.getTutorialLocaleBundle();
    }

    public TutorialSection get() {
        List<TutorialStep> steps = null;
        if (this.licenseService.getUserLicense() != null && this.licenseService.getUserLicense().isSttEnabled()) {
            steps = this.skipMenu ? List.of(this.getTypeOfTranscriptStep()) : List.of(this.getNewTranscriptMenuStep(), this.getTypeOfTranscriptStep());
            List<TutorialSection> nextSections = List.of(this.getManualTranscriptionSection(true), this.getAutomaticTranscriptionSection());
            return TutorialSection.builder().steps(steps).nextSections(nextSections).build();
        }
        if (!this.skipMenu) {
            steps = List.of(this.getNewTranscriptMenuStep());
        }
        List<TutorialSection> nextSections = List.of(this.getManualTranscriptionSection(false));
        if (steps != null) {
            return TutorialSection.builder().steps(steps).nextSections(nextSections).build();
        }
        return TutorialSection.builder().steps((Collection)nextSections.getFirst().getSteps()).build();
    }

    private TutorialStep getNewTranscriptMenuStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> FlowControl.asBooleanBinding((EventStream)EventStreams.eventsOf((MenuItem)this.menuBarController.getNewMenuItem(), (EventType)ActionEvent.ACTION))).goToNextImmediately(true).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.newTranscriptMenuStep.title")).description(this.tutorialBundle.getString("createTranscript.newTranscriptMenuStep.description")).build()).highlight(Highlight.builder().node(() -> ((MenuBarController)this.menuBarController).getMenuBar()).transformation(() -> new Rectangle(-10.0, 0.0, -470.0, 0.0)).build()).build();
    }

    private TutorialStep getTypeOfTranscriptStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().goingBackAllowed(false).beforeShow(() -> this.disableScrolling()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.typeOfTranscriptStep.title")).description(this.tutorialBundle.getString("createTranscript.typeOfTranscriptStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getTypeOfTranscriptVBox())).build();
    }

    private TutorialSection getManualTranscriptionSection(boolean goingBackAllowed) {
        Supplier<Boolean> condition = null;
        if (goingBackAllowed) {
            condition = () -> this.createTranscriptController.getManualRadioButton().isSelected();
        }
        return TutorialSection.builder().condition(condition).step(this.getSavingLocationStep(goingBackAllowed)).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> this.createTranscriptController.getMediaPathLabel().textProperty().isNotEmpty()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.chooseMediaFileStep.title")).description(this.tutorialBundle.getString("createTranscript.chooseMediaFileStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getSettingsManualVBox())).build()).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> FlowControl.asBooleanBinding((EventStream)EventStreams.eventsOf((Node)this.createTranscriptController.getFinishButton(), (EventType)ActionEvent.ACTION))).goToNextImmediately(true).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.finishTranscriptManual.title")).description(this.tutorialBundle.getString("createTranscript.finishTranscriptManual.description")).build()).highlight(Highlight.builder().node(() -> ((CreateTranscriptController)this.createTranscriptController).getFinishButton()).build()).build()).nextSection(this.getManualTranscriptionSuccessSection()).build();
    }

    private TutorialSection getManualTranscriptionSuccessSection() {
        return TutorialSection.builder().step(TutorialStep.builder().flowControl(FlowControl.builder().goingBackAllowed(false).build()).content(Content.builder().title(this.tutorialBundle.getString("tutorials.youDidIt")).description(this.tutorialBundle.getString("createTranscript.successManual.description")).build()).build()).build();
    }

    private TutorialSection getAutomaticTranscriptionSection() {
        return TutorialSection.builder().condition(() -> this.createTranscriptController.getAutomaticallyRadioButton().isSelected()).step(this.getSavingLocationStep(true)).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> ((CreateTranscriptController)this.createTranscriptController).getAllAutomaticMediaFilesValid()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.chooseMediaFilesStep.title")).description(this.tutorialBundle.getString("createTranscript.chooseMediaFilesStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getAutomaticMediaFilesVBox())).build()).step(TutorialStep.builder().content(Content.builder().title(this.tutorialBundle.getString("createTranscript.mediaFileOptionsStep.title")).description(this.tutorialBundle.getString("createTranscript.mediaFileOptionsStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getShowDetailsButton())).build()).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> this.createTranscriptController.getInvalidSelectedLanguageBinding().not()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.languageStep.title")).description(this.tutorialBundle.getString("createTranscript.languageStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getLanguageVBox())).build()).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> this.createTranscriptController.getTranscriptRuleSelectionComboBox().getSelectionModel().selectedItemProperty().isNotNull()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.transcriptionRulesStep.title")).description(this.tutorialBundle.getString("createTranscript.transcriptionRulesStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getTranscriptionRulesVBox())).build()).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> this.createTranscriptController.getAgreeToDataPrivacyCheckBox().selectedProperty()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.dataPrivacyStep.title")).description(this.tutorialBundle.getString("createTranscript.dataPrivacyStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getDataPrivacyVBox())).build()).step(TutorialStep.builder().flowControl(FlowControl.builder().conditionForNext(() -> FlowControl.asBooleanBinding((EventStream)EventStreams.eventsOf((Node)this.createTranscriptController.getFinishButton(), (EventType)ActionEvent.ACTION))).goToNextImmediately(true).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.finishTranscriptAutomatic.title")).description(this.tutorialBundle.getString("createTranscript.finishTranscriptAutomatic.description")).build()).highlight(Highlight.builder().node(() -> ((CreateTranscriptController)this.createTranscriptController).getFinishButton()).build()).build()).nextSection(this.getAutomaticTranscriptionSuccessSection()).build();
    }

    private TutorialSection getAutomaticTranscriptionSuccessSection() {
        return TutorialSection.builder().step(TutorialStep.builder().flowControl(FlowControl.builder().goingBackAllowed(false).build()).content(Content.builder().title(this.tutorialBundle.getString("tutorials.youDidIt")).description(this.tutorialBundle.getString("createTranscript.successAutomatic.description")).build()).build()).build();
    }

    private TutorialStep getSavingLocationStep(boolean goingBackAllowed) {
        return TutorialStep.builder().flowControl(FlowControl.builder().goingBackAllowed(goingBackAllowed).conditionForNext(() -> this.createTranscriptController.getTranscriptPathLabel().textProperty().isNotEmpty()).build()).content(Content.builder().title(this.tutorialBundle.getString("createTranscript.savingLocationStep.title")).description(this.tutorialBundle.getString("createTranscript.savingLocationStep.description")).build()).highlight(this.getHighlightWithFullWidth(() -> ((CreateTranscriptController)this.createTranscriptController).getSavingLocationVBox())).build();
    }

    private Highlight getHighlightWithFullWidth(Supplier<Node> node) {
        return Highlight.builder().node(node).transformation(() -> Highlight.createPaddingWithFilledSceneWidth((double)15.0, (Node)((Node)node.get()))).build();
    }

    public boolean isPopup() {
        return false;
    }

    public void onEvent(TutorialEvent event) {
        this.enableScrolling();
    }

    private void disableScrolling() {
    }

    @NotNull
    private EventHandler<KeyEvent> getKeyPressedEventFilter() {
        return e -> {
            if (e.getCode().isArrowKey() || e.getCode() == KeyCode.TAB) {
                e.consume();
            }
        };
    }

    @NotNull
    private EventHandler<ScrollEvent> getScrollEventFilter() {
        return Event::consume;
    }

    private void enableScrolling() {
        if (this.createTranscriptController != null && this.createTranscriptController.getScrollPane() != null) {
            this.createTranscriptController.getScrollPane().removeEventFilter(ScrollEvent.ANY, this.getScrollEventFilter());
            ((ScrollPaneSkin)this.createTranscriptController.getScrollPane().getSkin()).getVerticalScrollBar().setDisable(false);
            this.createTranscriptController.getScrollPane().removeEventFilter(KeyEvent.KEY_PRESSED, this.getKeyPressedEventFilter());
        }
    }

    @Generated
    public CreateTranscriptTutorial(MenuBarController menuBarController, CreateTranscriptController createTranscriptController, LicenseService licenseService, MessageService messageService) {
        this.menuBarController = menuBarController;
        this.createTranscriptController = createTranscriptController;
        this.licenseService = licenseService;
        this.messageService = messageService;
    }

    @Generated
    public boolean isSkipMenu() {
        return this.skipMenu;
    }

    @Generated
    public void setSkipMenu(boolean skipMenu) {
        this.skipMenu = skipMenu;
    }
}

