/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.commons.types.Theme;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.KeyCombination;
import javafx.scene.text.TextAlignment;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Configuration {
    public static final String ET_HOME = SystemUtils.USER_HOME + "/easytranscript3";
    @JsonIgnore
    private static final Theme DEFAULT_THEME = Theme.SYNC_WITH_OS;
    @JsonIgnore
    public static final String DEFAULT_TIMESTAMP_FORMAT = "#HH:mm:ss-SSS#";
    @JsonIgnore
    private final StringProperty timestampsFormat = new SimpleStringProperty("#HH:mm:ss-SSS#");
    @JsonIgnore
    private final ObjectProperty<Channel> channel = new SimpleObjectProperty((Object)Channel.STABLE);
    @JsonIgnore
    private final BooleanProperty timestampsOnBeginning = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final BooleanProperty timestampsOnEnd = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final BooleanProperty drawerExpanded = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final StringProperty formattingFont = new SimpleStringProperty("Monospaced");
    @JsonIgnore
    private final IntegerProperty formattingSize = new SimpleIntegerProperty(12);
    @JsonIgnore
    private final BooleanProperty formattingBold = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final BooleanProperty formattingItalic = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final BooleanProperty formattingUnderlined = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final ObjectProperty<TextAlignment> formattingParagraphAlignment = new SimpleObjectProperty((Object)TextAlignment.LEFT);
    @JsonIgnore
    private final BooleanProperty autocompletionActive = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final IntegerProperty autocompletionThreshold = new SimpleIntegerProperty(3);
    @JsonIgnore
    private final BooleanProperty autoCorrectionActive = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final BooleanProperty autoRecoverActive = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final IntegerProperty autoRecoverTimer = new SimpleIntegerProperty(5);
    @JsonIgnore
    private final BooleanProperty autosaveActive = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final IntegerProperty autosaveInterval = new SimpleIntegerProperty(5);
    @JsonIgnore
    private final IntegerProperty windingInterval = new SimpleIntegerProperty(4);
    @JsonIgnore
    private final BooleanProperty autoRewindAfterPause = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final BooleanProperty additionalLineAfterEnter = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerRewind = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"F3"));
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerPlayPause = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"F4"));
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerFastForward = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"F5"));
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerQuieter = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Down"));
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerLouder = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Up"));
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerSlower = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Left"));
    @JsonIgnore
    private final ObjectProperty<KeyCombination> playerFaster = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Right"));
    @JsonIgnore
    private final BooleanProperty useVLCPlayer = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final StringProperty vlcPath = new SimpleStringProperty("");
    @JsonIgnore
    private final StringProperty programLanguage = new SimpleStringProperty(Locale.getDefault().getLanguage());
    @JsonIgnore
    private final BooleanProperty programAutomaticUpdateSearch = new SimpleBooleanProperty(true);
    @JsonProperty(value="programRecentLoaded")
    private final ArrayList<String> programRecentLoaded = new ArrayList();
    @JsonIgnore
    private final StringProperty author = new SimpleStringProperty();
    @JsonIgnore
    private final BooleanProperty integrateVideoplayer = new SimpleBooleanProperty(true);
    @JsonIgnore
    private final BooleanProperty useSavedLastPlayerTime = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final StringProperty theme = new SimpleStringProperty(DEFAULT_THEME.toString());
    @JsonIgnore
    private final DoubleProperty widthOfTextAreaInCm = new SimpleDoubleProperty(-1.0);
    @JsonIgnore
    private final BooleanProperty showParagraphNumbers = new SimpleBooleanProperty(false);
    @JsonIgnore
    private final LongProperty timestampOffset = new SimpleLongProperty(0L);
    @JsonProperty(value="seenTutorials")
    private final HashSet<String> seenTutorials = new HashSet();
    @JsonIgnore
    private ObservableList<String> programRecentLoadedObservableList;
    private String logLevel = Level.INFO.toString();
    private List<String> queuedLogs = new ArrayList();

    public void copyFrom(Configuration other) {
        this.setTimestampsFormat(other.getTimestampsFormat());
        this.setChannel(other.getChannel());
        this.setTimestampsOnBeginning(other.isTimestampsOnBeginning());
        this.setTimestampsOnEnd(other.isTimestampsOnEnd());
        this.setDrawerExpanded(other.isDrawerExpanded());
        this.setFormattingFont(other.getFormattingFont());
        this.setFormattingSize(other.getFormattingSize());
        this.setFormattingBold(other.isFormattingBold());
        this.setFormattingItalic(other.isFormattingItalic());
        this.setFormattingUnderlined(other.isFormattingUnderlined());
        this.setFormattingParagraphAlignment(other.getFormattingParagraphAlignment());
        this.setAutocompletionActive(other.isAutocompletionActive());
        this.setAutocompletionThreshold(other.getAutocompletionThreshold());
        this.setAutoCorrectionActive(other.isAutoCorrectionActive());
        this.setAutoRecoverActive(other.isAutoRecoverActive());
        this.setAutoRecoverTimer(other.getAutoRecoverTimer());
        this.setAutosaveActive(other.isAutosaveActive());
        this.setAutosaveInterval(other.getAutosaveInterval());
        this.setWindingInterval(other.getWindingInterval());
        this.setAutoRewindAfterPause(other.isAutoRewindAfterPause());
        this.setAdditionalLineAfterEnter(other.isAdditionalLineAfterEnter());
        this.setPlayerRewind(other.getPlayerRewind());
        this.setPlayerPlayPause(other.getPlayerPlayPause());
        this.setPlayerFastForward(other.getPlayerFastForward());
        this.setPlayerQuieter(other.getPlayerQuieter());
        this.setPlayerLouder(other.getPlayerLouder());
        this.setPlayerSlower(other.getPlayerSlower());
        this.setPlayerFaster(other.getPlayerFaster());
        this.setUseVLCPlayer(other.isUseVLCPlayer());
        this.setVlcPath(other.getVlcPath());
        this.setProgramLanguage(other.getProgramLanguage());
        this.setProgramAutomaticUpdateSearch(other.isProgramAutomaticUpdateSearch());
        this.setAuthor(other.getAuthor());
        this.setIntegrateVideoplayer(other.isIntegrateVideoplayer());
        this.setUseSavedLastPlayerTime(other.isUseSavedLastPlayerTime());
        this.setTheme(other.getTheme());
        this.setWidthOfTextAreaInCm(other.getWidthOfTextAreaInCm());
        this.setShowParagraphNumbers(other.getShowParagraphNumbers());
        this.setTimestampOffset(other.getTimestampOffset());
        this.setLogLevel(other.getLogLevel());
        this.setQueuedLogs(other.getQueuedLogs());
        this.programRecentLoaded.clear();
        this.programRecentLoaded.addAll(other.getProgramRecentLoaded());
        this.seenTutorials.clear();
        this.seenTutorials.addAll(other.getSeenTutorials());
    }

    @JsonProperty(value="timestampsFormat")
    public String getTimestampsFormat() {
        return this.timestampsFormat.getValue();
    }

    @JsonProperty(value="timestampsFormat")
    public void setTimestampsFormat(String timestampsFormat) {
        this.timestampsFormat.setValue(timestampsFormat);
    }

    public StringProperty timestampsFormatProperty() {
        return this.timestampsFormat;
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @JsonProperty(value="channel")
    public void setChannel(Channel channel) {
        this.channel.setValue((Object)channel);
    }

    public ObjectProperty<Channel> channelProperty() {
        return this.channel;
    }

    @JsonProperty(value="timestampsOnBeginning")
    public boolean isTimestampsOnBeginning() {
        return this.timestampsOnBeginning.getValue();
    }

    @JsonProperty(value="timestampsOnBeginning")
    public void setTimestampsOnBeginning(boolean timestampsOnBeginning) {
        this.timestampsOnBeginning.setValue(Boolean.valueOf(timestampsOnBeginning));
    }

    @JsonProperty(value="timestampsOnEnd")
    public boolean isTimestampsOnEnd() {
        return this.timestampsOnEnd.getValue();
    }

    @JsonProperty(value="timestampsOnEnd")
    public void setTimestampsOnEnd(boolean timestampsOnEnd) {
        this.timestampsOnEnd.setValue(Boolean.valueOf(timestampsOnEnd));
    }

    public BooleanProperty timestampsOnEndProperty() {
        return this.timestampsOnEnd;
    }

    @JsonProperty(value="drawerExpanded")
    public boolean isDrawerExpanded() {
        return this.drawerExpanded.get();
    }

    @JsonProperty(value="drawerExpanded")
    public void setDrawerExpanded(boolean drawerExpanded) {
        this.drawerExpanded.set(drawerExpanded);
    }

    public BooleanProperty drawerExpandedProperty() {
        return this.drawerExpanded;
    }

    @JsonProperty(value="formattingFont")
    public String getFormattingFont() {
        return this.formattingFont.getValue();
    }

    @JsonProperty(value="formattingFont")
    public void setFormattingFont(String formattingFont) {
        this.formattingFont.setValue(formattingFont);
    }

    public StringProperty formattingFontProperty() {
        return this.formattingFont;
    }

    @JsonProperty(value="formattingSize")
    public int getFormattingSize() {
        return this.formattingSize.getValue();
    }

    @JsonProperty(value="formattingSize")
    public void setFormattingSize(int formattingSize) {
        this.formattingSize.setValue((Number)formattingSize);
    }

    public IntegerProperty formattingSizeProperty() {
        return this.formattingSize;
    }

    @JsonProperty(value="formattingBold")
    public boolean isFormattingBold() {
        return this.formattingBold.getValue();
    }

    @JsonProperty(value="formattingBold")
    public void setFormattingBold(boolean formattingBold) {
        this.formattingBold.setValue(Boolean.valueOf(formattingBold));
    }

    public BooleanProperty formattingBoldProperty() {
        return this.formattingBold;
    }

    @JsonProperty(value="formattingItalic")
    public boolean isFormattingItalic() {
        return this.formattingItalic.getValue();
    }

    @JsonProperty(value="formattingItalic")
    public void setFormattingItalic(boolean formattingItalic) {
        this.formattingItalic.setValue(Boolean.valueOf(formattingItalic));
    }

    public BooleanProperty formattingItalicProperty() {
        return this.formattingItalic;
    }

    @JsonProperty(value="formattingUnderlined")
    public boolean isFormattingUnderlined() {
        return this.formattingUnderlined.getValue();
    }

    @JsonProperty(value="formattingUnderlined")
    public void setFormattingUnderlined(boolean formattingUnderlined) {
        this.formattingUnderlined.setValue(Boolean.valueOf(formattingUnderlined));
    }

    public BooleanProperty formattingUnderlinedProperty() {
        return this.formattingUnderlined;
    }

    @JsonProperty(value="formattingParagraphAlignment")
    public TextAlignment getFormattingParagraphAlignment() {
        return (TextAlignment)this.formattingParagraphAlignment.get();
    }

    @JsonProperty(value="formattingParagraphAlignment")
    public void setFormattingParagraphAlignment(TextAlignment formattingParagraphAlignment) {
        this.formattingParagraphAlignment.set((Object)formattingParagraphAlignment);
    }

    public ObjectProperty<TextAlignment> formattingParagraphAlignmentProperty() {
        return this.formattingParagraphAlignment;
    }

    @JsonProperty(value="autocompletionActive")
    public boolean isAutocompletionActive() {
        return this.autocompletionActive.getValue();
    }

    @JsonProperty(value="autocompletionActive")
    public void setAutocompletionActive(boolean autocompletionActive) {
        this.autocompletionActive.setValue(Boolean.valueOf(autocompletionActive));
    }

    public BooleanProperty autocompletionActiveProperty() {
        return this.autocompletionActive;
    }

    @JsonProperty(value="autocompletionThreshold")
    public int getAutocompletionThreshold() {
        return this.autocompletionThreshold.getValue();
    }

    @JsonProperty(value="autocompletionThreshold")
    public void setAutocompletionThreshold(int autocompletionThreshold) {
        this.autocompletionThreshold.setValue((Number)autocompletionThreshold);
    }

    public IntegerProperty autocompletionThresholdProperty() {
        return this.autocompletionThreshold;
    }

    @JsonProperty(value="autoCorrectionActive")
    public boolean isAutoCorrectionActive() {
        return this.autoCorrectionActive.get();
    }

    @JsonProperty(value="autoCorrectionActive")
    public void setAutoCorrectionActive(boolean autoCorrectionActive) {
        this.autoCorrectionActive.set(autoCorrectionActive);
    }

    public BooleanProperty autoCorrectionActiveProperty() {
        return this.autoCorrectionActive;
    }

    @JsonProperty(value="autoRecoverActive")
    public boolean isAutoRecoverActive() {
        return this.autoRecoverActive.get();
    }

    @JsonProperty(value="autoRecoverActive")
    public void setAutoRecoverActive(boolean autoRecoverActive) {
        this.autoRecoverActive.set(autoRecoverActive);
    }

    public BooleanProperty autoRecoverActiveProperty() {
        return this.autoRecoverActive;
    }

    @JsonProperty(value="autoRecoverTimer")
    public int getAutoRecoverTimer() {
        return this.autoRecoverTimer.get();
    }

    @JsonProperty(value="autoRecoverTimer")
    public void setAutoRecoverTimer(int autoRecoverTimer) {
        this.autoRecoverTimer.set(autoRecoverTimer);
    }

    public IntegerProperty autoRecoverTimerProperty() {
        return this.autoRecoverTimer;
    }

    @JsonProperty(value="autosaveActive")
    public boolean isAutosaveActive() {
        return this.autosaveActive.getValue();
    }

    @JsonProperty(value="autosaveActive")
    public void setAutosaveActive(boolean autosaveActive) {
        this.autosaveActive.setValue(Boolean.valueOf(autosaveActive));
    }

    public BooleanProperty autosaveActiveProperty() {
        return this.autosaveActive;
    }

    @JsonProperty(value="autosaveInterval")
    public int getAutosaveInterval() {
        return this.autosaveInterval.getValue();
    }

    @JsonProperty(value="autosaveInterval")
    public void setAutosaveInterval(int autosaveInterval) {
        this.autosaveInterval.setValue((Number)autosaveInterval);
    }

    public IntegerProperty autosaveIntervalProperty() {
        return this.autosaveInterval;
    }

    @JsonProperty(value="windingInterval")
    public int getWindingInterval() {
        return this.windingInterval.getValue();
    }

    @JsonProperty(value="windingInterval")
    public void setWindingInterval(int windingInterval) {
        this.windingInterval.setValue((Number)windingInterval);
    }

    public IntegerProperty windingIntervalProperty() {
        return this.windingInterval;
    }

    @JsonProperty(value="autoRewindAfterPause")
    public boolean isAutoRewindAfterPause() {
        return this.autoRewindAfterPause.getValue();
    }

    @JsonProperty(value="autoRewindAfterPause")
    public void setAutoRewindAfterPause(boolean autoRewindAfterPause) {
        this.autoRewindAfterPause.setValue(Boolean.valueOf(autoRewindAfterPause));
    }

    public BooleanProperty autoRewindAfterPauseProperty() {
        return this.autoRewindAfterPause;
    }

    @JsonProperty(value="additionalLineAfterEnter")
    public boolean isAdditionalLineAfterEnter() {
        return this.additionalLineAfterEnter.getValue();
    }

    @JsonProperty(value="additionalLineAfterEnter")
    public void setAdditionalLineAfterEnter(boolean additionalLineAfterEnter) {
        this.additionalLineAfterEnter.setValue(Boolean.valueOf(additionalLineAfterEnter));
    }

    public BooleanProperty additionalLineAfterEnterProperty() {
        return this.additionalLineAfterEnter;
    }

    @JsonProperty(value="playerRewind")
    public KeyCombination getPlayerRewind() {
        return (KeyCombination)this.playerRewind.getValue();
    }

    @JsonProperty(value="playerRewind")
    public void setPlayerRewind(KeyCombination playerRewind) {
        this.playerRewind.setValue((Object)playerRewind);
    }

    public ObjectProperty<KeyCombination> playerRewindProperty() {
        return this.playerRewind;
    }

    @JsonProperty(value="playerPlayPause")
    public KeyCombination getPlayerPlayPause() {
        return (KeyCombination)this.playerPlayPause.getValue();
    }

    @JsonProperty(value="playerPlayPause")
    public void setPlayerPlayPause(KeyCombination playerPlayPause) {
        this.playerPlayPause.setValue((Object)playerPlayPause);
    }

    public ObjectProperty<KeyCombination> playerPlayPauseProperty() {
        return this.playerPlayPause;
    }

    @JsonProperty(value="playerFastForward")
    public KeyCombination getPlayerFastForward() {
        return (KeyCombination)this.playerFastForward.getValue();
    }

    @JsonProperty(value="playerFastForward")
    public void setPlayerFastForward(KeyCombination playerFastForward) {
        this.playerFastForward.setValue((Object)playerFastForward);
    }

    public ObjectProperty<KeyCombination> playerFastForwardProperty() {
        return this.playerFastForward;
    }

    @JsonProperty(value="playerQuieter")
    public KeyCombination getPlayerQuieter() {
        return (KeyCombination)this.playerQuieter.getValue();
    }

    @JsonProperty(value="playerQuieter")
    public void setPlayerQuieter(KeyCombination playerQuieter) {
        this.playerQuieter.setValue((Object)playerQuieter);
    }

    public ObjectProperty<KeyCombination> playerQuieterProperty() {
        return this.playerQuieter;
    }

    @JsonProperty(value="playerLouder")
    public KeyCombination getPlayerLouder() {
        return (KeyCombination)this.playerLouder.getValue();
    }

    @JsonProperty(value="playerLouder")
    public void setPlayerLouder(KeyCombination playerLouder) {
        this.playerLouder.setValue((Object)playerLouder);
    }

    public ObjectProperty<KeyCombination> playerLouderProperty() {
        return this.playerLouder;
    }

    @JsonProperty(value="playerSlower")
    public KeyCombination getPlayerSlower() {
        return (KeyCombination)this.playerSlower.getValue();
    }

    @JsonProperty(value="playerSlower")
    public void setPlayerSlower(KeyCombination playerSlower) {
        this.playerSlower.setValue((Object)playerSlower);
    }

    public ObjectProperty<KeyCombination> playerSlowerProperty() {
        return this.playerSlower;
    }

    @JsonProperty(value="playerFaster")
    public KeyCombination getPlayerFaster() {
        return (KeyCombination)this.playerFaster.getValue();
    }

    @JsonProperty(value="playerFaster")
    public void setPlayerFaster(KeyCombination playerFaster) {
        this.playerFaster.setValue((Object)playerFaster);
    }

    public ObjectProperty<KeyCombination> playerFasterProperty() {
        return this.playerFaster;
    }

    @JsonProperty(value="useVLCPlayer")
    public boolean isUseVLCPlayer() {
        return this.useVLCPlayer.get();
    }

    @JsonProperty(value="useVLCPlayer")
    public void setUseVLCPlayer(boolean useVLCPlayer) {
        this.useVLCPlayer.set(useVLCPlayer);
    }

    public BooleanProperty useVLCPlayerProperty() {
        return this.useVLCPlayer;
    }

    @JsonProperty(value="vlcPath")
    public String getVlcPath() {
        return (String)this.vlcPath.get();
    }

    @JsonProperty(value="vlcPath")
    public void setVlcPath(String vlcPath) {
        this.vlcPath.set((Object)vlcPath);
    }

    public StringProperty vlcPathProperty() {
        return this.vlcPath;
    }

    @JsonProperty(value="programLanguage")
    public String getProgramLanguage() {
        return this.programLanguage.getValue();
    }

    @JsonProperty(value="programLanguage")
    public void setProgramLanguage(String programLanguage) {
        this.programLanguage.setValue(programLanguage);
    }

    public StringProperty programLanguageProperty() {
        return this.programLanguage;
    }

    @JsonProperty(value="programAutomaticUpdateSearch")
    public boolean isProgramAutomaticUpdateSearch() {
        return this.programAutomaticUpdateSearch.getValue();
    }

    @JsonProperty(value="programAutomaticUpdateSearch")
    public void setProgramAutomaticUpdateSearch(boolean programAutomaticUpdateSearch) {
        this.programAutomaticUpdateSearch.setValue(Boolean.valueOf(programAutomaticUpdateSearch));
    }

    public BooleanProperty programAutomaticUpdateSearchProperty() {
        return this.programAutomaticUpdateSearch;
    }

    @JsonProperty(value="author")
    public String getAuthor() {
        return this.author.getValueSafe();
    }

    @JsonProperty(value="author")
    public void setAuthor(String author) {
        this.author.setValue(author);
    }

    public StringProperty authorProperty() {
        return this.author;
    }

    @JsonProperty(value="integrateVideoplayer")
    public boolean isIntegrateVideoplayer() {
        return this.integrateVideoplayer.get();
    }

    @JsonProperty(value="integrateVideoplayer")
    public void setIntegrateVideoplayer(boolean integrateVideoplayer) {
        this.integrateVideoplayer.set(integrateVideoplayer);
    }

    public BooleanProperty integrateVideoplayerProperty() {
        return this.integrateVideoplayer;
    }

    @JsonProperty(value="useSavedLastPlayerTime")
    public boolean isUseSavedLastPlayerTime() {
        return this.useSavedLastPlayerTime.get();
    }

    @JsonProperty(value="useSavedLastPlayerTime")
    public void setUseSavedLastPlayerTime(boolean useSavedLastPlayerTime) {
        this.useSavedLastPlayerTime.set(useSavedLastPlayerTime);
    }

    public BooleanProperty useSavedLastPlayerTimeProperty() {
        return this.useSavedLastPlayerTime;
    }

    @JsonProperty(value="theme")
    public Theme getTheme() {
        try {
            return Theme.valueOf((String)((String)this.theme.get()));
        }
        catch (IllegalArgumentException e) {
            this.theme.set((Object)DEFAULT_THEME.toString());
            return DEFAULT_THEME;
        }
    }

    @JsonProperty(value="theme")
    public void setTheme(Theme theme) {
        this.theme.set((Object)theme.toString());
    }

    public StringProperty themeProperty() {
        return this.theme;
    }

    @JsonProperty(value="widthOfTextAreaInCm")
    public double getWidthOfTextAreaInCm() {
        return this.widthOfTextAreaInCm.get();
    }

    @JsonProperty(value="widthOfTextAreaInCm")
    public void setWidthOfTextAreaInCm(double widthOfTextAreaInCm) {
        this.widthOfTextAreaInCm.set(widthOfTextAreaInCm);
    }

    public DoubleProperty widthOfTextAreaInCmProperty() {
        return this.widthOfTextAreaInCm;
    }

    @JsonProperty(value="showParagraphNumbers")
    public boolean getShowParagraphNumbers() {
        return this.showParagraphNumbers.get();
    }

    @JsonProperty(value="showParagraphNumbers")
    public void setShowParagraphNumbers(boolean showParagraphNumbers) {
        this.showParagraphNumbers.set(showParagraphNumbers);
    }

    public BooleanProperty showParagraphNumbersProperty() {
        return this.showParagraphNumbers;
    }

    @JsonProperty(value="timestampOffset")
    public long getTimestampOffset() {
        return this.timestampOffset.get();
    }

    @JsonProperty(value="timestampOffset")
    public void setTimestampOffset(long offset) {
        this.timestampOffset.set(offset);
    }

    public LongProperty timestampOffsetProperty() {
        return this.timestampOffset;
    }

    public ObservableList<String> getProgramRecentLoadedObservableList() {
        if (this.programRecentLoadedObservableList == null) {
            this.programRecentLoadedObservableList = FXCollections.observableArrayList((Collection)this.programRecentLoaded);
            this.programRecentLoadedObservableList.addListener(change -> {
                this.programRecentLoaded.clear();
                this.programRecentLoaded.addAll(this.programRecentLoadedObservableList);
            });
        }
        return this.programRecentLoadedObservableList;
    }

    public void addToRecentLoaded(Transcript transcript) {
        if (transcript.getTranscriptLocation() == null) {
            return;
        }
        while (this.getProgramRecentLoadedObservableList().size() >= 19) {
            this.getProgramRecentLoadedObservableList().remove(this.getProgramRecentLoadedObservableList().size() - 1);
        }
        this.getProgramRecentLoadedObservableList().remove((Object)transcript.getTranscriptLocation().toString());
        this.getProgramRecentLoadedObservableList().add(0, (Object)transcript.getTranscriptLocation().toString());
    }

    public List<String> getProgramRecentLoaded() {
        return this.programRecentLoaded;
    }

    @Generated
    public String toString() {
        return "Configuration(timestampsFormat=" + this.getTimestampsFormat() + ", channel=" + String.valueOf(this.getChannel()) + ", timestampsOnBeginning=" + String.valueOf(this.timestampsOnBeginning) + ", timestampsOnEnd=" + String.valueOf(this.timestampsOnEnd) + ", drawerExpanded=" + String.valueOf(this.drawerExpanded) + ", formattingFont=" + this.getFormattingFont() + ", formattingSize=" + this.getFormattingSize() + ", formattingBold=" + String.valueOf(this.formattingBold) + ", formattingItalic=" + String.valueOf(this.formattingItalic) + ", formattingUnderlined=" + String.valueOf(this.formattingUnderlined) + ", formattingParagraphAlignment=" + String.valueOf(this.getFormattingParagraphAlignment()) + ", autocompletionActive=" + String.valueOf(this.autocompletionActive) + ", autocompletionThreshold=" + this.getAutocompletionThreshold() + ", autoCorrectionActive=" + String.valueOf(this.autoCorrectionActive) + ", autoRecoverActive=" + String.valueOf(this.autoRecoverActive) + ", autoRecoverTimer=" + this.getAutoRecoverTimer() + ", autosaveActive=" + String.valueOf(this.autosaveActive) + ", autosaveInterval=" + this.getAutosaveInterval() + ", windingInterval=" + this.getWindingInterval() + ", autoRewindAfterPause=" + String.valueOf(this.autoRewindAfterPause) + ", additionalLineAfterEnter=" + String.valueOf(this.additionalLineAfterEnter) + ", playerRewind=" + String.valueOf(this.getPlayerRewind()) + ", playerPlayPause=" + String.valueOf(this.getPlayerPlayPause()) + ", playerFastForward=" + String.valueOf(this.getPlayerFastForward()) + ", playerQuieter=" + String.valueOf(this.getPlayerQuieter()) + ", playerLouder=" + String.valueOf(this.getPlayerLouder()) + ", playerSlower=" + String.valueOf(this.getPlayerSlower()) + ", playerFaster=" + String.valueOf(this.getPlayerFaster()) + ", useVLCPlayer=" + String.valueOf(this.useVLCPlayer) + ", vlcPath=" + this.getVlcPath() + ", programLanguage=" + this.getProgramLanguage() + ", programAutomaticUpdateSearch=" + String.valueOf(this.programAutomaticUpdateSearch) + ", programRecentLoaded=" + String.valueOf(this.getProgramRecentLoaded()) + ", author=" + this.getAuthor() + ", integrateVideoplayer=" + String.valueOf(this.integrateVideoplayer) + ", useSavedLastPlayerTime=" + String.valueOf(this.useSavedLastPlayerTime) + ", theme=" + String.valueOf(this.getTheme()) + ", widthOfTextAreaInCm=" + this.getWidthOfTextAreaInCm() + ", showParagraphNumbers=" + this.getShowParagraphNumbers() + ", timestampOffset=" + this.getTimestampOffset() + ", seenTutorials=" + String.valueOf(this.getSeenTutorials()) + ", programRecentLoadedObservableList=" + String.valueOf(this.getProgramRecentLoadedObservableList()) + ", logLevel=" + this.getLogLevel() + ", queuedLogs=" + String.valueOf(this.getQueuedLogs()) + ")";
    }

    @Generated
    public HashSet<String> getSeenTutorials() {
        return this.seenTutorials;
    }

    @Generated
    public String getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Generated
    public List<String> getQueuedLogs() {
        return this.queuedLogs;
    }

    @Generated
    public void setQueuedLogs(List<String> queuedLogs) {
        this.queuedLogs = queuedLogs;
    }
}

