/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimeTrackingEntry {
    private LocalDateTime start = null;
    private LocalDateTime end = null;

    @JsonCreator
    public TimeTrackingEntry(@JsonProperty(value="start") LocalDateTime start, @JsonProperty(value="end") LocalDateTime end) {
        this.start = start;
        this.end = end;
    }

    public long getDateDiff(TemporalUnit timeUnit) {
        return this.start != null && this.end != null ? this.start.until(this.end, timeUnit) : 0L;
    }

    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Generated
    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    @Generated
    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeTrackingEntry)) {
            return false;
        }
        TimeTrackingEntry other = (TimeTrackingEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDateTime this$start = this.getStart();
        LocalDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDateTime this$end = this.getEnd();
        LocalDateTime other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeTrackingEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeTrackingEntry(start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ")";
    }

    @Generated
    public TimeTrackingEntry() {
    }
}

