/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types.automatictranscript;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.types.VersionDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.VersionSerializer;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.TranscriptionRuleSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AutomaticTranscriptCreationInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutomaticTranscriptCreationInfo.class);
    @JsonSerialize(using=VersionSerializer.class)
    @JsonDeserialize(using=VersionDeserializer.class)
    private Version usedETVersion;
    private final ObservableList<Person> persons = FXCollections.observableArrayList();
    private String language;
    @JsonProperty(value="domain_dictionary")
    private final ArrayList<String> domainDictionary = new ArrayList();
    @JsonIgnore
    private String uuid;
    @JsonIgnore
    private Path transcriptLocation = null;
    @JsonProperty(value="rule_set")
    private TranscriptionRuleSet transcriptionRuleSet = TranscriptionRuleSet.NONE;
    @JsonProperty(value="confidence_threshold")
    private double confidenceThreshold = 0.5;
    @JsonProperty(value="asr_engine_key")
    private String asrEngineKey = "AZURE_SPEECH_TO_TEXT";
    @JsonProperty(value="duration_in_seconds")
    private long durationInSeconds;

    public AutomaticTranscriptCreationInfo() {
        log.debug("Creating new transcript object...");
        this.uuid = UUID.randomUUID().toString();
    }

    public List<String> getDomainDictionary() {
        return this.domainDictionary;
    }

    @Generated
    public String toString() {
        return "AutomaticTranscriptCreationInfo(usedETVersion=" + String.valueOf(this.getUsedETVersion()) + ", persons=" + String.valueOf(this.getPersons()) + ", language=" + this.getLanguage() + ", domainDictionary=" + String.valueOf(this.getDomainDictionary()) + ", uuid=" + this.getUuid() + ", transcriptLocation=" + String.valueOf(this.getTranscriptLocation()) + ", transcriptionRuleSet=" + String.valueOf(this.getTranscriptionRuleSet()) + ", confidenceThreshold=" + this.getConfidenceThreshold() + ", asrEngineKey=" + this.getAsrEngineKey() + ", durationInSeconds=" + this.getDurationInSeconds() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutomaticTranscriptCreationInfo)) {
            return false;
        }
        AutomaticTranscriptCreationInfo other = (AutomaticTranscriptCreationInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getConfidenceThreshold(), other.getConfidenceThreshold()) != 0) {
            return false;
        }
        if (this.getDurationInSeconds() != other.getDurationInSeconds()) {
            return false;
        }
        Version this$usedETVersion = this.getUsedETVersion();
        Version other$usedETVersion = other.getUsedETVersion();
        if (this$usedETVersion == null ? other$usedETVersion != null : !this$usedETVersion.equals(other$usedETVersion)) {
            return false;
        }
        ObservableList this$persons = this.getPersons();
        ObservableList other$persons = other.getPersons();
        if (this$persons == null ? other$persons != null : !this$persons.equals(other$persons)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        List this$domainDictionary = this.getDomainDictionary();
        List other$domainDictionary = other.getDomainDictionary();
        if (this$domainDictionary == null ? other$domainDictionary != null : !((Object)this$domainDictionary).equals(other$domainDictionary)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Path this$transcriptLocation = this.getTranscriptLocation();
        Path other$transcriptLocation = other.getTranscriptLocation();
        if (this$transcriptLocation == null ? other$transcriptLocation != null : !((Object)this$transcriptLocation).equals(other$transcriptLocation)) {
            return false;
        }
        TranscriptionRuleSet this$transcriptionRuleSet = this.getTranscriptionRuleSet();
        TranscriptionRuleSet other$transcriptionRuleSet = other.getTranscriptionRuleSet();
        if (this$transcriptionRuleSet == null ? other$transcriptionRuleSet != null : !this$transcriptionRuleSet.equals(other$transcriptionRuleSet)) {
            return false;
        }
        String this$asrEngineKey = this.getAsrEngineKey();
        String other$asrEngineKey = other.getAsrEngineKey();
        return !(this$asrEngineKey == null ? other$asrEngineKey != null : !this$asrEngineKey.equals(other$asrEngineKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutomaticTranscriptCreationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $confidenceThreshold = Double.doubleToLongBits(this.getConfidenceThreshold());
        result = result * 59 + (int)($confidenceThreshold >>> 32 ^ $confidenceThreshold);
        long $durationInSeconds = this.getDurationInSeconds();
        result = result * 59 + (int)($durationInSeconds >>> 32 ^ $durationInSeconds);
        Version $usedETVersion = this.getUsedETVersion();
        result = result * 59 + ($usedETVersion == null ? 43 : $usedETVersion.hashCode());
        ObservableList $persons = this.getPersons();
        result = result * 59 + ($persons == null ? 43 : $persons.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        List $domainDictionary = this.getDomainDictionary();
        result = result * 59 + ($domainDictionary == null ? 43 : ((Object)$domainDictionary).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Path $transcriptLocation = this.getTranscriptLocation();
        result = result * 59 + ($transcriptLocation == null ? 43 : ((Object)$transcriptLocation).hashCode());
        TranscriptionRuleSet $transcriptionRuleSet = this.getTranscriptionRuleSet();
        result = result * 59 + ($transcriptionRuleSet == null ? 43 : $transcriptionRuleSet.hashCode());
        String $asrEngineKey = this.getAsrEngineKey();
        result = result * 59 + ($asrEngineKey == null ? 43 : $asrEngineKey.hashCode());
        return result;
    }

    @Generated
    public Version getUsedETVersion() {
        return this.usedETVersion;
    }

    @Generated
    public void setUsedETVersion(Version usedETVersion) {
        this.usedETVersion = usedETVersion;
    }

    @Generated
    public ObservableList<Person> getPersons() {
        return this.persons;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setTranscriptLocation(Path transcriptLocation) {
        this.transcriptLocation = transcriptLocation;
    }

    @Generated
    public Path getTranscriptLocation() {
        return this.transcriptLocation;
    }

    @Generated
    public void setTranscriptionRuleSet(TranscriptionRuleSet transcriptionRuleSet) {
        this.transcriptionRuleSet = transcriptionRuleSet;
    }

    @Generated
    public TranscriptionRuleSet getTranscriptionRuleSet() {
        return this.transcriptionRuleSet;
    }

    @Generated
    public void setConfidenceThreshold(double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    @Generated
    public double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    @Generated
    public void setAsrEngineKey(String asrEngineKey) {
        this.asrEngineKey = asrEngineKey;
    }

    @Generated
    public String getAsrEngineKey() {
        return this.asrEngineKey;
    }

    @Generated
    public void setDurationInSeconds(long durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    @Generated
    public long getDurationInSeconds() {
        return this.durationInSeconds;
    }
}

