/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types.automatictranscript;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.types.VersionDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.VersionSerializer;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.TranscriptionRuleSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LocalCreationInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalCreationInfo.class);
    @JsonSerialize(using=VersionSerializer.class)
    @JsonDeserialize(using=VersionDeserializer.class)
    private Version usedETVersion;
    @JsonProperty(value="domain_dictionary")
    private final ArrayList<String> domainDictionary = new ArrayList();
    private String uuid;
    private Path transcriptLocation = null;
    private List<Person> persons = new ArrayList();
    @JsonProperty(value="rule_set")
    private TranscriptionRuleSet transcriptionRuleSet = TranscriptionRuleSet.NONE;
    @JsonProperty(value="confidence_threshold")
    private double confidenceThreshold = 0.5;
    @JsonProperty(value="asr_engine_key")
    private String asrEngineKey = "AZURE_SPEECH_TO_TEXT";

    public static LocalCreationInfo ofAutomaticTranscriptCreationInfo(AutomaticTranscriptCreationInfo info) {
        LocalCreationInfo i = new LocalCreationInfo();
        i.setUsedETVersion(info.getUsedETVersion());
        i.setTranscriptionRuleSet(info.getTranscriptionRuleSet());
        i.setTranscriptLocation(info.getTranscriptLocation());
        i.setUuid(info.getUuid());
        i.getDomainDictionary().addAll(info.getDomainDictionary());
        i.setPersons(new ArrayList(info.getPersons()));
        i.setConfidenceThreshold(info.getConfidenceThreshold());
        return i;
    }

    @Generated
    public String toString() {
        return "LocalCreationInfo(usedETVersion=" + String.valueOf(this.getUsedETVersion()) + ", domainDictionary=" + String.valueOf(this.getDomainDictionary()) + ", uuid=" + this.getUuid() + ", transcriptLocation=" + String.valueOf(this.getTranscriptLocation()) + ", persons=" + String.valueOf(this.getPersons()) + ", transcriptionRuleSet=" + String.valueOf(this.getTranscriptionRuleSet()) + ", confidenceThreshold=" + this.getConfidenceThreshold() + ", asrEngineKey=" + this.getAsrEngineKey() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalCreationInfo)) {
            return false;
        }
        LocalCreationInfo other = (LocalCreationInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getConfidenceThreshold(), other.getConfidenceThreshold()) != 0) {
            return false;
        }
        Version this$usedETVersion = this.getUsedETVersion();
        Version other$usedETVersion = other.getUsedETVersion();
        if (this$usedETVersion == null ? other$usedETVersion != null : !this$usedETVersion.equals(other$usedETVersion)) {
            return false;
        }
        ArrayList this$domainDictionary = this.getDomainDictionary();
        ArrayList other$domainDictionary = other.getDomainDictionary();
        if (this$domainDictionary == null ? other$domainDictionary != null : !((Object)this$domainDictionary).equals(other$domainDictionary)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Path this$transcriptLocation = this.getTranscriptLocation();
        Path other$transcriptLocation = other.getTranscriptLocation();
        if (this$transcriptLocation == null ? other$transcriptLocation != null : !((Object)this$transcriptLocation).equals(other$transcriptLocation)) {
            return false;
        }
        List this$persons = this.getPersons();
        List other$persons = other.getPersons();
        if (this$persons == null ? other$persons != null : !((Object)this$persons).equals(other$persons)) {
            return false;
        }
        TranscriptionRuleSet this$transcriptionRuleSet = this.getTranscriptionRuleSet();
        TranscriptionRuleSet other$transcriptionRuleSet = other.getTranscriptionRuleSet();
        if (this$transcriptionRuleSet == null ? other$transcriptionRuleSet != null : !this$transcriptionRuleSet.equals(other$transcriptionRuleSet)) {
            return false;
        }
        String this$asrEngineKey = this.getAsrEngineKey();
        String other$asrEngineKey = other.getAsrEngineKey();
        return !(this$asrEngineKey == null ? other$asrEngineKey != null : !this$asrEngineKey.equals(other$asrEngineKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalCreationInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $confidenceThreshold = Double.doubleToLongBits(this.getConfidenceThreshold());
        result = result * 59 + (int)($confidenceThreshold >>> 32 ^ $confidenceThreshold);
        Version $usedETVersion = this.getUsedETVersion();
        result = result * 59 + ($usedETVersion == null ? 43 : $usedETVersion.hashCode());
        ArrayList $domainDictionary = this.getDomainDictionary();
        result = result * 59 + ($domainDictionary == null ? 43 : ((Object)$domainDictionary).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Path $transcriptLocation = this.getTranscriptLocation();
        result = result * 59 + ($transcriptLocation == null ? 43 : ((Object)$transcriptLocation).hashCode());
        List $persons = this.getPersons();
        result = result * 59 + ($persons == null ? 43 : ((Object)$persons).hashCode());
        TranscriptionRuleSet $transcriptionRuleSet = this.getTranscriptionRuleSet();
        result = result * 59 + ($transcriptionRuleSet == null ? 43 : $transcriptionRuleSet.hashCode());
        String $asrEngineKey = this.getAsrEngineKey();
        result = result * 59 + ($asrEngineKey == null ? 43 : $asrEngineKey.hashCode());
        return result;
    }

    @Generated
    public Version getUsedETVersion() {
        return this.usedETVersion;
    }

    @Generated
    public ArrayList<String> getDomainDictionary() {
        return this.domainDictionary;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public Path getTranscriptLocation() {
        return this.transcriptLocation;
    }

    @Generated
    public List<Person> getPersons() {
        return this.persons;
    }

    @Generated
    public TranscriptionRuleSet getTranscriptionRuleSet() {
        return this.transcriptionRuleSet;
    }

    @Generated
    public double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    @Generated
    public String getAsrEngineKey() {
        return this.asrEngineKey;
    }

    @Generated
    public void setUsedETVersion(Version usedETVersion) {
        this.usedETVersion = usedETVersion;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setTranscriptLocation(Path transcriptLocation) {
        this.transcriptLocation = transcriptLocation;
    }

    @Generated
    public void setPersons(List<Person> persons) {
        this.persons = persons;
    }

    @Generated
    public void setTranscriptionRuleSet(TranscriptionRuleSet transcriptionRuleSet) {
        this.transcriptionRuleSet = transcriptionRuleSet;
    }

    @Generated
    public void setConfidenceThreshold(double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    @Generated
    public void setAsrEngineKey(String asrEngineKey) {
        this.asrEngineKey = asrEngineKey;
    }
}

