/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.configs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.ewerkzeug.easytranscript3.commons.PairDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.KeyCombinationDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.KeyCombinationSerializer;
import eu.ewerkzeug.easytranscript3.commons.types.PathDeserializer;
import java.nio.file.Path;
import javafx.scene.input.KeyCombination;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.boot.jackson.autoconfigure.JsonMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.introspect.VisibilityChecker;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.std.ToStringSerializer;

@Configuration
public class JacksonConfig {
    @Bean
    public JsonMapperBuilderCustomizer etJacksonCustomizer() {
        return builder -> {
            SimpleModule etModule = new SimpleModule("EasyTranscriptModule");
            etModule.addDeserializer(Pair.class, (ValueDeserializer)new PairDeserializer());
            etModule.addSerializer(KeyCombination.class, (ValueSerializer)new KeyCombinationSerializer(KeyCombination.class));
            etModule.addDeserializer(KeyCombination.class, (ValueDeserializer)new KeyCombinationDeserializer());
            etModule.addSerializer(Path.class, (ValueSerializer)ToStringSerializer.instance);
            etModule.addDeserializer(Path.class, (ValueDeserializer)new PathDeserializer());
            builder.addModule((JacksonModule)etModule);
            builder.changeDefaultVisibility(arg_0 -> this.configureVisibility(arg_0));
            builder.enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT});
            builder.disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
            builder.enable(new DatatypeFeature[]{DateTimeFeature.WRITE_DATES_WITH_ZONE_ID});
        };
    }

    private VisibilityChecker configureVisibility(VisibilityChecker visibilityChecker) {
        return visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
    }
}

