/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations.transcriptmigrations;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.migrations.TranscriptMigration;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class V3_0_0_BETA17__File_Format_Change
implements TranscriptMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V3_0_0_BETA17__File_Format_Change.class);
    private final SaveTranscriptService saveTranscriptService;
    private final TranscriptService transcriptService;

    public void migrate(Transcript transcript) {
        log.debug("Migrating to zipped transcript file format...");
        Path transcriptLocation = transcript.getTranscriptLocation();
        try {
            Path backup = transcriptLocation.getParent().resolve(String.valueOf(transcriptLocation.getFileName()) + ".old");
            if (transcript.getMediaLocation().getParent() == null) {
                transcript.setMediaLocation(transcriptLocation.getParent().resolve(transcript.getMediaLocation()));
            }
            Files.move(transcriptLocation, backup, new CopyOption[0]);
            this.saveTranscriptService.save(transcript, transcript.getDocument(), true);
            this.transcriptService.reloadTranscriptProperties(transcript);
            Files.delete(backup);
        }
        catch (IOException e) {
            log.error("Failed to migrate.", (Throwable)e);
        }
    }

    public Version getTargetVersion() {
        return new Version.Builder().setNormalVersion("3.0.0").setPreReleaseVersion(new String[]{"BETA.17"}).build();
    }

    @Generated
    public V3_0_0_BETA17__File_Format_Change(SaveTranscriptService saveTranscriptService, TranscriptService transcriptService) {
        this.saveTranscriptService = saveTranscriptService;
        this.transcriptService = transcriptService;
    }
}

