/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations.upgrademigrations;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.migrations.ProgramMigration;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.EncryptionService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class V3_0_0_BETA_26__Auth_Details_In_Pref
implements ProgramMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V3_0_0_BETA_26__Auth_Details_In_Pref.class);
    private static final Path VAULT_PATH = Path.of(Configuration.ET_HOME + "/vault", new String[0]);
    private static final Path TOKEN_PATH = Path.of(Configuration.ET_HOME + "/auth.token", new String[0]);
    private final LicenseService licenseService;
    private final EncryptionService encryptionService;

    public void migrate() {
        log.debug("Deleting old token file ...");
        try {
            Files.deleteIfExists(TOKEN_PATH);
        }
        catch (IOException e) {
            log.error("Could not delete token file.", (Throwable)e);
        }
        log.debug("Deleted old token file.");
        log.debug("Saving credentials from file to pref ...");
        try {
            Pair decryptedPair = (Pair)this.encryptionService.decrypt(Files.readAllBytes(VAULT_PATH));
            this.licenseService.saveCredentials((String)decryptedPair.getLeft(), (String)decryptedPair.getRight());
        }
        catch (IOException e) {
            log.error("Could not migrate credentials from file to preferences.", (Throwable)e);
        }
        log.debug("Saved credentials.");
        log.debug("Deleting old vault ...");
        try {
            Files.deleteIfExists(VAULT_PATH);
        }
        catch (IOException e) {
            log.error("Could not delete vault file.", (Throwable)e);
        }
        log.debug("Deleted old vault ...");
    }

    public boolean isApplicable() {
        return Files.exists(VAULT_PATH, new LinkOption[0]) || Files.exists(TOKEN_PATH, new LinkOption[0]);
    }

    public Version getVersionOfChange() {
        return new Version.Builder().setNormalVersion("3.0.0").setPreReleaseVersion(new String[]{"BETA.26"}).build();
    }

    @Generated
    public V3_0_0_BETA_26__Auth_Details_In_Pref(LicenseService licenseService, EncryptionService encryptionService) {
        this.licenseService = licenseService;
        this.encryptionService = encryptionService;
    }
}

