/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations.upgrademigrations;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.migrations.ProgramMigration;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class V3_1_0_BETA_1__Rename_credential_files
implements ProgramMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V3_1_0_BETA_1__Rename_credential_files.class);
    private static final Path OLD_CREDS_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve("creds");
    private static final Path VERY_OLD_TOKEN_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve("auth.token");
    private static final Path OLD_LICENSE_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve("license.bin");
    public static final Path CREDS_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve(".creds");

    public void migrate() throws Exception {
        Files.deleteIfExists(VERY_OLD_TOKEN_PATH);
        if (Files.exists(OLD_CREDS_PATH, new LinkOption[0]) && !Files.exists(CREDS_PATH, new LinkOption[0])) {
            Files.move(OLD_CREDS_PATH, CREDS_PATH, new CopyOption[0]);
            Utils.markAsHidden((Path)CREDS_PATH);
        }
        Path licensePath = Path.of(LicenseValidationService.LICENSE_PATH, new String[0]);
        if (Files.exists(OLD_LICENSE_PATH, new LinkOption[0]) && !Files.exists(licensePath, new LinkOption[0])) {
            Files.move(OLD_LICENSE_PATH, licensePath, new CopyOption[0]);
            Utils.markAsHidden((Path)licensePath);
        }
    }

    public boolean isApplicable() {
        return Files.exists(OLD_CREDS_PATH, new LinkOption[0]) || Files.exists(VERY_OLD_TOKEN_PATH, new LinkOption[0]) || Files.exists(OLD_LICENSE_PATH, new LinkOption[0]);
    }

    public Version getVersionOfChange() {
        return new Version.Builder().setVersionCore(3L, 1L, 0L).setPreReleaseVersion(new String[]{"BETA.1"}).build();
    }

    @Generated
    public V3_1_0_BETA_1__Rename_credential_files() {
    }
}

