/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations.upgrademigrations;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.CredentialsService;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.migrations.ProgramMigration;
import eu.ewerkzeug.easytranscript3.service.EncryptionService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class V3_4_2_BETA_1__Move_Creds_To_Keyring
implements ProgramMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V3_4_2_BETA_1__Move_Creds_To_Keyring.class);
    private static final Path OLD_CREDS_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve(".creds");
    private static final Path OLD_DEVICE_ID_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve(".instance_info.dat");
    private final CredentialsService credentialsService;
    private final EncryptionService encryptionService;

    public V3_4_2_BETA_1__Move_Creds_To_Keyring(CredentialsService credentialsService, EncryptionService encryptionService) {
        this.credentialsService = credentialsService;
        this.encryptionService = encryptionService;
    }

    public void migrate() {
        log.info("Starting migration of credentials to system keyring...");
        try {
            if (Files.exists(OLD_CREDS_PATH, new LinkOption[0])) {
                byte[] auth = Files.readAllBytes(OLD_CREDS_PATH);
                this.credentialsService.storeCredentials(auth);
                log.debug("Credentials successfully moved to keyring.");
                Files.delete(OLD_CREDS_PATH);
                log.info("Old credentials file deleted.");
            }
            if (Files.exists(OLD_DEVICE_ID_PATH, new LinkOption[0])) {
                log.info("Migrating Device ID...");
                byte[] encrypted = Files.readAllBytes(OLD_DEVICE_ID_PATH);
                String deviceId = (String)this.encryptionService.decrypt(encrypted);
                this.credentialsService.storeDeviceId(deviceId);
                log.debug("Device ID successfully moved to keyring.");
                Files.delete(OLD_DEVICE_ID_PATH);
                log.info("Old Device ID file deleted.");
            }
        }
        catch (Exception e) {
            log.error("Failed to migrate credentials/device-id to keyring. Old files remain untouched.", (Throwable)e);
        }
    }

    public boolean isApplicable() {
        return this.credentialsService.isKeyringSupportedPlatform() && (Files.exists(OLD_CREDS_PATH, new LinkOption[0]) || Files.exists(OLD_DEVICE_ID_PATH, new LinkOption[0]));
    }

    public Version getVersionOfChange() {
        return new Version.Builder().setVersionCore(3L, 4L, 2L).setPreReleaseVersion(new String[]{"BETA.1"}).build();
    }

    public String getDescription() {
        return "Move credentials from insecure .creds file to System Keyring";
    }
}

