/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc;

import com.jthemedetecor.OsThemeDetector;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.fx.WindowManagerService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.ThemeService;
import java.util.HashSet;
import java.util.MissingResourceException;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxWeaver;
import org.reactfx.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendedController.class);
    public Stage stage;
    public Parent root;
    @Autowired
    public FxWeaver fxWeaver;
    @Autowired
    public MessageService messageService;
    @Autowired
    public ExceptionAlert exceptionAlert;
    @Autowired
    private WindowManagerService windowManagerService;
    @Autowired
    private ThemeService themeService;
    @Autowired
    private GuiStateService guiStateService;
    private HashSet<Subscription> subscriptions;

    private String getTitleField(Class<? extends ExtendedController> clazz) {
        if (!clazz.isAnnotationPresent(StageTitle.class)) {
            return "";
        }
        String title = clazz.getAnnotation(StageTitle.class).value();
        if (title.startsWith("%")) {
            try {
                return this.messageService.getLocaleBundle().getString(title.substring(1));
            }
            catch (MissingResourceException e) {
                log.error("String with key {} could not be found for controller {}", (Object)title, (Object)clazz.getName());
                return title;
            }
        }
        return title;
    }

    public abstract void reset();

    @FXML
    public final void initialize() {
        log.debug("Initializing stage for '{}' ...", (Object)this.getClass().getName());
        if (!this.guiStateService.isFree()) {
            this.stage = new Stage();
            log.debug("Created new stage.");
        } else {
            this.stage = this.guiStateService.getMainStage();
            log.debug("Used main stage.");
        }
        Scene scene = new Scene(this.getRoot());
        this.themeService.setStyleSheets(scene);
        log.debug("Initialized stage for '{}'.", (Object)this.getClass().getName());
        this.stage.setScene(scene);
        try {
            OsThemeDetector detector = OsThemeDetector.getDetector();
            detector.registerListener(arg_0 -> this.addIconsToStage(arg_0));
            this.addIconsToStage(detector.isDark());
        }
        catch (Exception e) {
            log.warn("Could not detect os theme for stage icons. Adding light icons.");
            this.addIconsToStage(false);
        }
        this.initializeController();
        Platform.runLater(() -> {
            if (this.stage == this.guiStateService.getMainStage() && this.getClass() == this.guiStateService.getController().getClass() && this.windowManagerService.hasStoredSizeAndPosition("/climbingperch/easytranscript/main")) {
                this.windowManagerService.setSizeAndPosition((Window)this.stage, "/climbingperch/easytranscript/main");
            } else {
                this.setDefaultSizeAndPosition();
                if (this.stage == this.guiStateService.getMainStage()) {
                    this.stage.show();
                }
            }
        });
    }

    private void addIconsToStage(boolean dark) {
        this.windowManagerService.addIconsToStage(this.getStage(), dark);
    }

    private void setDefaultSizeAndPosition() {
        this.stage.setMinWidth(Math.max(0.0, ((Region)this.getRoot()).getMinWidth()));
        this.stage.setMinHeight(Math.max(0.0, ((Region)this.getRoot()).getMinHeight()));
        this.stage.setHeight(Math.max(this.stage.getMinHeight(), ((Region)this.getRoot()).getPrefHeight()));
        this.stage.setWidth(Math.max(this.stage.getMinWidth(), ((Region)this.getRoot()).getPrefWidth()));
        this.stage.centerOnScreen();
    }

    public abstract void initializeController();

    public final void show() {
        log.debug("Resetting {} ...", (Object)this.getClass().getName());
        this.reset();
        log.debug("Showing {}.", (Object)this.getClass().getName());
        this.stage.show();
    }

    public final void showAdditionalScreen(Class<? extends ExtendedController> additionalController, Modality modality) {
        this.showAdditionalScreen(additionalController, modality, null, (Window)this.stage, false, null);
    }

    public final void showAdditionalScreen(Class<? extends ExtendedController> additionalController, Modality modality, Object userData) {
        this.showAdditionalScreen(additionalController, modality, null, (Window)this.stage, false, userData);
    }

    public final ExtendedController showAdditionalScreen(Class<? extends ExtendedController> additionalController, Modality modality, boolean resizable) {
        return this.showAdditionalScreen(additionalController, modality, null, (Window)this.stage, resizable, null);
    }

    public final ExtendedController showAdditionalScreen(Class<? extends ExtendedController> additionalController, Modality modality, StageStyle stageStyle, Window owner, boolean resizable, Object userData) {
        log.debug("Showing additional screen {}...", (Object)additionalController.getName());
        ExtendedController extendedController = this.prepareAdditionalScreen(additionalController, modality, stageStyle, owner, resizable);
        extendedController.getStage().setUserData(userData);
        extendedController.show();
        this.ensureStageFitsOnScreen(extendedController);
        return extendedController;
    }

    public final ExtendedController prepareAdditionalScreen(Class<? extends ExtendedController> additionalController, Modality modality, StageStyle stageStyle, Window owner, boolean resizable) {
        ExtendedController controller = null;
        try {
            controller = this.loadController(additionalController, modality, stageStyle, owner, resizable);
            controller.getStage().sizeToScene();
        }
        catch (Exception e) {
            log.error("Could not prepare controller {}", additionalController, (Object)e);
            this.exceptionAlert.showModal();
        }
        return controller;
    }

    public final void ensureStageFitsOnScreen(ExtendedController controller) {
        Rectangle2D bounds = this.windowManagerService.getScreenWithBiggestOverlap((Window)controller.getStage()).getBounds();
        if (controller.getStage().getWidth() > bounds.getWidth()) {
            controller.getStage().setWidth(Math.min(bounds.getWidth() - 10.0, controller.getStage().getMinWidth()));
        }
        if (controller.getStage().getHeight() > bounds.getHeight()) {
            controller.getStage().setHeight(Math.min(bounds.getHeight() - 10.0, controller.getStage().getMinHeight()));
        }
        controller.getStage().centerOnScreen();
    }

    private ExtendedController loadController(Class<? extends ExtendedController> controllerClass, Modality modality, StageStyle stageStyle, Window owner, boolean resizable) {
        ExtendedController controller = (ExtendedController)this.fxWeaver.loadController(controllerClass, this.messageService.getLocaleBundle());
        if (controller.getStage() != null) {
            if (modality != null) {
                controller.getStage().initModality(modality);
            }
            if (owner != null) {
                controller.getStage().initOwner(owner);
            }
            if (stageStyle != null) {
                if (stageStyle == StageStyle.TRANSPARENT) {
                    if (Platform.isSupported((ConditionalFeature)ConditionalFeature.TRANSPARENT_WINDOW)) {
                        controller.getStage().initStyle(StageStyle.TRANSPARENT);
                        controller.getStage().getScene().setFill((Paint)Color.TRANSPARENT);
                        ((Pane)controller.getStage().getScene().getRoot()).setPadding(new Insets(0.0, 5.0, 10.0, 5.0));
                    } else {
                        controller.getStage().initStyle(StageStyle.UNDECORATED);
                    }
                } else {
                    controller.getStage().initStyle(stageStyle);
                }
            }
        } else {
            throw new NullPointerException("Stage of controller for class %s is null.".formatted(controllerClass.getName()));
        }
        controller.getStage().setResizable(resizable);
        controller.getStage().setTitle(this.getTitleField(controllerClass));
        controller.getStage().setUserData((Object)controllerClass.getName());
        return controller;
    }

    public void loadTitle() {
        this.stage.setTitle(this.getTitleField(this.getClass()));
    }

    public HashSet<Subscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new HashSet();
        }
        return this.subscriptions;
    }

    public void unsubscribeAllSubscriptions() {
        this.subscriptions.forEach(Subscription::unsubscribe);
        this.subscriptions.clear();
    }

    @Generated
    public Stage getStage() {
        return this.stage;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public ExceptionAlert getExceptionAlert() {
        return this.exceptionAlert;
    }

    @Generated
    public WindowManagerService getWindowManagerService() {
        return this.windowManagerService;
    }

    @Generated
    public ThemeService getThemeService() {
        return this.themeService;
    }

    @Generated
    public GuiStateService getGuiStateService() {
        return this.guiStateService;
    }

    @Generated
    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @Generated
    public Parent getRoot() {
        return this.root;
    }

    @Generated
    public FxWeaver getFxWeaver() {
        return this.fxWeaver;
    }
}

