/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.about;

import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Year;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@FxmlView(value="aboutScreen.fxml")
@Component
@StageTitle(value="%aboutScreen.Title")
@Lazy
public class AboutController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AboutController.class);
    private final ConfigurationService configurationService;
    private final LicenseService licenseService;
    @FXML
    private Label copyrightDate;
    @FXML
    private Label versionLabel;
    @FXML
    private Label buildIDLabel;
    @FXML
    private Label buildDateLabel;
    @FXML
    private TextArea licenseTextArea;
    @FXML
    private Label licensee;

    public AboutController(ConfigurationService configurationService, LicenseService licenseService) {
        this.configurationService = configurationService;
        this.licenseService = licenseService;
    }

    @FXML
    public void initializeController() {
        log.debug("Initializing aboutController.");
        this.versionLabel.setText(this.configurationService.getVersion().toString());
        this.buildDateLabel.setText(this.configurationService.getCommitIdOfVersion());
        this.buildIDLabel.setText(this.configurationService.getCommitDateOfVersion());
        try {
            log.debug("Reading licenses.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.getClass().getResourceAsStream("/licenses.xml"));
            doc.getDocumentElement().normalize();
            this.licenseTextArea.setText(this.process3rdPartyLicenseXML(doc));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.warn("Could not read the licenses.xml file.", (Throwable)e);
        }
    }

    private String process3rdPartyLicenseXML(Document doc) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nList = doc.getElementsByTagName("dependency");
        for (int i = 0; i < nList.getLength(); ++i) {
            Node item = nList.item(i);
            if (item.getNodeType() != 1) continue;
            Element eElement = (Element)item;
            String artifactId = eElement.getElementsByTagName("artifactId").item(0).getTextContent();
            String version = eElement.getElementsByTagName("version").item(0).getTextContent();
            String license = "?";
            NodeList name = eElement.getElementsByTagName("name");
            if (name.getLength() > 0) {
                license = eElement.getElementsByTagName("name").item(0).getTextContent();
            }
            artifactId = StringUtils.capitalize((String)artifactId.replace("-", " "));
            stringBuilder.append(" \u2022 ").append(artifactId).append(" ").append(version).append(": ").append(license).append("\n");
        }
        stringBuilder.append("\n".repeat(20));
        return stringBuilder.toString();
    }

    public void reset() {
        String name;
        UserLicense license = this.licenseService.getUserLicense();
        log.debug("Filling labels with license information.");
        Object validUntil = "";
        if (license != null) {
            name = license.getDisplayName();
            if (license.getExpiryDate() != null && license.getExpiryDate().getTime() != Long.MAX_VALUE) {
                Locale locale = Locale.forLanguageTag(this.configurationService.getConfiguration().getProgramLanguage());
                validUntil = ", " + this.getMessageService().getLocaleBundle().getString("aboutScreen.licenseValidUntil") + DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withLocale(locale).withZone(ZoneId.systemDefault()).format(license.getExpiryDate().toInstant().atZone(ZoneId.systemDefault()));
            }
        } else {
            name = this.getMessageService().getLocaleBundle().getString("aboutScreen.licensedForTesting");
        }
        this.licensee.setText(name + (String)validUntil);
        this.copyrightDate.setText("\u00a9 Climbing Perch UG (haftungsbeschr\u00e4nkt), " + Year.now().getValue());
    }

    public void openLink(String link) {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(link));
            }
            catch (IOException | URISyntaxException e) {
                log.error("Could not open link {}", (Object)link, (Object)e);
            }
        }
    }

    public void openDataPrivacyURL() {
        this.openLink(this.getMessageService().getLocaleBundle().getString("createTranscriptScreen.privacyURL"));
    }

    public void openGTCURL() {
        this.openLink(this.getMessageService().getLocaleBundle().getString("aboutScreen.gtcURL"));
    }

    public void openImprintURL() {
        this.openLink(this.getMessageService().getLocaleBundle().getString("aboutScreen.imprintURL"));
    }
}

