/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.license;

import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import eu.ewerkzeug.easytranscript3.service.AutomaticTranscriptService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.io.IOException;
import java.nio.file.Files;
import java.security.SignatureException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javax.security.auth.login.AccountExpiredException;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.reactfx.EventStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

@FxmlView(value="licenseScreen.fxml")
@Component
@StageTitle(value="%licenseScreen.Title")
@Lazy
public class LicenseController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseController.class);
    private final LicenseService licenseService;
    private final SimpleBooleanProperty licenseSet = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty wrongCredentials = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty loading = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty accountCredentialsUsed = new SimpleBooleanProperty(true);
    private final STTDeletionService sttDeletionService;
    private final ConfigurationService configurationService;
    private final AlertService alertService;
    private final MessageService messageService;
    private final DialogService dialogService;
    @FXML
    private Label wrongLicenseKeyLabel;
    @FXML
    private JFXTextField licenseKeyField;
    @FXML
    private JFXTabPane tabPane;
    @FXML
    private VBox licenseeInformationVBox;
    @FXML
    private Text licensedForLabel;
    @FXML
    private Button activateButton;
    @FXML
    private Button cancelButton;
    @FXML
    private JFXTextField mailTextField;
    @FXML
    private JFXPasswordField passwordField;
    @FXML
    private Label licensee;
    @FXML
    private Label wrongCredentialsLabel;
    @FXML
    private Button deleteButton;
    @FXML
    private VBox inputFieldsVBox;

    private SimpleBooleanProperty licenseSetProperty() {
        return this.licenseSet;
    }

    public void initializeController() {
        log.debug("Initializing license controller.");
        this.licensee.visibleProperty().bind((ObservableValue)this.licenseSetProperty());
        this.licenseeInformationVBox.visibleProperty().bind((ObservableValue)this.licenseSetProperty());
        this.licenseeInformationVBox.managedProperty().bind((ObservableValue)this.licenseSetProperty());
        this.tabPane.visibleProperty().bind((ObservableValue)this.licenseSetProperty().not());
        this.tabPane.managedProperty().bind((ObservableValue)this.licenseSetProperty().not());
        this.tabPane.getTabs().forEach(tab -> tab.setText(tab.getText().toUpperCase()));
        this.accountCredentialsUsed.bind((ObservableValue)this.tabPane.getSelectionModel().selectedItemProperty().isEqualTo(this.tabPane.getTabs().getFirst()));
        this.activateButton.disableProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.accountCredentialsUsed, (ObservableBooleanValue)Bindings.or((ObservableBooleanValue)this.passwordField.textProperty().isEmpty(), (ObservableBooleanValue)this.mailTextField.textProperty().isEmpty())).or((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)this.accountCredentialsUsed.not(), (ObservableBooleanValue)this.licenseKeyField.textProperty().isEmpty())).or((ObservableBooleanValue)this.loading));
        this.cancelButton.disableProperty().bind((ObservableValue)this.loading);
        this.getSubscriptions().add(EventStreams.changesOf((ObservableValue)this.tabPane.getSelectionModel().selectedItemProperty()).subscribe(change -> {
            if (change.getNewValue() != this.tabPane.getTabs().getFirst()) {
                this.mailTextField.clear();
                this.passwordField.clear();
            } else {
                this.licenseKeyField.clear();
            }
            this.wrongCredentials.set(false);
        }));
        this.wrongCredentialsLabel.visibleProperty().bind((ObservableValue)this.wrongCredentials);
        this.wrongLicenseKeyLabel.visibleProperty().bind((ObservableValue)this.wrongCredentials);
        this.getSubscriptions().add(EventStreams.changesOf((ObservableValue)this.wrongCredentials).subscribe(change -> {
            if (((Boolean)change.getNewValue()).booleanValue()) {
                this.licenseService.clearCredentials();
            }
        }));
    }

    public void reset() {
        this.wrongCredentials.set(false);
        this.passwordField.clear();
        this.deleteButton.visibleProperty().bind((ObservableValue)this.licenseSet);
        this.inputFieldsVBox.visibleProperty().bind((ObservableValue)this.licenseSet.not());
        this.setCursorAndButton(Cursor.DEFAULT, false);
        this.setTexts();
    }

    private void setTexts() {
        log.debug("Filling labels with license information.");
        this.licenseSet.set(this.licenseService.getUserLicense() != null);
        if (!this.licenseSet.get()) {
            return;
        }
        this.licensedForLabel.setText(this.messageService.getLocaleBundle().getString("aboutScreen.licensedFor"));
        Object validUntil = "";
        String name = this.licenseService.getUserLicense().getDisplayName();
        Locale locale = Locale.forLanguageTag(this.configurationService.getConfiguration().getProgramLanguage());
        if (this.licenseService.getUserLicense().getExpiryDate() != null && this.licenseService.getUserLicense().getExpiryDate().getTime() != Long.MAX_VALUE) {
            validUntil = ", " + this.messageService.getLocaleBundle().getString("aboutScreen.licenseValidUntil") + DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).withLocale(locale).withZone(ZoneId.systemDefault()).format(this.licenseService.getUserLicense().getExpiryDate().toInstant().atZone(ZoneId.systemDefault()));
        }
        this.licensee.setText(name + (String)validUntil);
    }

    public void close() {
        ((Stage)this.cancelButton.getScene().getWindow()).close();
    }

    public void getLicense() {
        log.debug("Trying to activate this instance...");
        this.wrongCredentials.set(false);
        this.setCursorAndButton(Cursor.WAIT, true);
        UserLicense userLicense = this.licenseService.getUserLicense();
        if (userLicense != null) {
            log.debug("User license already loaded. Checking if the user of this license differs from the entered one.");
            if (this.licenseService.getLicenseCredentials() != null) {
                log.debug("Current username is: {}", this.licenseService.getLicenseCredentials().getLeft());
            }
            log.debug("New username is: {}", (Object)this.mailTextField.getText().trim());
        }
        if (this.accountCredentialsUsed.get()) {
            this.licenseService.saveCredentials(this.mailTextField.getText().trim(), this.passwordField.getText());
        } else {
            this.licenseService.saveLicenseKey(this.licenseKeyField.getText());
        }
        try {
            Disposable getLicenseRequest = this.licenseService.getLicenseFromServer(true).doOnError(WebClientResponseException.class, e -> {
                log.error("Could not get license.", (Throwable)e);
                this.handleErrorCases(e.getStatusCode());
            }).doOnError(WebClientRequestException.class, e -> {
                log.error("Could not get license.", (Throwable)e);
                this.alertService.showConnectionError();
            }).doOnTerminate(() -> {
                LicenseService.getDisposableHashMap().remove(this.getClass().getSimpleName());
                this.setCursorAndButton(Cursor.DEFAULT, false);
            }).subscribe(response -> {
                if (response.getStatusCode().is2xxSuccessful()) {
                    this.writeLicenseResponseBodyToFile(response);
                } else {
                    this.handleErrorCases(response.getStatusCode());
                }
            });
            LicenseService.getDisposableHashMap().put(this.getClass().getSimpleName(), getLicenseRequest);
        }
        catch (Exception e2) {
            this.exceptionAlert.showModal();
        }
    }

    private void handleErrorCases(HttpStatusCode httpStatus) {
        if (httpStatus.value() == HttpStatus.TOO_MANY_REQUESTS.value()) {
            Platform.runLater(() -> {
                this.setCursorAndButton(Cursor.DEFAULT, false);
                log.warn("License already activated for this user.");
                this.wrongCredentialsLabel.setText(this.messageService.getLocaleBundle().getString("licenseScreen.alreadyActivated"));
                this.wrongCredentials.set(true);
            });
        } else if (httpStatus.value() == HttpStatus.UNAUTHORIZED.value()) {
            Platform.runLater(() -> {
                this.setCursorAndButton(Cursor.DEFAULT, false);
                log.warn("Wrong credentials used.");
                this.wrongCredentialsLabel.setText(this.messageService.getLocaleBundle().getString("licenseScreen.passwordOrUsernameWrong"));
                this.wrongCredentials.set(true);
            });
        } else if (httpStatus.value() == HttpStatus.NOT_MODIFIED.value()) {
            log.info("License not modified since last check.");
            Platform.runLater(() -> {
                this.setCursorAndButton(Cursor.DEFAULT, false);
                this.setTexts();
                this.licenseService.showLicenseActivatedDialog();
                this.close();
            });
        } else if (httpStatus.is5xxServerError()) {
            log.error("Server error: {}", (Object)httpStatus);
            Platform.runLater(() -> {
                this.wrongCredentialsLabel.setText(this.messageService.getLocaleBundle().getString("general.noConnectionToServer"));
                this.wrongCredentials.set(true);
                this.setCursorAndButton(Cursor.DEFAULT, false);
            });
        } else {
            Platform.runLater(() -> {
                this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.couldNotGetLicense")).showAndWait();
                this.close();
            });
        }
    }

    private void writeLicenseResponseBodyToFile(ResponseEntity<ByteArrayResource> response) {
        ByteArrayResource body = (ByteArrayResource)response.getBody();
        if (body == null) {
            log.error("Body was empty!");
            this.removeLicense();
            this.reset();
            this.exceptionAlert.showModal();
            return;
        }
        byte[] byteArray = body.getByteArray();
        this.licenseService.writeByteArrayLicense(byteArray);
        this.checkAndLoadLicense();
        this.setCursorAndButton(Cursor.DEFAULT, false);
    }

    private void checkAndLoadLicense() {
        try {
            this.licenseService.loadLicenseFromDisk();
            this.setCursorAndButton(Cursor.DEFAULT, false);
            Platform.runLater(() -> {
                this.setTexts();
                this.licenseService.showLicenseActivatedDialog();
                this.close();
            });
        }
        catch (SignatureException e) {
            log.error("Signature of the license is invalid!", (Throwable)e);
            this.exceptionAlert.showModal();
            this.removeLicense();
            this.reset();
        }
        catch (AccountExpiredException e) {
            Platform.runLater(() -> ((LicenseService)this.licenseService).showLicenseNotValidDialog());
            this.removeLicense();
            this.reset();
        }
        catch (IOException | IllegalArgumentException e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
            this.removeLicense();
            this.reset();
        }
    }

    private void setCursorAndButton(Cursor cursor, boolean loading) {
        Platform.runLater(() -> {
            this.activateButton.getScene().setCursor(cursor);
            this.loading.set(loading);
        });
    }

    public void removeLicense() {
        this.root.getScene().setCursor(Cursor.WAIT);
        Mono logoutRequest = this.licenseService.logout();
        if (logoutRequest == null) {
            return;
        }
        Runnable doAfter = () -> {
            try {
                this.licenseService.deleteLocalLicense();
            }
            catch (IOException e) {
                log.error("Could not delete local license.", (Throwable)e);
                this.exceptionAlert.showModal();
            }
            Platform.runLater(() -> this.reset());
            this.root.getScene().setCursor(Cursor.DEFAULT);
            try {
                Files.deleteIfExists(AutomaticTranscriptService.AUTOMATIC_TRANSCRIPTION_INFORMATION_PATH);
            }
            catch (IOException e) {
                log.error("Could not delete atci.json", (Throwable)e);
            }
            this.sttDeletionService.cancelAllOngoingTransfers();
        };
        logoutRequest.subscribe(res -> {
            log.info("Logged out successfully.");
            doAfter.run();
        }, err -> {
            log.warn("Failed to logout.", err);
            if (err instanceof WebClientResponseException) {
                Platform.runLater(() -> this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.couldNotLogout")).showAndWait());
            }
            doAfter.run();
        });
    }

    @Generated
    public LicenseController(LicenseService licenseService, STTDeletionService sttDeletionService, ConfigurationService configurationService, AlertService alertService, MessageService messageService, DialogService dialogService) {
        this.licenseService = licenseService;
        this.sttDeletionService = sttDeletionService;
        this.configurationService = configurationService;
        this.alertService = alertService;
        this.messageService = messageService;
        this.dialogService = dialogService;
    }
}

