/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.mvc.main.TimeTrackingService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.DocumentSerializer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.reactfx.EventStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class CloseDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloseDialog.class);
    private final LicenseService licenseService;
    private final TimeTrackingService timeTrackingService;
    private final StatusService statusService;
    private final SaveTranscriptService saveTranscriptService;
    private final STTDeletionService deletionService;
    private final STTStatusService sttStatusService;
    private final TranscriptTextArea transcriptTextArea;
    private final LicenseValidationService licenseValidationService;
    private final STTDialogService sTTDialogService;
    private final DocumentSerializer documentSerializer;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final TranscriptService transcriptService;
    private final GuiStateService guiStateService;
    private ETDialog alert;

    public void showAndWait(Runnable runnable) {
        this.showAndWait(true, runnable);
    }

    public void showAndWait(boolean showUploadDownloadCancelAlert, Runnable runnable) {
        log.debug("creating close dialog...");
        this.createSaveAlert();
        ETDialog uploadDownloadCancelDialog = null;
        if (showUploadDownloadCancelAlert) {
            uploadDownloadCancelDialog = this.sTTDialogService.createUploadDownloadCancelAlert(this.sttStatusService.isDownloading(), this.sttStatusService.isUploading());
        }
        if (uploadDownloadCancelDialog != null) {
            ButtonType buttonType = uploadDownloadCancelDialog.showAndWait();
            if (buttonType != null && buttonType.equals(ButtonType.YES)) {
                this.deletionService.cancelAllOngoingTransfers();
                this.handleUnsavedAndCleanup(runnable);
            }
        } else {
            this.handleUnsavedAndCleanup(runnable);
        }
    }

    private void handleUnsavedAndCleanup(Runnable runnable) {
        Runnable handleUnsavedLogic = () -> {
            if (!this.isTranscriptUnsaved()) {
                this.saveTranscriptService.clearQueue();
                if (this.licenseValidationService.isUserLicenseValid() && this.timeTrackingService.addTimeTracked()) {
                    log.debug("Saving time tracking entry before closing the saved transcript ...");
                    this.saveTranscriptService.save(this.transcriptService.getCurrentTranscript(), this.documentSerializer.serializeContent(this.transcriptTextArea.getDocument()), true);
                }
                runnable.run();
                return;
            }
            ButtonType result = this.alert.showAndWait();
            if (result == null) {
                return;
            }
            if (result == ButtonType.YES) {
                if (this.licenseValidationService.isUserLicenseValid()) {
                    this.timeTrackingService.addTimeTracked();
                    this.saveTranscriptService.save(this.transcriptService.getCurrentTranscript(), this.documentSerializer.serializeContent(this.transcriptTextArea.getDocument()), true);
                    this.saveTranscriptService.clearQueue();
                    runnable.run();
                } else {
                    this.licenseService.showLicenseNotValidDialog();
                }
            } else if (result == ButtonType.NO) {
                this.saveTranscriptService.clearQueue();
                runnable.run();
            }
        };
        if (this.statusService.isSaving()) {
            ((MainController)this.guiStateService.getController()).getProgressBarController().show();
            EventStreams.changesOf((ObservableValue)this.statusService.savingProperty()).subscribeForOne(booleanChange -> {
                ((MainController)this.guiStateService.getController()).getProgressBarController().getStage().hide();
                handleUnsavedLogic.run();
            });
        } else {
            handleUnsavedLogic.run();
        }
    }

    private boolean isTranscriptUnsaved() {
        return this.transcriptService.getCurrentTranscript() != null && this.transcriptService.getCurrentTranscript().getTranscriptLocation() != null && !this.statusService.isSaved();
    }

    private void createSaveAlert() {
        if (this.alert != null) {
            return;
        }
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType buttonTypeYes = new ETButtonType(ButtonType.YES, true, false);
        ETButtonType buttonTypeNo = new ETButtonType(ButtonType.NO, false, false);
        ETButtonType buttonTypeCancel = new ETButtonType(ButtonType.CANCEL, false, true);
        buttons.add(buttonTypeYes);
        buttons.add(buttonTypeNo);
        buttons.add(buttonTypeCancel);
        this.alert = this.dialogService.createDialog("", this.messageService.getLocaleBundle().getString("mainScreen.unsavedChanges"), Modality.WINDOW_MODAL, buttons);
        log.debug("Initialized close dialog.");
    }

    @Generated
    public CloseDialog(LicenseService licenseService, TimeTrackingService timeTrackingService, StatusService statusService, SaveTranscriptService saveTranscriptService, STTDeletionService deletionService, STTStatusService sttStatusService, TranscriptTextArea transcriptTextArea, LicenseValidationService licenseValidationService, STTDialogService sTTDialogService, DocumentSerializer documentSerializer, MessageService messageService, DialogService dialogService, TranscriptService transcriptService, GuiStateService guiStateService) {
        this.licenseService = licenseService;
        this.timeTrackingService = timeTrackingService;
        this.statusService = statusService;
        this.saveTranscriptService = saveTranscriptService;
        this.deletionService = deletionService;
        this.sttStatusService = sttStatusService;
        this.transcriptTextArea = transcriptTextArea;
        this.licenseValidationService = licenseValidationService;
        this.sTTDialogService = sTTDialogService;
        this.documentSerializer = documentSerializer;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.transcriptService = transcriptService;
        this.guiStateService = guiStateService;
    }
}

