/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main;

import com.jthemedetecor.OsThemeDetector;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.TutorialService;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.CustomLineNumberFactory;
import eu.ewerkzeug.easytranscript3.commons.fx.WindowManagerService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETPopOver;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.PopOverService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.CustomDrawer;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.tutorials.CreateTranscriptTutorial;
import eu.ewerkzeug.easytranscript3.commons.tutorials.DrawerTutorial;
import eu.ewerkzeug.easytranscript3.commons.tutorials.PlayerBarTutorial;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.Theme;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.GenerationState;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.configs.ScheduledLicenseValidation;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.mvc.main.MiscService;
import eu.ewerkzeug.easytranscript3.mvc.main.TimerService;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerController;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.InputMapService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.MenuBarController;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.MenuBarService;
import eu.ewerkzeug.easytranscript3.mvc.main.playerbar.PlayerBarController;
import eu.ewerkzeug.easytranscript3.mvc.main.progressbar.ProgressBarController;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerService;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterController;
import eu.ewerkzeug.easytranscript3.mvc.welcome.WelcomeScreenController;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.AutomaticTranscriptService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.reactfx.EventStreams;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="main.fxml")
@Component
@Lazy
public class MainController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainController.class);
    private final MiscService miscService;
    private final LoadTranscriptService loadTranscriptService;
    private final TimerService timerService;
    private final PlayerService playerService;
    private final TextAreaService textAreaService;
    private final InputMapService inputMapService;
    private final MenuBarService menuBarService;
    private final StatusService statusService;
    private final DrawerService drawerService;
    private final TutorialService tutorialService;
    private final DrawerController drawerController;
    private final ScheduledLicenseValidation scheduledLicenseValidation;
    private final ExecutorService executorService;
    private final STTService sttService;
    private final STTDeletionService sttDeletionService;
    private final STTStatusService sttStatusService;
    private final WindowManagerService windowManagerService;
    private final TranscriptTextArea transcriptTextArea;
    private final ConfigurationService configurationService;
    private final LicenseValidationService licenseValidationService;
    private final PopOverService popOverService;
    private final CreateTranscriptTutorial createTranscriptTutorial;
    private final MessageService messageService;
    private final DrawerTutorial drawerTutorial;
    private final PlayerBarTutorial playerBarTutorial;
    private final AutomaticTranscriptService automaticTranscriptService;
    private final TranscriptService transcriptService;
    @FXML
    private Pane linenoBackground;
    private ProgressBarController progressBarController;
    @FXML
    private Button helpFab;
    @FXML
    private BorderPane mainBorderPane;
    @FXML
    private CustomDrawer drawer;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane leftAnchorPane;
    @FXML
    private AnchorPane rightAnchorPane;
    @FXML
    private StackPane leftStackPane;
    @FXML
    private PlayerBarController playerBarController;
    @FXML
    private MenuBarController menuBarController;
    private Stage videoWindow;
    private ETPopOver helpContextMenu;

    public void initializeController() {
        log.debug("Initializing main...");
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        task.setOnScheduled(workerStateEvent -> log.debug("Init-Task scheduled."));
        task.setOnRunning(workerStateEvent -> log.debug("Init-Task running."));
        task.setOnSucceeded(workerStateEvent -> Platform.runLater(() -> {
            if (this.configurationService.getConfiguration().isDrawerExpanded()) {
                this.drawer.open();
            }
            this.getGuiStateService().getController().root.layout();
            this.getGuiStateService().getController().root.requestLayout();
            this.getGuiStateService().getMainStage().setWidth(this.getGuiStateService().getMainStage().getWidth() - 1.0);
        }));
        task.setOnFailed(arg_0 -> this.lambda$initializeController$4((Task)task, arg_0));
        this.executorService.submit((Runnable)task);
    }

    private void runFirstLicenseValidation() {
        Utils.setProgramInitialized((boolean)true);
        this.scheduledLicenseValidation.validateLicense();
    }

    private void initView() {
        Platform.runLater(() -> {
            this.miscService.setTitle();
            this.menuBarService.getUseSystemBarMenu().set(true);
            this.drawer.setSidePane(new Node[]{this.getFxWeaver().loadView(DrawerController.class, this.messageService.getLocaleBundle())});
            this.drawer.setResizableOnDrag(false);
            this.drawer.setResizeContent(false);
        });
        this.drawerService.getDrawerExpandedProperty().addListener((observableValue, bl, newValue) -> {
            if (Boolean.TRUE.equals(newValue)) {
                this.drawer.open();
            } else {
                this.drawer.close();
            }
            this.configurationService.getConfiguration().setDrawerExpanded(newValue.booleanValue());
        });
        try {
            OsThemeDetector detector = OsThemeDetector.getDetector();
            detector.registerListener(isDark -> {
                if (this.configurationService.getConfiguration().getTheme() != Theme.SYNC_WITH_OS) {
                    return;
                }
                this.getThemeService().reapplyTheme();
            });
        }
        catch (Exception e) {
            log.error("Failed to detect theme.", (Throwable)e);
            this.configurationService.getConfiguration().setTheme(Theme.DARK);
            this.getThemeService().reapplyTheme();
        }
        EventStreams.changesOf((ObservableValue)this.configurationService.getConfiguration().showParagraphNumbersProperty()).subscribe(change -> this.configureParagraphNumbers());
        EventStreams.changesOf((ObservableValue)this.configurationService.getConfiguration().widthOfTextAreaInCmProperty()).subscribe(change -> this.setWidthOfTranscriptTextArea());
        this.leftStackPane.maxWidthProperty().bind((ObservableValue)this.splitPane.widthProperty().subtract((ObservableNumberValue)this.drawer.widthProperty()).add(this.drawer.getMiniDrawerSize()));
    }

    private void initPlayer() {
        this.playerService.createPlayer();
        AnchorPane.setRightAnchor((Node)this.splitPane, (Double)(this.drawer.getMiniDrawerSize() + 5.0));
        this.setAnchorPanePropertiesForPlayerPane();
        Main.getPlayer().stateProperty().addListener((observableValue, playerState, newVal) -> {
            if (Objects.requireNonNull(newVal) == PlayerState.LOADED) {
                Platform.runLater(() -> {
                    this.playerBarController.initializePlayerBar();
                    this.playerBarController.resetSliders();
                    log.debug("Removing and adding video pane...");
                    this.rightAnchorPane.getChildren().clear();
                    this.handleVideoWindowChange();
                    this.setSplitPanePosition();
                });
            }
        });
        EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadedProperty()).subscribe(change -> {
            if (!((Boolean)change.getNewValue()).booleanValue()) {
                this.drawerController.closeDrawer();
                this.closeSeparateVideoWindow();
                this.setSplitPanePosition();
            }
        });
        this.configurationService.getConfiguration().integrateVideoplayerProperty().addListener((observableValue, bl, bl2) -> {
            if (this.transcriptTextArea.isVisible()) {
                this.handleVideoWindowChange();
                this.setSplitPanePosition();
                this.configurationService.save();
            }
        });
    }

    private void initializeProgressBarModal() {
        Platform.runLater(() -> {
            this.progressBarController = (ProgressBarController)this.getGuiStateService().getController().prepareAdditionalScreen(ProgressBarController.class, Modality.APPLICATION_MODAL, StageStyle.TRANSPARENT, (Window)this.getGuiStateService().getMainStage(), false);
        });
        EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadingProperty()).or(EventStreams.changesOf((ObservableValue)this.statusService.savingProperty())).subscribe(either -> {
            if (this.statusService.isTranscriptLoading() || this.statusService.isSaving() && this.statusService.isShowProgressForSaving()) {
                log.debug("Transcript is loading or saving, showing loading bar ...");
                Platform.runLater(() -> {
                    this.progressBarController.show();
                    this.progressBarController.getStage().sizeToScene();
                    this.progressBarController.getStage().centerOnScreen();
                    this.progressBarController.getStage().toFront();
                });
            }
            this.showTranscriptWasMigrated();
        });
    }

    private void showTranscriptWasMigrated() {
        if (!this.statusService.isSaving() && !this.statusService.isTranscriptLoading()) {
            Platform.runLater(() -> {
                if (this.progressBarController != null) {
                    this.progressBarController.getStage().hide();
                }
                if (this.statusService.isTranscriptWasMigrated()) {
                    this.popOverService.showSnackbar(this.messageService.getLocaleBundle().getString("general.transcriptUpdated"), this.messageService.getLocaleBundle().getString("general.transcriptUpdatedDetails"), Duration.ofMillis(5000L));
                    this.statusService.setTranscriptWasMigrated(false);
                }
            });
        }
    }

    private void initializeTextArea() {
        log.debug("Initializing Transcript TextArea.");
        VirtualizedScrollPane vsPane = this.transcriptTextArea.getVsPane();
        log.debug("Adding virtual scroll to transcript anchor pane.");
        Platform.runLater(() -> {
            this.leftAnchorPane.getChildren().add(1, (Object)vsPane);
            AnchorPane.setLeftAnchor((Node)vsPane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)vsPane, (Double)0.0);
            AnchorPane.setTopAnchor((Node)vsPane, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)vsPane, (Double)0.0);
            this.setWidthOfTranscriptTextArea();
            this.configureParagraphNumbers();
        });
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Collection)this.menuBarService.createEditMenuItems(false));
        this.transcriptTextArea.setContextMenu(contextMenu);
        this.textAreaService.initializeListeners();
        this.inputMapService.addInputMaps();
        EventStreams.changesOf((ObservableValue)this.transcriptTextArea.getScaledVirtualized().getZoom().xProperty()).subscribe(numberChange -> Platform.runLater(() -> this.linenoBackground.setScaleX(Math.max(1.0, 1.0 + (((Number)numberChange.getNewValue()).doubleValue() - 1.0) * 1.6))));
        Val nParagraphs = LiveList.sizeOf((ObservableList)this.transcriptTextArea.getParagraphs());
        EventStreams.changesOf((ObservableValue)nParagraphs).subscribe(change -> {
            int length = (int)(Math.log10(((Integer)nParagraphs.getOrElse((Object)1)).intValue()) + 1.0);
            this.linenoBackground.setPrefWidth((double)Math.max(30, length * 10));
            int pivotX = switch (length) {
                case 1 -> 10;
                case 2 -> 8;
                case 3 -> 5;
                case 4 -> 5;
                case 5 -> 2;
                case 6 -> 1;
                default -> 0;
            };
            this.transcriptTextArea.getScaledVirtualized().getZoom().setPivotX((double)pivotX);
        });
    }

    private void checkForRunningAutomaticTranscription() {
        log.debug("Searching for running automatic transcription ...");
        this.sttService.getJobStatus().doOnError(e -> log.error("", e)).subscribe(projectStatus -> {
            if (projectStatus.getBody() == null || ((AutomaticTranscriptStatus)projectStatus.getBody()).getUuid() == null) {
                log.debug("No currently running project found.");
                return;
            }
            AutomaticTranscriptStatus status = (AutomaticTranscriptStatus)projectStatus.getBody();
            this.automaticTranscriptService.load();
            AutomaticTranscriptCreationInfo localProjectInfo = this.automaticTranscriptService.getCurrentInfo();
            if (localProjectInfo != null && localProjectInfo.getUuid() != null && status.getUuid().equals(localProjectInfo.getUuid())) {
                log.debug("UUID of automatic transcript creation info is equal to retrieved UUID");
            } else {
                log.debug("UUID of automatic transcript creation info is not equal to retrieved UUID");
                this.automaticTranscriptService.deleteSavedFile();
                this.automaticTranscriptService.reset();
                localProjectInfo = this.automaticTranscriptService.getCurrentInfo();
                localProjectInfo.setUuid(status.getUuid());
            }
            if (!GenerationState.isTranscriptGenerationInProgress((GenerationState)status.getStatus())) {
                log.debug("Transcription job {} is in an unrecoverable state: {}", (Object)status.getUuid(), (Object)status.getStatus());
                this.sttDeletionService.deleteTranscriptionJob().subscribe();
            }
            if (status.getStatus().equals((Object)GenerationState.FINISHED)) {
                this.sttStatusService.startDownloadOfTranscript();
            } else if (!status.getStatus().equals((Object)GenerationState.NOT_RUNNING) && !status.getStatus().equals((Object)GenerationState.ERROR)) {
                this.sttStatusService.switchToGeneratingPhase();
                this.sttStatusService.getTransferProgressInfo().setEtaFromGenerationServer((long)((AutomaticTranscriptStatus)projectStatus.getBody()).getEta());
                this.sttStatusService.getTransferProgressInfo().getCompletedUploads().add((Object)"");
                this.sttStatusService.getTransferProgressInfo().getCompletedUploads().setAll(this.automaticTranscriptService.getCurrentInfo().getPersons().subList(0, ((AutomaticTranscriptStatus)projectStatus.getBody()).getCurrentPerson()).stream().map(Person::getUuid).toList());
            }
        });
    }

    private void setAnchorPanePropertiesForPlayerPane() {
        AnchorPane.setLeftAnchor((Node)Main.getPlayer().getPlayerPane(), (Double)11.0);
        AnchorPane.setRightAnchor((Node)Main.getPlayer().getPlayerPane(), (Double)6.0);
        AnchorPane.setTopAnchor((Node)Main.getPlayer().getPlayerPane(), (Double)0.0);
        AnchorPane.setBottomAnchor((Node)Main.getPlayer().getPlayerPane(), (Double)0.0);
    }

    private void handleVideoWindowChange() {
        log.debug("Setting video window...");
        Platform.runLater(() -> {
            if (Main.getPlayer() == null || this.transcriptService.getCurrentTranscript().getMediaLocation() == null) {
                log.warn("Could not change video window, because either the player or the media location is null");
                this.closeSeparateVideoWindow();
                return;
            }
            if (!Main.getPlayer().isVideo()) {
                log.debug("Media has no video.");
                this.closeSeparateVideoWindow();
                return;
            }
            if (!this.configurationService.getConfiguration().isIntegrateVideoplayer()) {
                this.showSeparateVideoWindow();
            } else {
                this.integrateVideoWindow();
            }
        });
    }

    private void closeSeparateVideoWindow() {
        if (this.videoWindow != null && this.videoWindow.isShowing()) {
            this.videoWindow.close();
        }
    }

    private void showSeparateVideoWindow() {
        double height;
        double width;
        Pane parent = (Pane)Main.getPlayer().getPlayerPane().getParent();
        if (parent != null) {
            parent.getChildren().remove((Object)Main.getPlayer().getPlayerPane());
        }
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        Dimension videoDimension = Main.getPlayer().getVideoDimension();
        if (videoDimension == null) {
            return;
        }
        double aspectRatio = videoDimension.getWidth() / videoDimension.getHeight();
        if (aspectRatio > 1.0) {
            width = Math.min(videoDimension.getWidth(), primaryScreenBounds.getWidth());
            height = width / aspectRatio;
        } else {
            height = Math.min(videoDimension.getHeight(), primaryScreenBounds.getHeight());
            width = height / aspectRatio;
        }
        if (this.videoWindow == null) {
            log.debug("Creating video window ...");
            this.videoWindow = new Stage();
            this.videoWindow.initOwner(null);
            this.videoWindow.setOnCloseRequest(windowEvent -> this.configurationService.getConfiguration().setIntegrateVideoplayer(true));
            this.videoWindow.setAlwaysOnTop(true);
        }
        this.videoWindow.setScene(new Scene((Parent)Main.getPlayer().getPlayerPane()));
        this.videoWindow.getScene().setFill((Paint)Color.BLACK);
        this.videoWindow.setWidth(width);
        this.videoWindow.setHeight(height);
        this.videoWindow.show();
        log.debug("Video window is displayed.");
    }

    private void integrateVideoWindow() {
        if (this.videoWindow != null && this.videoWindow.isShowing()) {
            this.videoWindow.close();
        }
        if (!this.rightAnchorPane.getChildren().contains((Object)Main.getPlayer().getPlayerPane())) {
            this.rightAnchorPane.getChildren().add((Object)Main.getPlayer().getPlayerPane());
            this.setAnchorPanePropertiesForPlayerPane();
            this.getGuiStateService().getMainStage().getScene().getRoot().layout();
            log.debug("Added player pane.");
        } else {
            log.debug("Anchor pane already contains player pane.");
        }
    }

    private void setSplitPanePosition() {
        log.debug("Setting split pane position...");
        boolean video = Main.getPlayer().isVideo();
        log.debug("Is video: {}", (Object)video);
        log.debug("Is integrate video player: {}", (Object)this.configurationService.getConfiguration().isIntegrateVideoplayer());
        if (video && this.configurationService.getConfiguration().isIntegrateVideoplayer()) {
            this.splitPane.setDividerPosition(0, 0.5);
            this.rightAnchorPane.setMaxHeight(2.147483647E9);
            this.rightAnchorPane.maxWidthProperty().bind((ObservableValue)this.splitPane.widthProperty().multiply(0.75));
            this.leftAnchorPane.minWidthProperty().bind((ObservableValue)this.splitPane.widthProperty().multiply(0.25));
            this.splitPane.getStyleClass().add((Object)"split-pane-active");
            this.splitPane.getStyleClass().remove((Object)"split-pane-inactive");
        } else {
            this.splitPane.setDividerPosition(0, 1.0);
            this.splitPane.getStyleClass().add((Object)"split-pane-inactive");
            this.splitPane.getStyleClass().remove((Object)"split-pane-active");
            this.rightAnchorPane.maxWidthProperty().unbind();
            this.leftAnchorPane.minWidthProperty().unbind();
            this.rightAnchorPane.setMinHeight(0.0);
            this.rightAnchorPane.setMinWidth(0.0);
            this.rightAnchorPane.setMaxWidth(0.0);
            this.rightAnchorPane.setMaxHeight(0.0);
        }
    }

    public void reset() {
    }

    private void setOnCloseRequest() {
        log.debug("Adding close request handler ...");
        this.mainBorderPane.getScene().getWindow().setOnCloseRequest(event -> {
            log.debug("Received close request.");
            try {
                event.consume();
                if (this.videoWindow != null) {
                    this.videoWindow.close();
                }
                this.miscService.closeProgram();
            }
            catch (Exception e) {
                log.error("Could not close.", (Throwable)e);
            }
        });
    }

    private void addPositionAndSizeListener() {
        EventStreams.changesOf((ObservableValue)this.getStage().heightProperty()).subscribe(change -> {
            if (!this.getStage().isMaximized()) {
                this.getStage().getProperties().put((Object)"beforeMaximizingHeight", (Object)this.getStage().getHeight());
            }
        });
        EventStreams.changesOf((ObservableValue)this.getStage().widthProperty()).subscribe(change -> {
            if (!this.getStage().isMaximized()) {
                this.getStage().getProperties().put((Object)"beforeMaximizingWidth", (Object)this.getStage().getWidth());
            }
        });
        EventStreams.changesOf((ObservableValue)this.getStage().xProperty()).subscribe(change -> {
            if (!this.getStage().isMaximized()) {
                this.getStage().getProperties().put((Object)"beforeMaximizingX", (Object)((Number)change.getOldValue()).doubleValue());
            }
        });
        EventStreams.changesOf((ObservableValue)this.getStage().yProperty()).subscribe(change -> {
            if (!this.getStage().isMaximized()) {
                this.getStage().getProperties().put((Object)"beforeMaximizingY", (Object)((Number)change.getOldValue()).doubleValue());
            }
        });
    }

    private void loadOnReset() {
        this.getGuiStateService().getSplashScreenStage().hide();
        boolean locationUnset = this.transcriptService.getCurrentTranscript().getTranscriptLocation() == null;
        boolean exists = false;
        if (!locationUnset) {
            exists = Files.exists(this.transcriptService.getCurrentTranscript().getTranscriptLocation(), new LinkOption[0]);
        }
        log.debug("Loading transcript on reset. Transcript location is set: {}, exists: {}", (Object)(!locationUnset ? 1 : 0), (Object)exists);
        if (!locationUnset && exists) {
            this.loadTranscriptService.openTranscript(this.transcriptService.getCurrentTranscript().getTranscriptLocation());
        } else {
            this.showAdditionalScreen(WelcomeScreenController.class, Modality.WINDOW_MODAL, false);
            this.windowManagerService.findOpenWindowByController(UpdaterController.class).ifPresent(window -> ((Stage)window).toFront());
        }
    }

    public void configureParagraphNumbers() {
        log.debug("Adding line numbers: {}", (Object)this.configurationService.getConfiguration().getShowParagraphNumbers());
        if (this.configurationService.getConfiguration().getShowParagraphNumbers()) {
            this.transcriptTextArea.setParagraphGraphicFactory(CustomLineNumberFactory.get((TranscriptTextArea)this.transcriptTextArea, (double)this.configurationService.getConfiguration().getFormattingSize()));
            this.transcriptTextArea.setPadding(new Insets(0.0, 20.0, 0.0, 0.0));
        } else {
            this.transcriptTextArea.setParagraphGraphicFactory(null);
            this.transcriptTextArea.setPadding(new Insets(0.0, 20.0, 0.0, 0.0));
        }
        this.linenoBackground.setManaged(this.configurationService.getConfiguration().getShowParagraphNumbers());
        this.linenoBackground.setVisible(this.configurationService.getConfiguration().getShowParagraphNumbers());
    }

    public void setWidthOfTranscriptTextArea() {
        Platform.runLater(() -> {
            log.debug("Setting width of transcript anchor pane.");
            if (this.configurationService.getConfiguration().getWidthOfTextAreaInCm() > -1.0) {
                Screen screen = this.windowManagerService.getScreenWithBiggestOverlap((Window)this.getGuiStateService().getMainStage());
                this.leftAnchorPane.setMaxWidth(this.configurationService.getConfiguration().getWidthOfTextAreaInCm() * screen.getDpi() / 2.54);
                this.leftAnchorPane.getStyleClass().add((Object)"scroll-pane-border");
            } else {
                this.leftAnchorPane.setMaxWidth(-1.0);
                this.leftAnchorPane.getStyleClass().remove((Object)"scroll-pane-border");
            }
        });
    }

    public void openHelpMenu() {
        if (this.helpContextMenu == null) {
            log.debug("Creating help menu ...");
            this.helpContextMenu = this.popOverService.create((Window)this.getStage(), (Node)this.helpFab);
            Button createNewTranscript = this.popOverService.createMenuItem(this.messageService.getLocaleBundle().getString("helpButton.createANewTranscript"), () -> {
                this.createTranscriptTutorial.setSkipMenu(false);
                this.tutorialService.show((Tutorial)this.createTranscriptTutorial).subscribeForOne(ignored -> {
                    this.configurationService.getConfiguration().getSeenTutorials().add("CreateTranscript");
                    this.configurationService.save();
                });
            });
            Button changeOfSpeakerAndShortcuts = this.popOverService.createMenuItem(this.messageService.getLocaleBundle().getString("helpButton.changeOfSpeakerAndShortcuts"), () -> this.tutorialService.show((Tutorial)this.drawerTutorial));
            Button playerFunctionality = this.popOverService.createMenuItem(this.messageService.getLocaleBundle().getString("helpButton.playerFeatures"), () -> this.tutorialService.show((Tutorial)this.playerBarTutorial));
            changeOfSpeakerAndShortcuts.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
            playerFunctionality.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
            this.helpContextMenu.getContent().getChildren().addAll((Object[])new Node[]{this.popOverService.createHeadline(this.messageService.getLocaleBundle().getString("helpButton.tutorialsHeadline")), createNewTranscript, changeOfSpeakerAndShortcuts, playerFunctionality, this.popOverService.createHeadline(this.messageService.getLocaleBundle().getString("helpButton.additionalHelp")), this.popOverService.createMenuItem(this.messageService.getLocaleBundle().getString("helpButton.website"), () -> {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://easytranscript.de"));
                    }
                    catch (IOException | URISyntaxException e) {
                        log.error("", (Throwable)e);
                    }
                }
            }), this.popOverService.createMenuItem(this.messageService.getLocaleBundle().getString("helpButton.help"), () -> {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI(this.messageService.getLocaleBundle().getString("helpButton.helpLink")));
                    }
                    catch (IOException | URISyntaxException e) {
                        log.error("", (Throwable)e);
                    }
                }
            })});
            log.debug("Help menu created.");
        }
        if (this.helpContextMenu.isShowing()) {
            this.helpContextMenu.hide();
        } else {
            this.getThemeService().setStyleSheets(this.helpContextMenu.getRoot().getScene());
            this.helpContextMenu.setWidth(310.0 + (145.0 - this.windowManagerService.getScreenWithBiggestOverlap((Window)this.getGuiStateService().getMainStage()).getDpi()));
            this.helpContextMenu.show();
        }
    }

    @Generated
    public MainController(MiscService miscService, LoadTranscriptService loadTranscriptService, TimerService timerService, PlayerService playerService, TextAreaService textAreaService, InputMapService inputMapService, MenuBarService menuBarService, StatusService statusService, DrawerService drawerService, TutorialService tutorialService, DrawerController drawerController, ScheduledLicenseValidation scheduledLicenseValidation, ExecutorService executorService, STTService sttService, STTDeletionService sttDeletionService, STTStatusService sttStatusService, WindowManagerService windowManagerService, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, LicenseValidationService licenseValidationService, PopOverService popOverService, CreateTranscriptTutorial createTranscriptTutorial, MessageService messageService, DrawerTutorial drawerTutorial, PlayerBarTutorial playerBarTutorial, AutomaticTranscriptService automaticTranscriptService, TranscriptService transcriptService) {
        this.miscService = miscService;
        this.loadTranscriptService = loadTranscriptService;
        this.timerService = timerService;
        this.playerService = playerService;
        this.textAreaService = textAreaService;
        this.inputMapService = inputMapService;
        this.menuBarService = menuBarService;
        this.statusService = statusService;
        this.drawerService = drawerService;
        this.tutorialService = tutorialService;
        this.drawerController = drawerController;
        this.scheduledLicenseValidation = scheduledLicenseValidation;
        this.executorService = executorService;
        this.sttService = sttService;
        this.sttDeletionService = sttDeletionService;
        this.sttStatusService = sttStatusService;
        this.windowManagerService = windowManagerService;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.licenseValidationService = licenseValidationService;
        this.popOverService = popOverService;
        this.createTranscriptTutorial = createTranscriptTutorial;
        this.messageService = messageService;
        this.drawerTutorial = drawerTutorial;
        this.playerBarTutorial = playerBarTutorial;
        this.automaticTranscriptService = automaticTranscriptService;
        this.transcriptService = transcriptService;
    }

    @Generated
    public ProgressBarController getProgressBarController() {
        return this.progressBarController;
    }

    @Generated
    public MenuBarController getMenuBarController() {
        return this.menuBarController;
    }

    private /* synthetic */ void lambda$initializeController$4(Task task, WorkerStateEvent workerStateEvent) {
        log.error("Could not init main screen controller", task.getException());
        this.exceptionAlert.showModal();
    }
}

