/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.WindowManagerService;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.prefs.BackingStoreException;
import javafx.application.Platform;
import javafx.collections.ObservableMap;
import javafx.geometry.BoundingBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MiscService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MiscService.class);
    public static final String BEFORE_MAXIMIZING_X = "beforeMaximizingX";
    public static final String BEFORE_MAXIMIZING_Y = "beforeMaximizingY";
    public static final String BEFORE_MAXIMIZING_WIDTH = "beforeMaximizingWidth";
    public static final String BEFORE_MAXIMIZING_HEIGHT = "beforeMaximizingHeight";
    private final CloseDialog closeDialog;
    private final StatusService statusService;
    private final TranscriptTextArea transcriptTextArea;
    private final WindowManagerService windowManagerService;
    private final TranscriptService transcriptService;
    private final MessageService messageService;
    private final GuiStateService guiStateService;

    public void closeProgram() {
        log.info("Closing program ...");
        try {
            this.windowManagerService.storeSizeAndPosition((Window)this.guiStateService.getMainStage(), this.getBoundBoxBeforeMaximizing(this.guiStateService.getMainStage()), "/climbingperch/easytranscript/main");
        }
        catch (BackingStoreException e) {
            log.error("Could not store size and position of main window.", (Throwable)e);
        }
        this.closeDialog.showAndWait(Platform::exit);
    }

    public void closeTranscript() {
        this.closeDialog.showAndWait(() -> {
            Main.getPlayer().stop();
            this.transcriptTextArea.clear();
            try {
                Utils.clearFolder((Path)this.transcriptService.getTemporaryTranscriptLocation(this.transcriptService.getCurrentTranscript().getUnzipUuid()));
            }
            catch (IOException e) {
                log.error("Could not delete transcript folder", (Throwable)e);
            }
            this.transcriptService.setCurrentTranscript(new Transcript());
            this.statusService.setTranscriptLoaded(false);
            this.setTitle();
            log.info("Closed transcript.");
        });
    }

    public void setTitle() {
        if (this.transcriptService.getCurrentTranscript().getTranscriptLocation() != null) {
            this.guiStateService.getMainStage().setTitle("easytranscript \u2013 " + String.valueOf(this.transcriptService.getCurrentTranscript().getTranscriptLocation().getFileName()) + (this.statusService.isSaved() ? "" : "*") + (String)(this.statusService.isRecovered() ? " (" + this.messageService.getLocaleBundle().getString("general.recovered") + ")" : ""));
        } else {
            this.guiStateService.getMainStage().setTitle("easytranscript");
        }
    }

    public void restartProgram() {
        try {
            this.windowManagerService.storeSizeAndPosition((Window)this.guiStateService.getMainStage(), this.getBoundBoxBeforeMaximizing(this.guiStateService.getMainStage()), "/climbingperch/easytranscript/main");
        }
        catch (BackingStoreException e) {
            log.error("Could not store size and position of main window.", (Throwable)e);
        }
        this.closeDialog.showAndWait(() -> {});
    }

    private BoundingBox getBoundBoxBeforeMaximizing(Stage stage) {
        ObservableMap props = stage.getProperties();
        return new BoundingBox(((Double)props.getOrDefault((Object)BEFORE_MAXIMIZING_X, (Object)stage.getX())).doubleValue(), ((Double)props.getOrDefault((Object)BEFORE_MAXIMIZING_Y, (Object)stage.getX())).doubleValue(), ((Double)props.getOrDefault((Object)BEFORE_MAXIMIZING_WIDTH, (Object)stage.getWidth())).doubleValue(), ((Double)props.getOrDefault((Object)BEFORE_MAXIMIZING_HEIGHT, (Object)stage.getHeight())).doubleValue());
    }

    @Generated
    public MiscService(CloseDialog closeDialog, StatusService statusService, TranscriptTextArea transcriptTextArea, WindowManagerService windowManagerService, TranscriptService transcriptService, MessageService messageService, GuiStateService guiStateService) {
        this.closeDialog = closeDialog;
        this.statusService = statusService;
        this.transcriptTextArea = transcriptTextArea;
        this.windowManagerService = windowManagerService;
        this.transcriptService = transcriptService;
        this.messageService = messageService;
        this.guiStateService = guiStateService;
    }
}

