/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.TimeRecorder;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeTrackingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeTrackingService.class);
    private final TimeRecorder timeRecorder;
    private final StatusService statusService;
    private final TranscriptTextArea transcriptTextArea;
    private final ConfigurationService configurationService;
    private final TranscriptService transcriptService;

    boolean addTimeTracked() {
        TimeTrackingEntry timeTrackingEntry = this.timeRecorder.stop();
        if (timeTrackingEntry != null) {
            this.transcriptService.getCurrentTranscript().getTrackedTime().add(timeTrackingEntry);
            this.statusService.setSaved(false);
            log.debug("Added tracked time: {}", (Object)timeTrackingEntry);
            return true;
        }
        return false;
    }

    public long getLastTimestamp() {
        for (int i = this.transcriptTextArea.getDocument().getParagraphs().size() - 1; i >= 0; --i) {
            Paragraph paragraph = (Paragraph)this.transcriptTextArea.getDocument().getParagraphs().get(i);
            TimestampSegment timestampSegment = paragraph.getSegments().stream().filter(TimestampSegment.class::isInstance).reduce((first, second) -> second).orElse(null);
            if (timestampSegment == null) continue;
            return timestampSegment.getMillis();
        }
        return -1L;
    }

    public String formatDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        String langTag = this.configurationService.getConfiguration().getProgramLanguage();
        Locale locale = Locale.forLanguageTag(langTag);
        DateTimeFormatter df = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(locale);
        return df.format(dateTime);
    }

    public String formatDuration(TimeTrackingEntry entry) {
        if (entry.getEnd() == null) {
            return "";
        }
        Duration duration = Duration.ofSeconds(entry.getDateDiff((TemporalUnit)ChronoUnit.SECONDS));
        return String.format("%02d:%02d:%02d", duration.toHours(), duration.toMinutesPart(), duration.toSecondsPart());
    }

    @Generated
    public TimeTrackingService(TimeRecorder timeRecorder, StatusService statusService, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, TranscriptService transcriptService) {
        this.timeRecorder = timeRecorder;
        this.statusService = statusService;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.transcriptService = transcriptService;
    }
}

