/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.drawer;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.FXUiService;
import eu.ewerkzeug.easytranscript3.commons.fx.MinLengthValidator;
import eu.ewerkzeug.easytranscript3.commons.fx.NoDuplicatesTextFieldValidator;
import eu.ewerkzeug.easytranscript3.commons.fx.NotEqualToPlayerSettingsTextFieldValidator;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textformattingcontrol.TextFormattingController;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.controlsfx.control.ToggleSwitch;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.SuspendableNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="drawer.fxml")
@Component
@Lazy
public class DrawerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DrawerController.class);
    public static final String DELETE_PATH = "M9.05160734,0.162718455 C9.26856528,-0.054239485 9.62032361,-0.054239485 9.83728155,0.162718455 C10.034516,0.359952946 10.0524464,0.668592711 9.89107277,0.886082706 L9.83728155,0.948392656 L0.948392656,9.83728155 C0.731434716,10.0542395 0.379676395,10.0542395 0.162718455,9.83728155 C-0.0345160359,9.64004705 -0.0524464441,9.33140729 0.10892723,9.11391729 L0.162718455,9.05160734 L9.05160734,0.162718455 ZM9.05160734,0.162718455 C9.26856528,-0.054239485 9.62032361,-0.054239485 9.83728155,0.162718455 C10.034516,0.359952946 10.0524464,0.668592711 9.89107277,0.886082706 L9.83728155,0.948392656 L0.948392656,9.83728155 C0.731434716,10.0542395 0.379676395,10.0542395 0.162718455,9.83728155 C-0.0345160359,9.64004705 -0.0524464441,9.33140729 0.10892723,9.11391729 L0.162718455,9.05160734 L9.05160734,0.162718455 Z M0.162718455,0.162718455 C0.359952946,-0.0345160359 0.668592711,-0.0524464441 0.886082706,0.10892723 L0.948392656,0.162718455 L9.83728155,9.05160734 C10.0542395,9.26856528 10.0542395,9.62032361 9.83728155,9.83728155 C9.64004705,10.034516 9.33140729,10.0524464 9.11391729,9.89107277 L9.05160734,9.83728155 L0.162718455,0.948392656 C-0.054239485,0.731434716 -0.054239485,0.379676395 0.162718455,0.162718455 ZM0.162718455,0.162718455 C0.359952946,-0.0345160359 0.668592711,-0.0524464441 0.886082706,0.10892723 L0.948392656,0.162718455 L9.83728155,9.05160734 C10.0542395,9.26856528 10.0542395,9.62032361 9.83728155,9.83728155 C9.64004705,10.034516 9.33140729,10.0524464 9.11391729,9.89107277 L9.05160734,9.83728155 L0.162718455,0.948392656 C-0.054239485,0.731434716 -0.054239485,0.379676395 0.162718455,0.162718455 Z";
    private final DrawerService drawerService;
    private final StatusService statusService;
    private final LoadTranscriptService loadTranscriptService;
    private final SpeakerService speakerService;
    private final TranscriptTextArea transcriptTextArea;
    private final SuspendableNo postLoadingTranscript = new SuspendableNo();
    private final ConfigurationService configurationService;
    private final FXUiService fXUiService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final TranscriptService transcriptService;
    private final ExceptionAlert exceptionAlert;
    private final GuiStateService guiStateService;
    @FXML
    private StackPane root;
    @FXML
    private TitledPane textTitledPane;
    @FXML
    private TitledPane changeOfSpeakerTitledPane;
    @FXML
    private TitledPane shortcutsTitledPane;
    @FXML
    private GridPane shortcutGridPane;
    @FXML
    private GridPane changeOfSpeakerSpeakersGridPane;
    @FXML
    private Button drawerExpandButton;
    @FXML
    private Accordion accordion;
    @FXML
    private Region maskRegion;
    @FXML
    private Circle changeOfSpeakerIndicator;
    @FXML
    private Circle textIndicator;
    @FXML
    private Circle shortcutsIndicator;
    @FXML
    private ToggleSwitch changeOfSpeakerToggleSwitch;
    @FXML
    private TextFormattingController textFormattingController;
    @FXML
    private TextFormattingController changeOfSpeakerTextFormattingController;

    @FXML
    public void initialize() {
        this.changeOfSpeakerTextFormattingController.setHideAlignment(true);
        this.textFormattingController.getTextFontSizeComboBox().setOnAction(evt -> this.drawerService.updateFontSize(Integer.valueOf(this.textFormattingController.getFontSizeValue())));
        this.textFormattingController.getTextFontComboBox().setOnAction(evt -> {
            evt.consume();
            this.textFormattingController.ensureSetFontExists();
            this.drawerService.updateFontFamily((String)this.textFormattingController.getTextFontComboBox().getValue());
            KeyEvent press = new KeyEvent((Object)this.textFormattingController.getTextFontSizeComboBox(), (EventTarget)this.textFormattingController.getTextFontSizeComboBox(), KeyEvent.KEY_PRESSED, "", "", KeyCode.ESCAPE, false, false, false, false);
            this.textFormattingController.getTextFontSizeComboBox().fireEvent((Event)press);
            this.transcriptTextArea.requestFocus();
        });
        this.textFormattingController.getTextBoldToggleButton().setOnAction(e -> this.drawerService.toggleBold());
        this.textFormattingController.getTextItalicToggleButton().setOnAction(e -> this.drawerService.toggleItalic());
        this.textFormattingController.getTextUnderlineToggleButton().setOnAction(e -> this.drawerService.toggleUnderline());
        this.textFormattingController.getTextLeftToRightToggleButton().setOnAction(e -> this.drawerService.setLeftToRight());
        this.textFormattingController.getTextRightToLeftToggleButton().setOnAction(e -> this.drawerService.setRightToLeft());
        this.textFormattingController.getTextJustifyToggleButton().setOnAction(e -> this.drawerService.setJustify());
        this.textFormattingController.getTextCenterToggleButton().setOnAction(e -> this.drawerService.setCenter());
        this.changeOfSpeakerIndicator.visibleProperty().bind((ObservableValue)this.drawerService.getChangeOfSpeakerIndicatorVisibleProperty());
        this.shortcutsIndicator.visibleProperty().bind((ObservableValue)this.drawerService.getShortcutsIndicatorVisibleProperty());
        this.statusService.transcriptLoadingProperty().addListener((observableValue, aBoolean, t1) -> {
            if (aBoolean.booleanValue() && !t1.booleanValue()) {
                Platform.runLater(() -> this.prepareDrawerAfterTranscriptLoading());
            } else {
                this.changeOfSpeakerToggleSwitch.selectedProperty().unbind();
            }
        });
        this.initChangeOfSpeakerTextFormattingControllerListeners();
        this.accordion.getPanes().forEach(pane -> pane.expandedProperty().addListener((observableValue, aBoolean, t1) -> {
            if (t1.booleanValue() && !this.drawerService.getDrawerExpandedProperty().getValue().booleanValue()) {
                this.toggleExpand();
            }
        }));
        this.root.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        if (this.configurationService.getConfiguration().isDrawerExpanded()) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
        this.transcriptTextArea.richChanges().subscribe(changes -> {
            if (!changes.isIdentity()) {
                this.updateFormattingControls();
            }
        });
        this.transcriptTextArea.caretPositionProperty().addListener((observable, old, newPos) -> {
            if (!newPos.equals(old)) {
                this.updateFormattingControls();
            }
        });
    }

    private void prepareDrawerAfterTranscriptLoading() {
        Guard suspendGuard = this.postLoadingTranscript.suspend();
        this.drawerService.getChangeOfSpeakerIndicatorVisibleProperty().bind((ObservableValue)this.transcriptService.getCurrentTranscript().changeOfSpeakerProperty());
        this.drawerService.getShortcutsIndicatorVisibleProperty().set(!this.transcriptService.getCurrentTranscript().getKeyCombinationFields().isEmpty());
        this.changeOfSpeakerToggleSwitch.selectedProperty().bindBidirectional((Property)this.transcriptService.getCurrentTranscript().changeOfSpeakerProperty());
        this.changeOfSpeakerTextFormattingController.getTextFontComboBox().getSelectionModel().select((Object)this.transcriptService.getCurrentTranscript().getSpeakerFormattingFont().replace("\"", ""));
        this.changeOfSpeakerTextFormattingController.ensureSetFontExists();
        this.changeOfSpeakerTextFormattingController.setFontSizeValue(this.transcriptService.getCurrentTranscript().getSpeakerFormattingSize());
        this.changeOfSpeakerTextFormattingController.getTextBoldToggleButton().setSelected(this.transcriptService.getCurrentTranscript().isSpeakerFormattingBold());
        this.changeOfSpeakerTextFormattingController.getTextItalicToggleButton().setSelected(this.transcriptService.getCurrentTranscript().isSpeakerFormattingItalic());
        this.changeOfSpeakerTextFormattingController.getTextUnderlineToggleButton().setSelected(this.transcriptService.getCurrentTranscript().isSpeakerFormattingUnderlined());
        this.changeOfSpeakerSpeakersGridPane.getChildren().clear();
        this.shortcutGridPane.getChildren().clear();
        this.transcriptService.getCurrentTranscript().getSpeakers().forEach(arg_0 -> this.addNewSpeaker(arg_0));
        this.transcriptService.getCurrentTranscript().getKeyCombinationFields().forEach((arg_0, arg_1) -> this.addNewShortcut(arg_0, arg_1));
        this.addNewShortcut("", "");
        this.addNewSpeaker(new Speaker());
        suspendGuard.close();
    }

    private void initChangeOfSpeakerTextFormattingControllerListeners() {
        EventStreams.eventsOf((Node)this.changeOfSpeakerTextFormattingController.getTextFontSizeComboBox(), (EventType)ActionEvent.ACTION).suppressWhen((ObservableValue)this.postLoadingTranscript).subscribe(change -> {
            this.transcriptService.getCurrentTranscript().setSpeakerFormattingSize(this.changeOfSpeakerTextFormattingController.getFontSizeValue());
            this.updateSpeakerStyle();
        });
        EventStreams.eventsOf((Node)this.changeOfSpeakerTextFormattingController.getTextFontComboBox(), (EventType)ActionEvent.ACTION).suppressWhen((ObservableValue)this.postLoadingTranscript).subscribe(change -> {
            this.transcriptService.getCurrentTranscript().setSpeakerFormattingFont("\"" + (String)this.changeOfSpeakerTextFormattingController.getTextFontComboBox().getValue() + "\"");
            KeyEvent press = new KeyEvent((Object)this.changeOfSpeakerTextFormattingController.getTextFontComboBox(), (EventTarget)this.changeOfSpeakerTextFormattingController.getTextFontComboBox(), KeyEvent.KEY_PRESSED, "", "", KeyCode.ESCAPE, false, false, false, false);
            this.changeOfSpeakerTextFormattingController.getTextFontComboBox().fireEvent((Event)press);
            this.updateSpeakerStyle();
        });
        EventStreams.eventsOf((Node)this.changeOfSpeakerTextFormattingController.getTextBoldToggleButton(), (EventType)ActionEvent.ACTION).suppressWhen((ObservableValue)this.postLoadingTranscript).subscribe(change -> {
            this.transcriptService.getCurrentTranscript().setSpeakerFormattingBold(this.changeOfSpeakerTextFormattingController.getTextBoldToggleButton().isSelected());
            this.updateSpeakerStyle();
        });
        EventStreams.eventsOf((Node)this.changeOfSpeakerTextFormattingController.getTextItalicToggleButton(), (EventType)ActionEvent.ACTION).suppressWhen((ObservableValue)this.postLoadingTranscript).subscribe(change -> {
            this.transcriptService.getCurrentTranscript().setSpeakerFormattingItalic(this.changeOfSpeakerTextFormattingController.getTextItalicToggleButton().isSelected());
            this.updateSpeakerStyle();
        });
        EventStreams.eventsOf((Node)this.changeOfSpeakerTextFormattingController.getTextUnderlineToggleButton(), (EventType)ActionEvent.ACTION).suppressWhen((ObservableValue)this.postLoadingTranscript).subscribe(change -> {
            this.transcriptService.getCurrentTranscript().setSpeakerFormattingUnderlined(this.changeOfSpeakerTextFormattingController.getTextUnderlineToggleButton().isSelected());
            this.updateSpeakerStyle();
        });
    }

    private void updateSpeakerStyle() {
        log.info("Size is " + this.transcriptService.getCurrentTranscript().getSpeakerFormattingSize());
        this.transcriptService.updateSpeakerTextStyle(this.transcriptService.getCurrentTranscript());
        log.info("Updated speaker style.");
        log.info("size now is " + this.transcriptService.getCurrentTranscript().getSpeakerFormattingSize());
        this.statusService.setSaved(false);
        this.speakerService.updateSpeakerSegmentStyle();
        this.transcriptTextArea.requestFocus();
        log.debug("Updated speaker style.");
    }

    private void addNewShortcut(String shortcut, String fullWord) {
        shortcut = KeyCombinationTextField.replacePlatformIndependentBySpecific((String)shortcut);
        log.debug("Adding new shortcut with combination '{}' and full word '{}'", (Object)shortcut, (Object)fullWord);
        KeyCombinationTextField first = new KeyCombinationTextField(true);
        first.setText(shortcut);
        first.setPromptText(this.messageService.getLocaleBundle().getString("transcriptPropertiesScreen.shortcut"));
        NoDuplicatesTextFieldValidator validator = new NoDuplicatesTextFieldValidator();
        NotEqualToPlayerSettingsTextFieldValidator notEqualToPlayerSettingsTextFieldValidator = new NotEqualToPlayerSettingsTextFieldValidator(this.configurationService.getConfiguration());
        MinLengthValidator stringLengthValidator = new MinLengthValidator(2, this.messageService.getLocaleBundle().getString("drawer.invalidError"));
        validator.setMessage(this.messageService.getLocaleBundle().getString("drawer.duplicateError"));
        notEqualToPlayerSettingsTextFieldValidator.setMessage(this.messageService.getLocaleBundle().getString("drawer.duplicateError"));
        first.getValidators().addAll((Object[])new ValidatorBase[]{validator, stringLengthValidator, notEqualToPlayerSettingsTextFieldValidator});
        JFXTextField full = new JFXTextField(fullWord);
        full.setPromptText(this.messageService.getLocaleBundle().getString("transcriptPropertiesScreen.fullWord"));
        ChangeListener textChangeListener = (observable, oldValue, newValue) -> {
            if (oldValue.isEmpty() && !newValue.isEmpty() && GridPane.getRowIndex((Node)first) + 1 == this.fXUiService.getGridPaneRowCount(this.shortcutGridPane)) {
                this.addNewShortcut("", "");
            } else if (first.getText().isEmpty() && full.getText().isEmpty()) {
                this.deleteShortcutWithIndex(GridPane.getRowIndex((Node)first).intValue());
            }
        };
        first.textProperty().addListener(textChangeListener);
        full.textProperty().addListener(textChangeListener);
        full.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                if (full.getText().isEmpty() && !first.getText().isEmpty()) {
                    full.getStyleClass().add((Object)"error-in-field");
                } else {
                    full.getStyleClass().remove((Object)"error-in-field");
                    first.getStyleClass().remove((Object)"error-in-field");
                }
            }
            first.validate();
        });
        first.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                if (first.getText().isEmpty() && !full.getText().isEmpty()) {
                    full.getStyleClass().add((Object)"error-in-field");
                } else {
                    first.getStyleClass().remove((Object)"error-in-field");
                    full.getStyleClass().remove((Object)"error-in-field");
                }
            }
            first.validate();
        });
        Button deleteButton = new Button();
        SVGPath svgPath = new SVGPath();
        svgPath.setContent(DELETE_PATH);
        svgPath.getStyleClass().add((Object)"delete-icon");
        deleteButton.setGraphic((Node)svgPath);
        deleteButton.setOnAction(event -> this.deleteShortcutWithIndex(GridPane.getRowIndex((Node)deleteButton).intValue()));
        this.shortcutGridPane.addRow(this.fXUiService.getGridPaneRowCount(this.shortcutGridPane), new Node[]{first, full, deleteButton});
        ChangeListener focusedListener = (observable, oldValue, newValue) -> {
            if (!(newValue.booleanValue() || first.getText().isEmpty() || full.getText().isEmpty())) {
                this.drawerService.validateAndSetKeyCombinations(this.shortcutGridPane.getChildren());
            }
        };
        first.focusedProperty().addListener(focusedListener);
        full.focusedProperty().addListener(focusedListener);
    }

    private void deleteShortcutWithIndex(int index) {
        if (index >= this.shortcutGridPane.getRowCount() - 1) {
            return;
        }
        this.fXUiService.deleteRow(this.shortcutGridPane, index);
        if (this.fXUiService.getGridPaneRowCount(this.shortcutGridPane) == 0) {
            this.addNewShortcut("", "");
        }
        this.drawerService.validateAndSetKeyCombinations(this.shortcutGridPane.getChildren());
    }

    private void addNewSpeaker(Speaker speaker) {
        log.debug("Adding new speaker.");
        JFXTextField full = new JFXTextField(speaker.getText());
        full.setUserData((Object)speaker);
        full.setPromptText(this.messageService.getLocaleBundle().getString("drawer.speaker"));
        full.textProperty().addListener((observableValue, s, t1) -> {
            if (s.isEmpty() && !t1.isEmpty() && GridPane.getRowIndex((Node)full) + 1 == this.fXUiService.getGridPaneRowCount(this.changeOfSpeakerSpeakersGridPane)) {
                this.addNewSpeaker(new Speaker());
            }
        });
        Button deleteButton = new Button();
        SVGPath svgPath = new SVGPath();
        svgPath.setContent(DELETE_PATH);
        svgPath.getStyleClass().add((Object)"delete-icon");
        deleteButton.setGraphic((Node)svgPath);
        deleteButton.setOnAction(event -> this.deleteSpeaker((Speaker)full.getUserData(), GridPane.getRowIndex((Node)deleteButton).intValue()));
        this.changeOfSpeakerSpeakersGridPane.addRow(this.fXUiService.getGridPaneRowCount(this.changeOfSpeakerSpeakersGridPane), new Node[]{full, deleteButton});
        ChangeListener focusedListener = (observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                Speaker speakerData = (Speaker)full.getUserData();
                if (full.getText().isEmpty()) {
                    boolean deleted = this.deleteSpeaker(speakerData, GridPane.getRowIndex((Node)deleteButton).intValue());
                    if (!deleted) {
                        full.setText(speakerData.getName());
                    }
                } else if (!full.getText().isEmpty()) {
                    if (speakerData.getUuid() == null) {
                        speakerData.setUuid(UUID.randomUUID());
                    }
                    String oldText = speakerData.getName();
                    speakerData.setName(full.getText());
                    this.drawerService.validateAndSaveSpeakers(this.changeOfSpeakerSpeakersGridPane.getChildren());
                    if (!oldText.isEmpty()) {
                        this.speakerService.updateSpeaker(speaker);
                    }
                }
            }
        };
        full.focusedProperty().addListener(focusedListener);
    }

    private boolean deleteSpeaker(Speaker speaker, int rowIndex) {
        if (rowIndex >= this.changeOfSpeakerSpeakersGridPane.getRowCount() - 1) {
            return false;
        }
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ButtonType deleteAnywaysButtonType = new ButtonType(this.messageService.getLocaleBundle().getString("drawer.deleteSpeakerAnyways"), ButtonBar.ButtonData.YES);
        ETButtonType buttonTypeYes = new ETButtonType(deleteAnywaysButtonType, true, false);
        ETButtonType buttonTypeCancel = new ETButtonType(ButtonType.CANCEL, false, true);
        buttons.add(buttonTypeYes);
        buttons.add(buttonTypeCancel);
        ButtonType buttonType = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("drawer.deleteSpeakerTitle"), this.messageService.getLocaleBundle().getString("drawer.deleteSpeaker"), Modality.WINDOW_MODAL, buttons).showAndWait();
        if (buttonType == null || buttonType != deleteAnywaysButtonType) {
            return false;
        }
        this.speakerService.replaceSpeakerWithText(speaker);
        this.fXUiService.deleteRow(this.changeOfSpeakerSpeakersGridPane, rowIndex);
        if (this.fXUiService.getGridPaneRowCount(this.changeOfSpeakerSpeakersGridPane) == 0) {
            this.addNewSpeaker(new Speaker());
        }
        this.drawerService.validateAndSaveSpeakers(this.changeOfSpeakerSpeakersGridPane.getChildren());
        return true;
    }

    public void updateFormattingControls() {
        TextAlignment textAlignment;
        String fontFamily;
        int fontSize;
        boolean underline;
        boolean italic;
        boolean bold;
        boolean underlineAnyMatch;
        boolean italicAnyMatch;
        boolean boldAnyMatch;
        IndexRange selection = this.transcriptTextArea.getSelection();
        if (selection.getLength() != 0) {
            StyledDocument subDoc = this.transcriptTextArea.getDocument().subSequence(selection);
            List textStyles = subDoc.getParagraphs().stream().flatMap(p -> p.getStyledSegments().stream().filter(s -> s.getSegment() instanceof StyledTextSegment).map(StyledSegment::getStyle)).toList();
            boldAnyMatch = textStyles.stream().anyMatch(s -> s.boldOptional.orElse(this.configurationService.getConfiguration().isFormattingBold()));
            italicAnyMatch = textStyles.stream().anyMatch(s -> s.italicOptional.orElse(this.configurationService.getConfiguration().isFormattingItalic()));
            underlineAnyMatch = textStyles.stream().anyMatch(s -> s.underlineOptional.orElse(this.configurationService.getConfiguration().isFormattingUnderlined()));
            bold = textStyles.stream().allMatch(s -> s.boldOptional.orElse(this.configurationService.getConfiguration().isFormattingBold()));
            italic = textStyles.stream().allMatch(s -> s.italicOptional.orElse(this.configurationService.getConfiguration().isFormattingItalic()));
            underline = textStyles.stream().allMatch(s -> s.underlineOptional.orElse(this.configurationService.getConfiguration().isFormattingUnderlined()));
            int[] sizes = textStyles.stream().mapToInt(s -> s.fontSizeOptional.orElse(this.configurationService.getConfiguration().getFormattingSize())).distinct().toArray();
            fontSize = sizes.length == 1 ? sizes[0] : -1;
            List<String> familiesArray = textStyles.stream().map(s -> s.fontFamilyOptional.orElse(this.configurationService.getConfiguration().getFormattingFont())).map(s -> s.replace("\"", "")).distinct().toList();
            fontFamily = familiesArray.size() == 1 ? familiesArray.getFirst() : "";
            List<ParStyle> parStyles = subDoc.getParagraphs().stream().map(Paragraph::getParagraphStyle).toList();
            Set distinctAlignments = parStyles.stream().map(parStyle -> parStyle.alignment.orElse(TextAlignment.LEFT)).collect(Collectors.toSet());
            textAlignment = distinctAlignments.size() != 1 ? null : (TextAlignment)distinctAlignments.iterator().next();
        } else {
            int p2 = this.transcriptTextArea.getCurrentParagraph();
            int col = this.transcriptTextArea.getCaretColumn();
            TextStyle style = (TextStyle)this.transcriptTextArea.getStyleAtPosition(p2, col);
            bold = style.boldOptional.orElse(this.configurationService.getConfiguration().isFormattingBold());
            italic = style.italicOptional.orElse(this.configurationService.getConfiguration().isFormattingItalic());
            underline = style.underlineOptional.orElse(this.configurationService.getConfiguration().isFormattingUnderlined());
            boldAnyMatch = bold;
            italicAnyMatch = italic;
            underlineAnyMatch = underline;
            fontSize = style.fontSizeOptional.orElse(this.configurationService.getConfiguration().getFormattingSize());
            if (style.fontFamilyOptional.isPresent()) {
                fontFamily = style.fontFamilyOptional.map(s -> s.replace("\"", "")).orElse(this.configurationService.getConfiguration().getFormattingFont().replace("\"", ""));
            } else {
                IndexRange styleRangeAtPosition = this.transcriptTextArea.getStyleRangeAtPosition(p2, col);
                style = (TextStyle)this.transcriptTextArea.getStyleAtPosition(styleRangeAtPosition.getStart());
                fontFamily = style.fontFamilyOptional.map(s -> s.replace("\"", "")).orElse(this.configurationService.getConfiguration().getFormattingFont().replace("\"", ""));
            }
            textAlignment = ((ParStyle)this.transcriptTextArea.getParagraph((int)this.transcriptTextArea.getCurrentParagraph()).getParagraphStyle()).alignment.orElse(TextAlignment.LEFT);
        }
        TextAlignment defaultAlignment = this.configurationService.getConfiguration().getFormattingParagraphAlignment();
        boolean textAlignmentIsNotEqual = textAlignment == null && defaultAlignment != TextAlignment.LEFT || textAlignment != null && !textAlignment.equals((Object)defaultAlignment);
        this.drawerService.getUpdatingToolbar().suspendWhile(() -> {
            boolean deviatesFromStandardFormatting = textAlignmentIsNotEqual || boldAnyMatch != this.configurationService.getConfiguration().isFormattingBold() || italicAnyMatch != this.configurationService.getConfiguration().isFormattingItalic() || underlineAnyMatch != this.configurationService.getConfiguration().isFormattingUnderlined() || fontSize != this.configurationService.getConfiguration().getFormattingSize() || !fontFamily.equals(this.configurationService.getConfiguration().getFormattingFont().replace("\"", ""));
            this.textIndicator.setVisible(deviatesFromStandardFormatting);
            if (bold) {
                if (!this.textFormattingController.getTextBoldToggleButton().isSelected()) {
                    this.drawerService.getBoldProperty().set(true);
                    this.textFormattingController.getTextBoldToggleButton().setSelected(true);
                }
            } else {
                this.drawerService.getBoldProperty().set(false);
                this.textFormattingController.getTextBoldToggleButton().setSelected(false);
            }
            if (italic) {
                if (!this.textFormattingController.getTextItalicToggleButton().isSelected()) {
                    this.textFormattingController.getTextItalicToggleButton().setSelected(true);
                    this.drawerService.getItalicProperty().set(true);
                }
            } else {
                this.textFormattingController.getTextItalicToggleButton().setSelected(false);
                this.drawerService.getItalicProperty().set(false);
            }
            if (underline) {
                if (!this.textFormattingController.getTextUnderlineToggleButton().isSelected()) {
                    this.textFormattingController.getTextUnderlineToggleButton().setSelected(true);
                    this.drawerService.getUnderlineProperty().set(true);
                }
            } else {
                this.textFormattingController.getTextUnderlineToggleButton().setSelected(false);
                this.drawerService.getUnderlineProperty().set(false);
            }
            if (fontSize != -1) {
                this.textFormattingController.setFontSizeValue(fontSize);
            } else {
                this.textFormattingController.getTextFontSizeComboBox().getSelectionModel().select((Object)this.messageService.getLocaleBundle().getString("drawer.fontSizesMixed"));
            }
            if (!fontFamily.isEmpty()) {
                this.textFormattingController.getTextFontComboBox().getSelectionModel().select((Object)fontFamily);
            } else {
                this.textFormattingController.getTextFontComboBox().getSelectionModel().select((Object)this.messageService.getLocaleBundle().getString("drawer.fontsMixed"));
            }
            if (textAlignment != null) {
                if (textAlignment.equals((Object)TextAlignment.LEFT)) {
                    this.textFormattingController.getTextOrientationToggleGroup().selectToggle((Toggle)this.textFormattingController.getTextLeftToRightToggleButton());
                } else if (textAlignment.equals((Object)TextAlignment.RIGHT)) {
                    this.textFormattingController.getTextOrientationToggleGroup().selectToggle((Toggle)this.textFormattingController.getTextRightToLeftToggleButton());
                } else if (textAlignment.equals((Object)TextAlignment.CENTER)) {
                    this.textFormattingController.getTextOrientationToggleGroup().selectToggle((Toggle)this.textFormattingController.getTextCenterToggleButton());
                } else if (textAlignment.equals((Object)TextAlignment.JUSTIFY)) {
                    this.textFormattingController.getTextOrientationToggleGroup().selectToggle((Toggle)this.textFormattingController.getTextJustifyToggleButton());
                } else {
                    this.textFormattingController.getTextOrientationToggleGroup().selectToggle((Toggle)this.textFormattingController.getTextLeftToRightToggleButton());
                }
            } else {
                this.textFormattingController.getTextOrientationToggleGroup().getToggles().forEach(toggle -> toggle.setSelected(false));
                this.textFormattingController.getTextOrientationToggleGroup().selectToggle(null);
            }
        });
    }

    public void toggleExpand() {
        if (Boolean.FALSE.equals(this.drawerService.getDrawerExpandedProperty().getValue())) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
    }

    public void openDrawer() {
        this.drawerService.getDrawerExpandedProperty().set(true);
        this.maskRegion.setVisible(false);
        this.drawerExpandButton.getGraphic().setScaleX(1.0);
    }

    public void closeDrawer() {
        this.drawerService.getDrawerExpandedProperty().set(false);
        this.maskRegion.setVisible(true);
        this.drawerExpandButton.getGraphic().setScaleX(-1.0);
        this.accordion.getPanes().forEach(pane -> pane.setExpanded(false));
    }

    /*
     * WARNING - void declaration
     */
    public void readShortcutsFromTranscript() {
        log.info("Reading shortcuts from transcript ...");
        FileChooser.ExtensionFilter ettFilter = new FileChooser.ExtensionFilter("easytranscript Transkript", new String[]{"*.ett"});
        FileChooser.ExtensionFilter csvFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("timeTrackingScreen.csvExport") + " (*.csv)", new String[]{"*.csv"});
        FileChooser.ExtensionFilter dataFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("formats.et2StenoData") + " (*.data)", new String[]{"*.data"});
        FileChooser.ExtensionFilter allFiles = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("drawer.allFormatsImportShortcuts") + " (*.ett, *.csv, *.data)", new String[]{"*.ett", "*.csv", "*.data"});
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        fileChooser.getExtensionFilters().add((Object)allFiles);
        fileChooser.getExtensionFilters().add((Object)ettFilter);
        fileChooser.getExtensionFilters().add((Object)csvFilter);
        fileChooser.getExtensionFilters().add((Object)dataFilter);
        File file = fileChooser.showOpenDialog((Window)this.guiStateService.getMainStage());
        if (file == null) {
            return;
        }
        Main.setRecentOpenedFileChooserPath((File)file.getParentFile());
        this.shortcutGridPane.getChildren().clear();
        LinkedHashMap keyCombinationFields = new LinkedHashMap(this.transcriptService.getCurrentTranscript().getKeyCombinationFields());
        String extension = Utils.getFileExtension((String)file.getName()).toLowerCase();
        try {
            void var10_15;
            String string = extension;
            int n = -1;
            switch (string.hashCode()) {
                case 100773: {
                    if (!string.equals("ett")) break;
                    boolean bl = false;
                    break;
                }
                case 3076010: {
                    if (!string.equals("data")) break;
                    boolean bl = true;
                    break;
                }
                case 98822: {
                    if (!string.equals("csv")) break;
                    int n2 = 2;
                }
            }
            switch (var10_15) {
                case 0: {
                    this.importShortcutsFromETT(file, keyCombinationFields);
                    break;
                }
                case 1: {
                    this.importShortcutsFromData(file, keyCombinationFields);
                    break;
                }
                case 2: {
                    this.importShortcutsFromCSV(file, keyCombinationFields, ';');
                }
            }
            for (Map.Entry entry : keyCombinationFields.entrySet()) {
                if (((String)entry.getKey()).isEmpty()) continue;
                this.addNewShortcut((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception e) {
            log.error("Could not read transcript for importing shortcuts", (Throwable)e);
            this.exceptionAlert.showModal();
        }
        this.drawerService.validateAndSetKeyCombinations(this.shortcutGridPane.getChildren());
        this.addNewShortcut("", "");
    }

    private void importShortcutsFromCSV(File file, LinkedHashMap<String, String> keyCombinationFields, char separator) throws Exception {
        try (CSVReader csvReader = new CSVReaderBuilder((Reader)new FileReader(file)).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator(separator).build()).build();){
            Object[] values;
            while ((values = csvReader.readNext()) != null) {
                log.debug(Arrays.toString(values));
                if (values.length < 2) continue;
                keyCombinationFields.put((String)values[0], (String)values[1]);
            }
        }
    }

    private void importShortcutsFromData(File file, LinkedHashMap<String, String> keyCombinationFields) throws Exception {
        log.debug("Importing shortcuts from data...");
        try (FileInputStream fis = new FileInputStream(file);){
            Properties p = new Properties();
            p.load(fis);
            p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> keyCombinationFields.put((String)key, (String)value)));
        }
    }

    private void importShortcutsFromETT(File file, LinkedHashMap<String, String> keyCombinationFields) throws Exception {
        log.debug("Importing shortcuts from ett...");
        Transcript transcriptToImport = this.loadTranscriptService.loadTranscriptAndMigrate(file.toPath());
        if (transcriptToImport != null) {
            keyCombinationFields.putAll(transcriptToImport.getKeyCombinationFields());
        }
    }

    @Generated
    public DrawerController(DrawerService drawerService, StatusService statusService, LoadTranscriptService loadTranscriptService, SpeakerService speakerService, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, FXUiService fXUiService, MessageService messageService, DialogService dialogService, TranscriptService transcriptService, ExceptionAlert exceptionAlert, GuiStateService guiStateService) {
        this.drawerService = drawerService;
        this.statusService = statusService;
        this.loadTranscriptService = loadTranscriptService;
        this.speakerService = speakerService;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.fXUiService = fXUiService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.transcriptService = transcriptService;
        this.exceptionAlert = exceptionAlert;
        this.guiStateService = guiStateService;
    }

    @Generated
    public TitledPane getTextTitledPane() {
        return this.textTitledPane;
    }

    @Generated
    public TitledPane getChangeOfSpeakerTitledPane() {
        return this.changeOfSpeakerTitledPane;
    }

    @Generated
    public TitledPane getShortcutsTitledPane() {
        return this.shortcutsTitledPane;
    }
}

