/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.drawer;

import com.jfoenix.controls.JFXTextField;
import com.jthemedetecor.util.OsInfo;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.reactfx.SuspendableNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DrawerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DrawerService.class);
    private final SuspendableNo updatingToolbar = new SuspendableNo();
    private final SimpleBooleanProperty boldProperty = new SimpleBooleanProperty();
    private final SimpleBooleanProperty italicProperty = new SimpleBooleanProperty();
    private final SimpleBooleanProperty underlineProperty = new SimpleBooleanProperty();
    private final SimpleObjectProperty<Integer> fontSizeProperty = new SimpleObjectProperty();
    private final SimpleStringProperty fontProperty = new SimpleStringProperty();
    private final SimpleBooleanProperty drawerExpandedProperty = new SimpleBooleanProperty();
    private final SimpleBooleanProperty shortcutsIndicatorVisibleProperty = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty changeOfSpeakerIndicatorVisibleProperty = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty textIndicatorVisibleProperty = new SimpleBooleanProperty(false);
    private final StatusService statusService;
    private final TranscriptTextArea transcriptTextArea;
    private final ConfigurationService configurationService;
    private final TranscriptService transcriptService;
    private final GuiStateService guiStateService;

    @PostConstruct
    public void setup() {
        Configuration config = this.configurationService.getConfiguration();
        this.boldProperty.set(config.isFormattingBold());
        this.italicProperty.set(config.isFormattingItalic());
        this.underlineProperty.set(config.isFormattingUnderlined());
        this.fontSizeProperty.set((Object)config.getFormattingSize());
        this.fontProperty.set(config.getFormattingFont());
        this.drawerExpandedProperty.set(config.isDrawerExpanded());
    }

    void updateFontSize(Integer size) {
        this.fontSizeProperty.set((Object)size);
        if (this.transcriptTextArea == null) {
            return;
        }
        if (!this.updatingToolbar.get() && this.transcriptTextArea.getSelection().getLength() > 0) {
            this.transcriptTextArea.getTextStyleManager().updateStyleInSelection(TextStyle.fontSize((int)size));
        }
        this.transcriptTextArea.requestFocus();
    }

    void updateFontFamily(String family) {
        family = "\"" + (String)family + "\"";
        this.fontProperty.set((String)family);
        if (this.transcriptTextArea == null) {
            return;
        }
        if (!this.updatingToolbar.get()) {
            this.transcriptTextArea.getTextStyleManager().updateStyleInSelection(TextStyle.fontFamily((String)family));
        }
        this.transcriptTextArea.requestFocus();
    }

    public void toggleBold() {
        TextStyle styleAtCurrentPosition = this.getStyleAtCurrentPosition();
        if (styleAtCurrentPosition != null) {
            styleAtCurrentPosition.boldOptional.ifPresent(o -> this.boldProperty.set(o == false));
        }
        if (this.transcriptTextArea != null) {
            this.transcriptTextArea.getTextStyleManager().toggleBold();
        }
    }

    public void toggleItalic() {
        TextStyle styleAtCurrentPosition = this.getStyleAtCurrentPosition();
        if (styleAtCurrentPosition != null) {
            styleAtCurrentPosition.italicOptional.ifPresent(o -> this.italicProperty.set(o == false));
        }
        if (this.transcriptTextArea != null) {
            this.transcriptTextArea.getTextStyleManager().toggleItalic();
        }
    }

    public void toggleUnderline() {
        TextStyle styleAtCurrentPosition = this.getStyleAtCurrentPosition();
        if (styleAtCurrentPosition != null) {
            styleAtCurrentPosition.underlineOptional.ifPresent(o -> this.underlineProperty.set(o == false));
        }
        if (this.transcriptTextArea != null) {
            this.transcriptTextArea.getTextStyleManager().toggleUnderline();
        }
    }

    public void setLeftToRight() {
        this.transcriptTextArea.getParagraphStyleManager().setLeftToRight();
    }

    public void setCenter() {
        if (this.transcriptTextArea != null) {
            this.transcriptTextArea.getParagraphStyleManager().setCenter();
        }
    }

    public void setRightToLeft() {
        if (this.transcriptTextArea != null) {
            this.transcriptTextArea.getParagraphStyleManager().setRightToLeft();
        }
    }

    public void setJustify() {
        if (this.transcriptTextArea != null) {
            this.transcriptTextArea.getParagraphStyleManager().setJustify();
        }
    }

    private TextStyle getStyleAtCurrentPosition() {
        int p = this.transcriptTextArea.getCurrentParagraph();
        int col = this.transcriptTextArea.getCaretColumn();
        return (TextStyle)this.transcriptTextArea.getStyleAtPosition(p, col);
    }

    public void validateAndSaveSpeakers(ObservableList<Node> gridNodes) {
        ArrayList<Speaker> speakers = new ArrayList<Speaker>();
        for (Node n : gridNodes) {
            Speaker speaker;
            String fullWord;
            if (!(n instanceof JFXTextField) || (fullWord = ((TextField)n).getText()).isEmpty() || speakers.contains(speaker = (Speaker)n.getUserData())) continue;
            speakers.add(speaker);
        }
        this.transcriptService.getCurrentTranscript().getSpeakers().clear();
        this.transcriptService.getCurrentTranscript().getSpeakers().addAll(speakers);
        log.info("Validated and saved speakers.");
        this.statusService.setSaved(false);
    }

    public void validateAndSetKeyCombinations(ObservableList<Node> gridNodes) {
        log.debug("Checking key combinations ...");
        String keyCombination = null;
        HashMap<String, String> forbidden = new HashMap<String, String>();
        ArrayList<KeyCombination> keyCombinations = new ArrayList<KeyCombination>();
        Configuration config = this.configurationService.getConfiguration();
        keyCombinations.add(config.getPlayerFaster());
        keyCombinations.add(config.getPlayerPlayPause());
        keyCombinations.add(config.getPlayerFastForward());
        keyCombinations.add(config.getPlayerLouder());
        keyCombinations.add(config.getPlayerQuieter());
        keyCombinations.add(config.getPlayerRewind());
        keyCombinations.add(config.getPlayerSlower());
        for (KeyCombination combination : keyCombinations) {
            forbidden.put(combination.toString(), "");
            forbidden.put(KeyCombinationTextField.replacePlatformIndependentBySpecific((String)combination.toString()), "");
        }
        MainController controller = (MainController)this.guiStateService.getController();
        if (controller != null && controller.getMenuBarController() != null) {
            ((MainController)this.guiStateService.getController()).getMenuBarController().getMenuBar().getMenus().stream().flatMap(menu -> menu.getItems().stream()).filter(item -> item.getAccelerator() != null).forEach(item -> {
                forbidden.put(item.getAccelerator().toString().replace("'", ""), "");
                forbidden.put(KeyCombinationTextField.replacePlatformIndependentBySpecific((String)item.getAccelerator().toString().replace("'", "")), "");
            });
        }
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        for (Node n : gridNodes) {
            if (n instanceof KeyCombinationTextField) {
                KeyCombinationTextField textField = (KeyCombinationTextField)n;
                keyCombination = textField.getText();
                if (keyCombination.isEmpty() || !textField.validate()) {
                    keyCombination = null;
                    continue;
                }
                if (forbidden.containsKey(keyCombination) || textField.validateText() == KeyCombination.NO_MATCH) {
                    n.getStyleClass().add((Object)"error-in-field");
                } else {
                    n.getStyleClass().remove((Object)"error-in-field");
                    forbidden.put(keyCombination, "");
                }
                if (OsInfo.isMacOsMojaveOrLater()) {
                    textField.setText(textField.getText().replace(KeyCode.META.getName(), KeyCode.COMMAND.getName()).replace(KeyCode.SHORTCUT.getName(), KeyCode.COMMAND.getName()));
                    continue;
                }
                if (!OsInfo.isWindows10OrLater()) continue;
                textField.setText(textField.getText().replace(KeyCode.META.getName(), KeyCode.WINDOWS.getName()));
                continue;
            }
            if (!(n instanceof JFXTextField)) continue;
            String fullWord = ((TextField)n).getText();
            if (keyCombination == null || fullWord.isEmpty() || tmp.containsKey(keyCombination)) continue;
            tmp.put(keyCombination, fullWord);
            forbidden.put(keyCombination, fullWord);
        }
        if (!tmp.equals(this.transcriptService.getCurrentTranscript().getKeyCombinationFields())) {
            this.transcriptService.getCurrentTranscript().getKeyCombinationFields().clear();
            this.transcriptService.getCurrentTranscript().getKeyCombinationFields().putAll(tmp);
            this.statusService.setKeyCombinationNeedReload(true);
            this.statusService.setSaved(false);
            this.shortcutsIndicatorVisibleProperty.setValue(Boolean.valueOf(!tmp.isEmpty()));
            log.debug("Key combinations were changed.");
        } else {
            log.debug("Key combinations were not changed.");
        }
    }

    @Generated
    public SuspendableNo getUpdatingToolbar() {
        return this.updatingToolbar;
    }

    @Generated
    public SimpleBooleanProperty getBoldProperty() {
        return this.boldProperty;
    }

    @Generated
    public SimpleBooleanProperty getItalicProperty() {
        return this.italicProperty;
    }

    @Generated
    public SimpleBooleanProperty getUnderlineProperty() {
        return this.underlineProperty;
    }

    @Generated
    public SimpleObjectProperty<Integer> getFontSizeProperty() {
        return this.fontSizeProperty;
    }

    @Generated
    public SimpleStringProperty getFontProperty() {
        return this.fontProperty;
    }

    @Generated
    public SimpleBooleanProperty getDrawerExpandedProperty() {
        return this.drawerExpandedProperty;
    }

    @Generated
    public SimpleBooleanProperty getShortcutsIndicatorVisibleProperty() {
        return this.shortcutsIndicatorVisibleProperty;
    }

    @Generated
    public SimpleBooleanProperty getChangeOfSpeakerIndicatorVisibleProperty() {
        return this.changeOfSpeakerIndicatorVisibleProperty;
    }

    @Generated
    public SimpleBooleanProperty getTextIndicatorVisibleProperty() {
        return this.textIndicatorVisibleProperty;
    }

    @Generated
    public StatusService getStatusService() {
        return this.statusService;
    }

    @Generated
    public TranscriptTextArea getTranscriptTextArea() {
        return this.transcriptTextArea;
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Generated
    public TranscriptService getTranscriptService() {
        return this.transcriptService;
    }

    @Generated
    public GuiStateService getGuiStateService() {
        return this.guiStateService;
    }

    @Generated
    public DrawerService(StatusService statusService, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, TranscriptService transcriptService, GuiStateService guiStateService) {
        this.statusService = statusService;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.transcriptService = transcriptService;
        this.guiStateService = guiStateService;
    }
}

