/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import lombok.Generated;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClipboardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClipboardService.class);
    private final TranscriptTextArea textArea;
    private final LicenseService licenseService;
    private final ConfigurationService configurationService;
    private final LicenseValidationService licenseValidationService;
    private final TranscriptService transcriptService;

    public void cut() {
        if (!this.licenseValidationService.isUserLicenseValid()) {
            this.licenseService.showLicenseNotValidDialog(true);
            return;
        }
        this.copy();
        this.textArea.deleteText(this.textArea.getSelection());
    }

    public void copy() {
        if (!this.licenseValidationService.isUserLicenseValid()) {
            this.licenseService.showLicenseNotValidDialog(true);
            return;
        }
        ClipboardContent content = new ClipboardContent();
        this.addDisplayedRawTextSelectionToClipboardContent(content);
        this.addDisplayedHtmlSelectionToClipboardContent(content);
        this.addEncodedStyledTextSelectionToClipboardText(content);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void paste() {
        this.textArea.paste();
        String string = this.getClipboardString();
        if (string != null) {
            String[] words = string.split(Transcript.wordSeparator.pattern());
            this.transcriptService.getCurrentTranscript().getAutocompletionWords().addAll(Arrays.stream(words).filter(f -> f.length() >= this.configurationService.getConfiguration().getAutocompletionThreshold()).toList());
        }
    }

    protected String getClipboardString() {
        return Clipboard.getSystemClipboard().getString();
    }

    private void addDisplayedRawTextSelectionToClipboardContent(ClipboardContent content) {
        content.putString(this.getSelectedRawText());
    }

    private void addDisplayedHtmlSelectionToClipboardContent(ClipboardContent content) {
        String html = this.transcriptService.documentToHtml(this.transcriptService.getCurrentTranscript(), this.textArea.getDocument().subSequence(this.textArea.getSelection()));
        content.putHtml(html);
    }

    public void addEncodedStyledTextSelectionToClipboardText(ClipboardContent content) {
        IndexRange selection = this.textArea.getSelection();
        this.textArea.getStyleCodecs().ifPresent(codecs -> {
            Codec codec = ReadOnlyStyledDocument.codec((Codec)((Codec)codecs._1), (Codec)((Codec)codecs._2), (SegmentOps)this.textArea.getSegOps());
            DataFormat format = Objects.requireNonNullElseGet(DataFormat.lookupMimeType((String)codec.getName()), () -> new DataFormat(new String[]{codec.getName()}));
            log.debug("Mimetype: {}", (Object)DataFormat.lookupMimeType((String)codec.getName()));
            StyledDocument doc = this.textArea.subDocument(selection.getStart(), selection.getEnd());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            try {
                codec.encode(dos, (Object)doc);
                content.put((Object)format, (Object)os.toByteArray());
            }
            catch (IOException e) {
                log.error("Codec error: Exception in encoding '{}'.", (Object)codec.getName(), (Object)e);
            }
        });
    }

    private String getSelectedRawText() {
        CaretSelectionBind caretSelectionBind = this.textArea.getCaretSelectionBind();
        List paragraphs = this.textArea.getParagraphs().subList(caretSelectionBind.getStartParagraphIndex(), caretSelectionBind.getEndParagraphIndex() + 1);
        int realStartOffset = caretSelectionBind.getStartColumnPosition();
        int realEnd = caretSelectionBind.getEndPosition();
        int lengthPos = 0;
        boolean reachedStart = false;
        StringBuilder paragraphsText = new StringBuilder();
        for (Paragraph p : paragraphs) {
            for (AbstractSegment s : p.getSegments()) {
                lengthPos += s.getText().length();
                if (!(s instanceof StyledTextSegment)) {
                    if (!reachedStart && lengthPos <= caretSelectionBind.getStartColumnPosition()) {
                        realStartOffset += s.getRealText().length() - 1;
                    }
                    realEnd += s.getRealText().length() - 1;
                }
                if (lengthPos > caretSelectionBind.getStartColumnPosition()) {
                    reachedStart = true;
                }
                log.debug("Segment class: {}, RealText: '{}'", (Object)s.getClass().getSimpleName(), (Object)s.getRealText());
                paragraphsText.append(s.getRealText());
                if (lengthPos <= caretSelectionBind.getStartColumnPosition() + caretSelectionBind.getLength()) continue;
                break;
            }
            paragraphsText.append("\n");
        }
        int realStart = caretSelectionBind.getStartPosition() + (realStartOffset - caretSelectionBind.getStartColumnPosition());
        int distance = realEnd - realStart;
        String text = paragraphsText.toString();
        log.debug("Full text: '{}'", (Object)text);
        log.debug("RealStartOffset: {}, Distance: {}", (Object)realStartOffset, (Object)distance);
        text = text.substring(realStartOffset);
        text = text.substring(0, Math.min(text.length(), distance));
        return text;
    }

    @Generated
    public ClipboardService(TranscriptTextArea textArea, LicenseService licenseService, ConfigurationService configurationService, LicenseValidationService licenseValidationService, TranscriptService transcriptService) {
        this.textArea = textArea;
        this.licenseService = licenseService;
        this.configurationService = configurationService;
        this.licenseValidationService = licenseValidationService;
        this.transcriptService = transcriptService;
    }
}

