/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.io.XmlSanitizer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.io.StringWriter;
import java.lang.runtime.SwitchBootstraps;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@Service
public class DocumentSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentSerializer.class);
    private final XmlSanitizer xmlSanitizer;

    public String serializeContent(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> richDocument) {
        return this.serializeContent(richDocument, false, false);
    }

    public String serializeContent(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> richDocument, boolean replaceQuotesAroundFontFamily, boolean withoutXMLHeader) {
        log.debug("Serializing content...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element rootElement = doc.createElement("StyledDocument");
            doc.appendChild(rootElement);
            richDocument.getParagraphs().forEach(par -> {
                Element parElement = doc.createElement("Paragraph");
                parElement.setAttribute("style", ((ParStyle)par.getParagraphStyle()).toCss());
                rootElement.appendChild(parElement);
                par.getStyledSegments().forEach(seg -> {
                    AbstractSegment selector0$temp = (AbstractSegment)seg.getSegment();
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimestampSegment.class, SpeakerSegment.class, StyledTextSegment.class, LowConfidenceSegment.class}, (AbstractSegment)selector0$temp, index$1)) {
                        case 0: {
                            TimestampSegment timestampSegment = (TimestampSegment)selector0$temp;
                            Element segElement = doc.createElement("Timestamp");
                            segElement.setAttribute("ms", String.valueOf(timestampSegment.getMillis()));
                            Text textNode = doc.createTextNode(((AbstractSegment)seg.getSegment()).getText());
                            segElement.appendChild(textNode);
                            parElement.appendChild(segElement);
                            break;
                        }
                        case 1: {
                            SpeakerSegment speakerSegment = (SpeakerSegment)selector0$temp;
                            Element segElement = doc.createElement("Speaker");
                            segElement.setAttribute("uuid", speakerSegment.getUuid());
                            Text textNode = doc.createTextNode(((AbstractSegment)seg.getSegment()).getText());
                            segElement.appendChild(textNode);
                            parElement.appendChild(segElement);
                            break;
                        }
                        case 2: {
                            StyledTextSegment styledTextSegment = (StyledTextSegment)selector0$temp;
                            Element segElement = doc.createElement("StyledText");
                            segElement.setAttribute("style", ((TextStyle)seg.getStyle()).toCss(replaceQuotesAroundFontFamily));
                            Text textNode = doc.createTextNode(styledTextSegment.getText());
                            segElement.appendChild(textNode);
                            parElement.appendChild(segElement);
                            break;
                        }
                        case 3: {
                            LowConfidenceSegment lowConfidenceSegment = (LowConfidenceSegment)selector0$temp;
                            Element segElement = doc.createElement("lct");
                            segElement.setAttribute("conf", String.valueOf(lowConfidenceSegment.getConfidence()));
                            segElement.setAttribute("alt", String.join((CharSequence)",", lowConfidenceSegment.getAlternatives()));
                            Text textNode = doc.createTextNode(lowConfidenceSegment.getText());
                            segElement.appendChild(textNode);
                            parElement.appendChild(segElement);
                            break;
                        }
                        default: {
                            assert (seg.getSegment() != null);
                            log.error("Unhandled segment class: {}", (Object)((AbstractSegment)seg.getSegment()).getClass().getCanonicalName());
                        }
                    }
                });
            });
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(withoutXMLHeader ? rootElement : doc);
            StringWriter outWriter = new StringWriter();
            StreamResult consoleResult = new StreamResult(outWriter);
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("omit-xml-declaration", withoutXMLHeader ? "yes" : "no");
            transformer.transform(source, consoleResult);
            String xmlOutput = outWriter.toString();
            log.debug("Serialized content.");
            return this.xmlSanitizer.sanitize(xmlOutput);
        }
        catch (ParserConfigurationException | TransformerException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Generated
    public DocumentSerializer(XmlSanitizer xmlSanitizer) {
        this.xmlSanitizer = xmlSanitizer;
    }
}

