/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.FXUiService;
import eu.ewerkzeug.easytranscript3.commons.fx.TimestampService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.KeyCombinationSubstitutionService;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ClipboardService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaLocationService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaNavigationService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ZoomService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AutocompletePopup;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InputMapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputMapService.class);
    private final KeyCombinationSubstitutionService keyCombinationSubstitutionService;
    private final DrawerService drawerService;
    private final TextAreaService textAreaService;
    private final TimestampService timestampService;
    private final TranscriptTextArea transcriptTextArea;
    private final TextAreaLocationService textAreaLocationService;
    private final TextAreaNavigationService navigationService;
    private final AutocompletePopup autocompletePopup;
    private final ZoomService zoomService;
    private final ConfigurationService configurationService;
    private final FXUiService fxUiService;
    private final TranscriptService transcriptService;
    private final ClipboardService clipboardService;

    private void hideContextMenusAndMoveCaret(MouseEvent mouseEvent) {
        this.textAreaService.hideAllContextPopups();
        CharacterHit hit = this.transcriptTextArea.hit(mouseEvent.getX(), mouseEvent.getY());
        this.transcriptTextArea.moveTo(hit.getInsertionIndex());
    }

    @NotNull
    private ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> getLineBreakDoc(TextStyle oldTextStyle) {
        return ReadOnlyStyledDocument.fromString((String)"\n", (Object)((ParStyle)this.transcriptTextArea.getParagraph(this.transcriptTextArea.getCurrentParagraph()).getParagraphStyle()), (Object)oldTextStyle, (TextOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    private EventPattern<Event, KeyEvent> typedPrintableCharacter() {
        return EventPattern.keyTyped().onlyIf(keyEvent -> StringUtils.isNotEmpty((CharSequence)keyEvent.getCharacter()) && keyEvent.getCharacter().charAt(0) >= ' ' && keyEvent.getCharacter().charAt(0) != '\u007f');
    }

    private void showAutocompletePopup(KeyEvent keyEvent) {
        if (this.configurationService.getConfiguration().isAutocompletionActive() && Character.isLetterOrDigit(keyEvent.getCharacter().charAt(0))) {
            TranscriptTextArea textArea = this.transcriptTextArea;
            Triple lastWord = this.textAreaLocationService.findLastWord(textArea.getCaretPosition());
            if (textArea.getCaretBounds().isPresent() && this.textAreaLocationService.isCursorAtWordBoundary() && this.autocompletePopup.findWordSuggestions(this.transcriptService.getCurrentTranscript().getAutocompletionWords(), (String)lastWord.getLeft())) {
                this.fxUiService.runOnePulseLater(() -> this.autocompletePopup.show(lastWord));
            }
        }
    }

    public void addInputMaps() {
        this.addKeyTypedInputMap();
        this.addNewParagraphInputMap();
        this.addMouseInputMap();
        this.addZoomShortcutInputMap();
        this.addArrowInputMaps();
        this.addClipboardInputMap();
    }

    private void addClipboardInputMap() {
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.C, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.clipboardService.copy()), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.X, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.clipboardService.cut()), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.V, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.clipboardService.paste())}));
    }

    private void addArrowInputMaps() {
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.LEFT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToPrevWord(NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.RIGHT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToNextWord(NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.UP, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToPreviousParagraph(NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.DOWN, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToNextParagraph(NavigationActions.SelectionPolicy.CLEAR)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.UP, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToPreviousParagraph(NavigationActions.SelectionPolicy.ADJUST)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.DOWN, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToNextParagraph(NavigationActions.SelectionPolicy.ADJUST)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.LEFT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToPrevWord(NavigationActions.SelectionPolicy.ADJUST)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.RIGHT, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN}), ev -> this.navigationService.skipToNextWord(NavigationActions.SelectionPolicy.ADJUST))}));
    }

    private void addMouseInputMap() {
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.PRIMARY).onlyIf(f -> this.transcriptTextArea.getSelection().getLength() == 0), arg_0 -> this.hideContextMenusAndMoveCaret(arg_0)), InputMap.consume((EventPattern)EventPattern.mouseClicked((MouseButton)MouseButton.SECONDARY).onlyIf(event -> this.transcriptTextArea.getSelection().getLength() == 0), arg_0 -> this.hideContextMenusAndMoveCaret(arg_0))}));
    }

    private void addZoomShortcutInputMap() {
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((String)"+", (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.zoomService.zoom(true)), InputMap.consume((EventPattern)EventPattern.keyPressed((String)"-", (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), ev -> this.zoomService.zoom(false))}));
    }

    private void addNewParagraphInputMap() {
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCode)KeyCode.ENTER, (KeyCombination.Modifier[])new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.CONTROL_ANY}), e -> Platform.runLater(() -> {
            e.consume();
            if (!this.transcriptTextArea.isEditable()) {
                return;
            }
            int caretPos = this.handleNewParagraph(e);
            if (this.textAreaLocationService.isCursorAtWordBoundary(caretPos)) {
                this.startKeyCombinationSubstitutionService(caretPos);
            }
        }))}));
    }

    private int handleNewParagraph(KeyEvent e) {
        int caretPos = this.transcriptTextArea.getCaretPosition();
        TextStyle oldTextStyle = (TextStyle)this.transcriptTextArea.getStyleAtPosition(caretPos);
        ReadOnlyStyledDocument doc = this.getLineBreakDoc(oldTextStyle);
        if (this.transcriptTextArea.getSelection().getLength() > 0) {
            this.transcriptTextArea.deleteText(this.transcriptTextArea.getSelection());
        }
        if (!e.isShiftDown() && this.configurationService.getConfiguration().isTimestampsOnEnd()) {
            this.timestampService.insertTimestamp();
        }
        this.transcriptTextArea.insert(this.transcriptTextArea.getCaretPosition(), (StyledDocument)doc);
        if (!e.isShiftDown()) {
            if (this.configurationService.getConfiguration().isAdditionalLineAfterEnter()) {
                this.transcriptTextArea.insert(this.transcriptTextArea.getCaretPosition(), (StyledDocument)doc);
            }
            if (this.configurationService.getConfiguration().isTimestampsOnBeginning()) {
                this.timestampService.insertTimestamp();
            }
            if (this.transcriptService.getCurrentTranscript().getChangeOfSpeaker()) {
                this.textAreaService.insertSpeaker();
            }
        }
        this.transcriptTextArea.requestFollowCaret();
        return caretPos;
    }

    private void addKeyTypedInputMap() {
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)InputMap.consume((EventPattern)this.typedPrintableCharacter(), keyEvent -> {
            if (!this.transcriptTextArea.isEditable()) {
                return;
            }
            this.addWordToAutocompletionWordList(keyEvent);
            if (!keyEvent.isShortcutDown()) {
                this.insertTypedCharacter(keyEvent);
            }
            this.transcriptTextArea.requestFollowCaret();
            this.startKeyCombinationSubstitutionIfApplicable(keyEvent);
            this.showAutocompletePopup(keyEvent);
        }));
    }

    private void addWordToAutocompletionWordList(KeyEvent keyEvent) {
        Triple lastWord;
        String word;
        if (!this.configurationService.getConfiguration().isAutocompletionActive() || !Transcript.wordSeparator.matcher(keyEvent.getCharacter()).matches()) {
            return;
        }
        this.autocompletePopup.hide();
        TranscriptTextArea textArea = this.transcriptTextArea;
        int start = textArea.getCaretPosition() - 1;
        if (start >= 2 && Character.isLetterOrDigit(textArea.getText(start, start + 1).charAt(0)) && (word = (String)(lastWord = this.textAreaLocationService.findLastWord(textArea.getCaretPosition())).getLeft()).length() >= this.configurationService.getConfiguration().getAutocompletionThreshold() && !this.keyCombinationSubstitutionService.getCharacterCombinations().containsKey(word) && !this.keyCombinationSubstitutionService.getMisspellingCorrections().containsKey(word.toLowerCase())) {
            this.transcriptService.getCurrentTranscript().getAutocompletionWords().add(word);
        }
    }

    private void insertTypedCharacter(KeyEvent keyEvent) {
        Pair familyAndSize = this.getFamilyAndSizeForInsertion();
        ReadOnlyStyledDocument document = ReadOnlyStyledDocument.fromSegment((Object)new StyledTextSegment((Object)keyEvent.getCharacter()), (Object)((ParStyle)this.transcriptTextArea.getParagraph(this.transcriptTextArea.getCurrentParagraph()).getParagraphStyle()), (Object)TextStyle.EMPTY.updateFontFamily((String)familyAndSize.getLeft()).updateFontSize(((Integer)familyAndSize.getRight()).intValue()).updateBold(this.drawerService.getBoldProperty().getValue().booleanValue()).updateItalic(this.drawerService.getItalicProperty().getValue().booleanValue()).updateUnderline(this.drawerService.getUnderlineProperty().getValue().booleanValue()), (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
        if (this.transcriptTextArea.getSelection().getLength() == 0) {
            try {
                this.transcriptTextArea.insert(Math.min(this.transcriptTextArea.getCaretPosition(), this.transcriptTextArea.getDocument().length()), (StyledDocument)document);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        } else {
            this.transcriptTextArea.replaceSelection((StyledDocument)document);
        }
    }

    @NotNull
    private Pair<String, Integer> getFamilyAndSizeForInsertion() {
        String fontFamily = null;
        int fontSize = 0;
        if (this.transcriptTextArea.getSelection().getLength() > 0) {
            int atStart = this.transcriptTextArea.getSelection().getStart();
            Optional fontFamily1 = ((TextStyle)this.transcriptTextArea.getStyleAtPosition((int)atStart)).fontFamilyOptional;
            Optional fontSize1 = ((TextStyle)this.transcriptTextArea.getStyleAtPosition((int)atStart)).fontSizeOptional;
            if (fontFamily1.isPresent()) {
                fontFamily = (String)fontFamily1.get();
            }
            if (fontSize1.isPresent()) {
                fontSize = (Integer)fontSize1.get();
            }
        } else {
            fontFamily = this.drawerService.getFontProperty().getValue();
            Integer selectedItem = (Integer)this.drawerService.getFontSizeProperty().getValue();
            int n = fontSize = selectedItem != null ? selectedItem : 0;
        }
        if (fontFamily == null) {
            fontFamily = this.configurationService.getConfiguration().getFormattingFont();
        }
        if (fontSize <= 0) {
            fontSize = this.configurationService.getConfiguration().getFormattingSize();
        }
        return new ImmutablePair((Object)fontFamily, (Object)fontSize);
    }

    private void startKeyCombinationSubstitutionIfApplicable(KeyEvent keyEvent) {
        if (this.textAreaLocationService.isCursorAtWordBoundary(Math.max(0, this.transcriptTextArea.getCaretPosition() - 1)) && keyEvent.getCharacter().equals("\t") || keyEvent.getCharacter().equals(" ")) {
            this.startKeyCombinationSubstitutionService(this.transcriptTextArea.getCaretPosition() - 1);
        }
    }

    private void startKeyCombinationSubstitutionService(int caretPosition) {
        this.keyCombinationSubstitutionService.setCaret(caretPosition);
        this.keyCombinationSubstitutionService.restart();
    }

    @Generated
    public InputMapService(KeyCombinationSubstitutionService keyCombinationSubstitutionService, DrawerService drawerService, TextAreaService textAreaService, TimestampService timestampService, TranscriptTextArea transcriptTextArea, TextAreaLocationService textAreaLocationService, TextAreaNavigationService navigationService, AutocompletePopup autocompletePopup, ZoomService zoomService, ConfigurationService configurationService, FXUiService fxUiService, TranscriptService transcriptService, ClipboardService clipboardService) {
        this.keyCombinationSubstitutionService = keyCombinationSubstitutionService;
        this.drawerService = drawerService;
        this.textAreaService = textAreaService;
        this.timestampService = timestampService;
        this.transcriptTextArea = transcriptTextArea;
        this.textAreaLocationService = textAreaLocationService;
        this.navigationService = navigationService;
        this.autocompletePopup = autocompletePopup;
        this.zoomService = zoomService;
        this.configurationService = configurationService;
        this.fxUiService = fxUiService;
        this.transcriptService = transcriptService;
        this.clipboardService = clipboardService;
    }
}

