/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TextAreaLocationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextAreaLocationService.class);
    private final TranscriptTextArea transcriptTextArea;

    public boolean isCursorAtWordBoundary() {
        return this.isCursorAtWordBoundary(this.transcriptTextArea.getCaretPosition());
    }

    public boolean isCursorAtWordBoundary(int index) {
        if (index < this.transcriptTextArea.getLength() - 1) {
            char c = this.transcriptTextArea.getText(Math.max(0, index), index + 1).charAt(0);
            return !Character.isLetterOrDigit(c);
        }
        return true;
    }

    public Triple<String, Integer, Integer> findLastWord(int pos) {
        int beginning = Math.max(0, pos - 68);
        String text = this.transcriptTextArea.getText(beginning, pos);
        String normalized = StringUtils.normalizeSpace((String)text);
        int spaceIndex = normalized.lastIndexOf(" ");
        if (spaceIndex >= 0) {
            return new ImmutableTriple((Object)normalized.substring(spaceIndex + 1), (Object)(beginning + spaceIndex + 1), (Object)pos);
        }
        return new ImmutableTriple((Object)normalized, (Object)beginning, (Object)pos);
    }

    @Generated
    public TextAreaLocationService(TranscriptTextArea transcriptTextArea) {
        this.transcriptTextArea = transcriptTextArea;
    }
}

