/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import lombok.Generated;
import org.fxmisc.richtext.NavigationActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TextAreaNavigationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextAreaNavigationService.class);
    private final TranscriptTextArea transcriptTextArea;

    public void skipToPrevWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int caretPos = this.transcriptTextArea.getCaretPosition();
        if (1 <= caretPos) {
            boolean prevCharIsWhiteSpace = Character.isWhitespace(this.transcriptTextArea.getText(caretPos - 1, caretPos).charAt(0));
            this.transcriptTextArea.wordBreaksBackwards(prevCharIsWhiteSpace ? 2 : 1, selectionPolicy);
        }
        this.transcriptTextArea.requestFollowCaret();
    }

    public void skipToNextWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int length;
        int caretPos = this.transcriptTextArea.getCaretPosition();
        if (caretPos <= (length = this.transcriptTextArea.getLength()) - 1) {
            boolean nextCharIsWhiteSpace = Character.isWhitespace(this.transcriptTextArea.getText(caretPos, caretPos + 1).charAt(0));
            this.transcriptTextArea.wordBreaksForwards(nextCharIsWhiteSpace ? 2 : 1, selectionPolicy);
        }
        this.transcriptTextArea.requestFollowCaret();
    }

    public void skipToPreviousParagraph(NavigationActions.SelectionPolicy selectionPolicy) {
        this.transcriptTextArea.paragraphStart(selectionPolicy);
        this.transcriptTextArea.moveTo(Math.max(0, this.transcriptTextArea.getCaretPosition() - 1), selectionPolicy);
        this.transcriptTextArea.paragraphStart(selectionPolicy);
        this.transcriptTextArea.requestFollowCaret();
    }

    public void skipToNextParagraph(NavigationActions.SelectionPolicy selectionPolicy) {
        this.transcriptTextArea.paragraphEnd(selectionPolicy);
        this.transcriptTextArea.moveTo(Math.min(this.transcriptTextArea.getLength(), this.transcriptTextArea.getCaretPosition() + 1), selectionPolicy);
        this.transcriptTextArea.paragraphEnd(selectionPolicy);
        this.transcriptTextArea.requestFollowCaret();
    }

    @Generated
    public TextAreaNavigationService(TranscriptTextArea transcriptTextArea) {
        this.transcriptTextArea = transcriptTextArea;
    }
}

