/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.AutoCompletionService;
import eu.ewerkzeug.easytranscript3.commons.TutorialService;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerService;
import eu.ewerkzeug.easytranscript3.commons.fx.TimestampService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.tutorials.ChangeOfSpeakerTutorial;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.KeyCombinationSubstitutionService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AutocompletePopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.SpeakerPopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.WordAlternativesPopup;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.reactfx.EventStreams;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TextAreaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextAreaService.class);
    private final KeyCombinationSubstitutionService keyCombinationSubstitutionService;
    private final TutorialService tutorialService;
    private final StatusService statusService;
    private final AutoCompletionService autoCompletionService;
    private final SpeakerService speakerService;
    private final AutocompletePopup autocompletePopup;
    private final WordAlternativesPopup wordAlternativesPopup;
    private final ConfigurationService configurationService;
    private final TimestampService timestampService;
    private final TranscriptService transcriptService;
    private InputMap<Event> transcriptKeyCombinationInputMap;
    private final SpeakerPopup speakerPopup;
    private Timer autocompletionServiceTimer;
    private final TranscriptTextArea transcriptTextArea;
    private final ChangeOfSpeakerTutorial changeOfSpeakerTutorial;

    public void updateTimestampFormat() {
        log.debug("Updating format of timestamp segments ...");
        this.transcriptTextArea.getParagraphs().stream().flatMap(paragraph -> paragraph.getStyledSegments().stream()).map(StyledSegment::getSegment).filter(TimestampSegment.class::isInstance).map(TimestampSegment.class::cast).forEach(arg_0 -> ((TimestampService)this.timestampService).updateSegmentFormat(arg_0));
    }

    private void setVisibleWhenEditable() {
        this.transcriptTextArea.editableProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.transcriptTextArea.setVisible(newValue != false || ((Integer)this.transcriptTextArea.lengthProperty().getValue()).longValue() != 0L);
                this.transcriptTextArea.requestFocus();
            }
        });
    }

    public void hideAllContextPopups() {
        this.wordAlternativesPopup.hide();
        this.speakerPopup.hide();
        this.autocompletePopup.hide();
    }

    @PostConstruct
    public void postConstruct() {
        this.autocompletionServiceTimer = FxTimer.createPeriodic((Duration)Duration.ofSeconds(30L), () -> ((AutoCompletionService)this.autoCompletionService).restart());
    }

    public void initializeListeners() {
        this.disableOnLoading();
        this.transcriptTextArea.richChanges().suppressWhen((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribe(f -> {
            this.hideAllContextPopups();
            this.statusService.setSaved(false);
        });
        this.restartAutocompletionTimerAfterLoading();
        this.setVisibleWhenEditable();
    }

    private void disableOnLoading() {
        this.transcriptTextArea.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadingProperty().or((ObservableBooleanValue)this.statusService.transcriptLoadedProperty().not()));
    }

    private void restartAutocompletionTimerAfterLoading() {
        EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribe(change -> {
            if (Boolean.FALSE.equals(change.getNewValue())) {
                this.autocompletionServiceTimer.restart();
            } else {
                this.autocompletionServiceTimer.stop();
            }
        });
    }

    public void insertSpeaker() {
        Speaker speaker = this.findPreviousSpeaker();
        speaker = this.transcriptService.getCurrentTranscript().getNextSpeaker(this.transcriptService.getCurrentTranscript().getSpeakers().indexOf(speaker));
        if (speaker == null && !this.transcriptService.getCurrentTranscript().getSpeakers().isEmpty()) {
            log.debug("No speaker found before caret. Inserting first speaker.");
            speaker = (Speaker)this.transcriptService.getCurrentTranscript().getSpeakers().getFirst();
        }
        if (speaker != null) {
            this.speakerService.insertSpeaker(speaker);
            this.showSpeakerTutorial();
        }
    }

    private Speaker findPreviousSpeaker() {
        List paragraphs = this.transcriptTextArea.getParagraphs().subList(0, this.transcriptTextArea.getCurrentParagraph());
        int caretPosition = this.transcriptTextArea.getCaretPosition();
        int pos = paragraphs.stream().map(Paragraph::length).mapToInt(Integer::intValue).sum();
        for (int i = paragraphs.size() - 1; i >= 0; --i) {
            Paragraph paragraph = (Paragraph)paragraphs.get(i);
            List styledSegments = paragraph.getStyledSegments();
            for (int j = styledSegments.size() - 1; j >= 0; --j) {
                Object object;
                StyledSegment segment = (StyledSegment)styledSegments.get(j);
                if (pos <= caretPosition && (object = segment.getSegment()) instanceof SpeakerSegment) {
                    SpeakerSegment speakerSegment = (SpeakerSegment)object;
                    Optional<Speaker> first = this.transcriptService.getCurrentTranscript().getSpeakers().stream().filter(s -> s.getUuid().toString().equals(speakerSegment.getUuid())).findFirst();
                    if (first.isPresent()) {
                        return first.get();
                    }
                }
                pos -= ((AbstractSegment)segment.getSegment()).length();
            }
        }
        return null;
    }

    private void showSpeakerTutorial() {
        if (!this.configurationService.getConfiguration().getSeenTutorials().contains("ChangeOfSpeaker")) {
            FxTimer.runLater((Duration)Duration.ofMillis(200L), () -> this.tutorialService.show((Tutorial)this.changeOfSpeakerTutorial).subscribeForOne(ignored -> {
                this.configurationService.getConfiguration().getSeenTutorials().add("ChangeOfSpeaker");
                this.configurationService.save();
            }));
        }
    }

    public void registerTranscriptKeyCombinationSubstitution() {
        Nodes.removeInputMap((Node)this.transcriptTextArea, (InputMap)this.transcriptKeyCombinationInputMap);
        this.keyCombinationSubstitutionService.initKeyCombinations();
        if (this.configurationService.getConfiguration().isAutoCorrectionActive()) {
            this.keyCombinationSubstitutionService.initAutoCorrection();
        } else {
            this.keyCombinationSubstitutionService.disableAutoCorrection();
        }
        ArrayList maps = new ArrayList();
        this.transcriptService.getCurrentTranscript().getKeyCombinationFields().forEach((s, s2) -> {
            if (!(KeyCombination.valueOf((String)(s = KeyCombinationTextField.replaceSpecificByPlatformIndependent((String)s))) instanceof KeyCharacterCombination)) {
                maps.add(InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)KeyCombination.valueOf((String)s)), e -> {
                    if (this.transcriptTextArea.getSelection().getLength() == 0) {
                        this.transcriptTextArea.insertText(this.transcriptTextArea.getCaretPosition(), s2);
                    } else {
                        this.transcriptTextArea.replaceSelection(s2);
                    }
                    this.transcriptTextArea.requestFollowCaret();
                }));
            }
        });
        InputMap[] array = maps.toArray(new InputMap[0]);
        this.transcriptKeyCombinationInputMap = InputMap.sequence((InputMap[])array);
        Nodes.addInputMap((Node)this.transcriptTextArea, (InputMap)this.transcriptKeyCombinationInputMap);
    }

    @Generated
    public TextAreaService(KeyCombinationSubstitutionService keyCombinationSubstitutionService, TutorialService tutorialService, StatusService statusService, AutoCompletionService autoCompletionService, SpeakerService speakerService, AutocompletePopup autocompletePopup, WordAlternativesPopup wordAlternativesPopup, ConfigurationService configurationService, TimestampService timestampService, TranscriptService transcriptService, SpeakerPopup speakerPopup, TranscriptTextArea transcriptTextArea, ChangeOfSpeakerTutorial changeOfSpeakerTutorial) {
        this.keyCombinationSubstitutionService = keyCombinationSubstitutionService;
        this.tutorialService = tutorialService;
        this.statusService = statusService;
        this.autoCompletionService = autoCompletionService;
        this.speakerService = speakerService;
        this.autocompletePopup = autocompletePopup;
        this.wordAlternativesPopup = wordAlternativesPopup;
        this.configurationService = configurationService;
        this.timestampService = timestampService;
        this.transcriptService = transcriptService;
        this.speakerPopup = speakerPopup;
        this.transcriptTextArea = transcriptTextArea;
        this.changeOfSpeakerTutorial = changeOfSpeakerTutorial;
    }
}

