/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.paint.Color;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextStyle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextStyle.class);
    public static final TextStyle EMPTY = new TextStyle();
    public final Optional<Boolean> boldOptional;
    public final Optional<Boolean> italicOptional;
    public final Optional<Boolean> underlineOptional;
    public final Optional<Boolean> strikethroughOptional;
    public final Optional<Integer> fontSizeOptional;
    public final Optional<String> fontFamilyOptional;
    public final Optional<Color> textColorOptional;
    public final Optional<Color> backgroundColorOptional;
    @Deprecated(forRemoval=true)
    public final Optional<String> wordAlternativesOptional;
    @Deprecated(forRemoval=true)
    public final Optional<Float> wordConfidenceOptional;

    public TextStyle() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static TextStyle bold(boolean bold) {
        return EMPTY.updateBold(bold);
    }

    public static TextStyle italic(boolean italic) {
        return EMPTY.updateItalic(italic);
    }

    public static TextStyle underline(boolean underline) {
        return EMPTY.updateUnderline(underline);
    }

    public static TextStyle strikethrough(boolean strikethrough) {
        return EMPTY.updateStrikethrough(strikethrough);
    }

    public static TextStyle fontSize(int fontSize) {
        return EMPTY.updateFontSize(fontSize);
    }

    public static TextStyle fontFamily(String family) {
        return EMPTY.updateFontFamily(family);
    }

    public static TextStyle textColor(Color color) {
        return EMPTY.updateTextColor(color);
    }

    public static TextStyle backgroundColor(Color color) {
        return EMPTY.updateBackgroundColor(color);
    }

    public static String cssColor(Color color) {
        int red = (int)(color.getRed() * 255.0);
        int green = (int)(color.getGreen() * 255.0);
        int blue = (int)(color.getBlue() * 255.0);
        return "rgb(" + red + ", " + green + ", " + blue + ")";
    }

    public static Color cssColor(String color) {
        Pattern pattern = Pattern.compile("rgb\\((\\d*),\\s*(\\d*),\\s*(\\d*)\\)");
        Matcher matcher = pattern.matcher(color);
        if (matcher.find()) {
            int red = Integer.parseInt(matcher.group(1));
            int green = Integer.parseInt(matcher.group(2));
            int blue = Integer.parseInt(matcher.group(3));
            return new Color((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, 1.0);
        }
        return new Color(0.0, 0.0, 0.0, 0.0);
    }

    public int hashCode() {
        return Objects.hash(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional);
    }

    public boolean equals(Object other) {
        if (other instanceof TextStyle) {
            TextStyle that = (TextStyle)other;
            return Objects.equals(this.boldOptional, that.boldOptional) && Objects.equals(this.italicOptional, that.italicOptional) && Objects.equals(this.underlineOptional, that.underlineOptional) && Objects.equals(this.strikethroughOptional, that.strikethroughOptional) && Objects.equals(this.fontSizeOptional, that.fontSizeOptional) && Objects.equals(this.fontFamilyOptional, that.fontFamilyOptional) && Objects.equals(this.textColorOptional, that.textColorOptional) && Objects.equals(this.backgroundColorOptional, that.backgroundColorOptional);
        }
        return false;
    }

    public String toCss() {
        return this.toCss(false);
    }

    public String toCss(boolean replaceQuotesAroundfontFamily) {
        Color color;
        StringBuilder sb = new StringBuilder();
        if (this.boldOptional.isPresent()) {
            if (this.boldOptional.orElse(false).booleanValue()) {
                sb.append("-fx-font-weight: bold;");
            } else {
                sb.append("-fx-font-weight: normal;");
            }
        }
        if (this.italicOptional.isPresent()) {
            if (this.italicOptional.orElse(false).booleanValue()) {
                sb.append("-fx-font-style: italic;");
            } else {
                sb.append("-fx-font-style: normal;");
            }
        }
        if (this.underlineOptional.isPresent()) {
            if (this.underlineOptional.orElse(false).booleanValue()) {
                sb.append("-fx-underline: true;");
            } else {
                sb.append("-fx-underline: false;");
            }
        }
        if (this.strikethroughOptional.isPresent()) {
            if (this.strikethroughOptional.orElse(false).booleanValue()) {
                sb.append("-fx-strikethrough: true;");
            } else {
                sb.append("-fx-strikethrough: false;");
            }
        }
        this.fontSizeOptional.ifPresent(integer -> sb.append("-fx-font-size: ").append(integer).append("pt;"));
        this.fontFamilyOptional.ifPresent(s -> sb.append("-fx-font-family: ").append(replaceQuotesAroundfontFamily ? s.replace("\"", "") : s).append(";"));
        if (this.textColorOptional.isPresent()) {
            color = (Color)this.textColorOptional.get();
            sb.append("-fx-fill: ").append(TextStyle.cssColor((Color)color)).append(";");
            sb.append("-fx-text-fill: ").append(TextStyle.cssColor((Color)color)).append(";");
        }
        if (this.backgroundColorOptional.isPresent() && !(color = (Color)this.backgroundColorOptional.get()).equals((Object)Color.TRANSPARENT)) {
            sb.append("-rtfx-background-color: ").append(TextStyle.cssColor((Color)color)).append(";");
        }
        return sb.toString();
    }

    public String toRealCss() {
        return this.toRealCss(true);
    }

    public String toRealCss(boolean withColors) {
        Color color;
        StringBuilder sb = new StringBuilder();
        if (this.boldOptional.isPresent() && this.boldOptional.orElse(false).booleanValue()) {
            sb.append("font-weight: bold;");
        }
        if (this.italicOptional.isPresent() && this.italicOptional.orElse(false).booleanValue()) {
            sb.append("font-style: italic;");
        }
        if (this.underlineOptional.isPresent() && this.underlineOptional.orElse(false).booleanValue()) {
            sb.append("text-decoration: underline;");
        }
        this.fontSizeOptional.ifPresent(integer -> sb.append("font-size: ").append(integer).append("pt;"));
        this.fontFamilyOptional.ifPresent(s -> sb.append("font-family: ").append(s.replace("\"", "")).append(";"));
        if (this.textColorOptional.isPresent() && withColors) {
            color = (Color)this.textColorOptional.get();
            sb.append("color: ").append(TextStyle.cssColor((Color)color)).append(";");
        }
        if (this.backgroundColorOptional.isPresent() && !(color = (Color)this.backgroundColorOptional.get()).equals((Object)Color.TRANSPARENT)) {
            sb.append("background-color: ").append(TextStyle.cssColor((Color)color)).append(";");
        }
        return sb.toString();
    }

    public TextStyle updateWith(TextStyle mixin) {
        return new TextStyle(mixin.boldOptional.isPresent() ? mixin.boldOptional : this.boldOptional, mixin.italicOptional.isPresent() ? mixin.italicOptional : this.italicOptional, mixin.underlineOptional.isPresent() ? mixin.underlineOptional : this.underlineOptional, mixin.strikethroughOptional.isPresent() ? mixin.strikethroughOptional : this.strikethroughOptional, mixin.fontSizeOptional.isPresent() ? mixin.fontSizeOptional : this.fontSizeOptional, mixin.fontFamilyOptional.isPresent() ? mixin.fontFamilyOptional : this.fontFamilyOptional, mixin.textColorOptional.isPresent() ? mixin.textColorOptional : this.textColorOptional, mixin.backgroundColorOptional.isPresent() ? mixin.backgroundColorOptional : this.backgroundColorOptional, mixin.wordAlternativesOptional.isPresent() ? mixin.wordAlternativesOptional : this.wordAlternativesOptional, mixin.wordConfidenceOptional.isPresent() ? mixin.wordConfidenceOptional : this.wordConfidenceOptional);
    }

    public TextStyle updateBold(boolean bold) {
        return new TextStyle(Optional.of(bold), this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateItalic(boolean italic) {
        return new TextStyle(this.boldOptional, Optional.of(italic), this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateUnderline(boolean underline) {
        return new TextStyle(this.boldOptional, this.italicOptional, Optional.of(underline), this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateStrikethrough(boolean strikethrough) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, Optional.of(strikethrough), this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateFontSize(int fontSize) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, Optional.of(fontSize), this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateFontFamily(String fontFamily) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, Optional.of(fontFamily), this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateTextColor(Color textColor) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, Optional.ofNullable(textColor), this.backgroundColorOptional, this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateBackgroundColor(Color backgroundColor) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, Optional.of(backgroundColor), this.wordAlternativesOptional, this.wordConfidenceOptional);
    }

    public TextStyle updateWordAlternatives(String alternatives) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, Optional.ofNullable(alternatives), this.wordConfidenceOptional);
    }

    public TextStyle updateWordConfidence(float confidence) {
        return new TextStyle(this.boldOptional, this.italicOptional, this.underlineOptional, this.strikethroughOptional, this.fontSizeOptional, this.fontFamilyOptional, this.textColorOptional, this.backgroundColorOptional, this.wordAlternativesOptional, Optional.of(Float.valueOf(confidence)));
    }

    public String toString() {
        return "TextStyle{boldOptional=" + String.valueOf(this.boldOptional) + ", italicOptional=" + String.valueOf(this.italicOptional) + ", underlineOptional=" + String.valueOf(this.underlineOptional) + ", strikethroughOptional=" + String.valueOf(this.strikethroughOptional) + ", fontSizeOptional=" + String.valueOf(this.fontSizeOptional) + ", fontFamilyOptional=" + String.valueOf(this.fontFamilyOptional) + ", textColorOptional=" + String.valueOf(this.textColorOptional) + ", backgroundColorOptional=" + String.valueOf(this.backgroundColorOptional) + "}";
    }

    @Generated
    public TextStyle(Optional<Boolean> boldOptional, Optional<Boolean> italicOptional, Optional<Boolean> underlineOptional, Optional<Boolean> strikethroughOptional, Optional<Integer> fontSizeOptional, Optional<String> fontFamilyOptional, Optional<Color> textColorOptional, Optional<Color> backgroundColorOptional, Optional<String> wordAlternativesOptional, Optional<Float> wordConfidenceOptional) {
        this.boldOptional = boldOptional;
        this.italicOptional = italicOptional;
        this.underlineOptional = underlineOptional;
        this.strikethroughOptional = strikethroughOptional;
        this.fontSizeOptional = fontSizeOptional;
        this.fontFamilyOptional = fontFamilyOptional;
        this.textColorOptional = textColorOptional;
        this.backgroundColorOptional = backgroundColorOptional;
        this.wordAlternativesOptional = wordAlternativesOptional;
        this.wordConfidenceOptional = wordConfidenceOptional;
    }
}

