/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.util.function.Function;
import javafx.scene.control.IndexRange;
import lombok.Generated;
import org.fxmisc.richtext.model.StyleSpans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextStyleManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextStyleManager.class);
    private final TranscriptTextArea textArea;

    public void toggleBold() {
        this.updateStyleInSelection(spans -> TextStyle.bold((!spans.styleStream().allMatch(style -> style.boldOptional.orElse(false)) ? 1 : 0) != 0));
        this.textArea.requestFocus();
    }

    public void toggleItalic() {
        this.updateStyleInSelection(spans -> TextStyle.italic((!spans.styleStream().allMatch(style -> style.italicOptional.orElse(false)) ? 1 : 0) != 0));
        this.textArea.requestFocus();
    }

    public void toggleUnderline() {
        this.updateStyleInSelection(spans -> TextStyle.underline((!spans.styleStream().allMatch(style -> style.underlineOptional.orElse(false)) ? 1 : 0) != 0));
        this.textArea.requestFocus();
    }

    private void updateStyleInSelection(Function<StyleSpans<TextStyle>, TextStyle> mixinGetter) {
        IndexRange selection = this.textArea.getSelection();
        if (selection.getLength() != 0) {
            StyleSpans styles = this.textArea.getStyleSpans(selection);
            TextStyle mixin = mixinGetter.apply((StyleSpans<TextStyle>)styles);
            StyleSpans newStyles = styles.mapStyles(style -> style.updateWith(mixin));
            this.textArea.setStyleSpans(selection.getStart(), newStyles);
        }
    }

    public void updateStyleInSelection(TextStyle mixin) {
        IndexRange selection = this.textArea.getSelection();
        if (selection.getLength() != 0) {
            StyleSpans styles = this.textArea.getStyleSpans(selection);
            StyleSpans newStyles = styles.mapStyles(style -> style.updateWith(mixin));
            this.textArea.setStyleSpans(selection.getStart(), newStyles);
        }
    }

    @Generated
    public TextStyleManager(TranscriptTextArea textArea) {
        this.textArea = textArea;
    }
}

