/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentCodec;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentOps;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParagraphStyleManager;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyleManager;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.UndoUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ZoomService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.TextAlignment;
import lombok.Generated;
import org.fxmisc.flowless.ScaledVirtualized;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.ClipboardActions;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.UndoActions;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextOps;
import org.reactfx.SuspendableYes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Lazy(value=false)
public class TranscriptTextArea
extends GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>
implements ClipboardActions<ParStyle, AbstractSegment<?>, TextStyle>,
UndoActions {
    public static final SegmentOps STYLED_TEXT_OPS = new SegmentOps();
    public static final String PARAGRAPH_TAG = "Paragraph";
    private final Logger log = LoggerFactory.getLogger(TranscriptTextArea.class);
    private final ZoomService zoomService;
    private final SuspendableYes undoSuspendable = new SuspendableYes();
    private final SegmentCodec segmentCodec;
    private final ConfigurationService configurationService;
    private ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>> scaledVirtualized;
    private VirtualizedScrollPane<ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>>> vsPane;
    private TextStyleManager textStyleManager;
    private ParagraphStyleManager paragraphStyleManager;

    public TranscriptTextArea(ZoomService zoomService, SegmentCodec segmentCodec, ConfigurationService configurationService) {
        super((Object)TranscriptTextArea.getDefaultParagraphStyle((Configuration)configurationService.getConfiguration()), (paragraph, style) -> paragraph.setStyle(style.toCss()), (Object)TranscriptTextArea.getDefaultTextStyle((Configuration)configurationService.getConfiguration()), (TextOps)STYLED_TEXT_OPS, styledSeg -> ((AbstractSegment)styledSeg.getSegment()).createNode((TextStyle)styledSeg.getStyle()));
        this.zoomService = zoomService;
        this.segmentCodec = segmentCodec;
        this.configurationService = configurationService;
    }

    public static TextStyle getDefaultTextStyle(Configuration conf) {
        return TextStyle.EMPTY.updateFontSize(conf.getFormattingSize()).updateFontFamily(conf.getFormattingFont()).updateBold(conf.isFormattingBold()).updateItalic(conf.isFormattingItalic()).updateUnderline(conf.isFormattingUnderlined()).updateTextColor(null);
    }

    public static ParStyle getDefaultParagraphStyle(Configuration configuration) {
        TextAlignment textAlignment = configuration.getFormattingParagraphAlignment();
        if (textAlignment == null) {
            textAlignment = TextAlignment.LEFT;
        }
        return ParStyle.EMPTY.updateAlignment(textAlignment);
    }

    @PostConstruct
    public void init() {
        this.log.debug("Initializing transcriptTextArea.");
        this.setUndoManager(UndoUtils.richTextUncheckedUndoManager((GenericStyledArea)this, (SuspendableYes)this.undoSuspendable));
        this.addZoomOnScroll();
        this.log.debug("Adding listeners and setting configuration.");
        this.caretPositionProperty().addListener((observable, oldValue, newValue) -> this.requestFollowCaret());
        this.setShowCaret(Caret.CaretVisibility.AUTO);
        this.setWrapText(true);
        this.log.debug("Setting style codecs.");
        this.setStyleCodecs(ParStyle.CODEC, (Codec)this.segmentCodec);
        this.textStyleManager = new TextStyleManager(this);
        this.paragraphStyleManager = new ParagraphStyleManager(this);
        this.scaledVirtualized = new ScaledVirtualized((Node)this);
        this.scaledVirtualized.getZoom().xProperty().bind((ObservableValue)this.zoomService.getZoomLevel());
        this.scaledVirtualized.getZoom().yProperty().bind((ObservableValue)this.zoomService.getZoomLevel());
        this.vsPane = new VirtualizedScrollPane((Region)this.scaledVirtualized);
        this.vsPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.log.info("TranscriptTextArea initialized.");
    }

    private void addZoomOnScroll() {
        this.addEventFilter(ScrollEvent.ANY, e -> {
            if (e.isShortcutDown()) {
                e.consume();
                this.zoomService.zoom(e.getDeltaY() > 0.0);
            }
        });
    }

    public void runInPreventUndoMerge(Runnable runnable) {
        this.getUndoManager().preventMerge();
        runnable.run();
        this.getUndoManager().preventMerge();
    }

    public void commitMultiChange(MultiChangeBuilder<?, ?, ?> multiChange) {
        this.runInPreventUndoMerge(() -> multiChange.commit());
    }

    public IndexRange getSelection() {
        int end;
        IndexRange selection = super.getSelection();
        int maxEnd = this.getLength();
        int start = Math.min(Math.max(selection.getStart(), 0), maxEnd);
        if (start > (end = Math.max(0, Math.min(selection.getEnd(), maxEnd)))) {
            end = start;
        }
        return new IndexRange(start, end);
    }

    public void replaceTextWithoutMovingCaret(int start, int end, String text) {
        ReadOnlyStyledDocument doc = ReadOnlyStyledDocument.fromSegment((Object)new StyledTextSegment((Object)text), (Object)((ParStyle)this.getParagraphStyleForInsertionAt(start)), (Object)((TextStyle)this.getStyleAtPosition(start)), (org.fxmisc.richtext.model.SegmentOps)STYLED_TEXT_OPS);
        this.replaceWithoutMovingCaret(start, end, (StyledDocument)doc);
    }

    public void replaceWithoutMovingCaret(int start, int end, StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> doc) {
        ((EditableStyledDocument)this.getDocument()).replace(start, end, doc);
    }

    public int findAbsolutePositionOfSegment(AbstractSegment<?> segment) {
        Paragraph currentParagraph = this.getParagraph(this.getCurrentParagraph());
        List segments = currentParagraph.getSegments();
        int index = segments.stream().takeWhile(seg -> !seg.equals((Object)segment)).mapToInt(AbstractSegment::length).sum();
        int absoluteParPosition = this.getAbsolutePosition(this.getCurrentParagraph(), 0);
        return index += absoluteParPosition;
    }

    @Generated
    public ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>> getScaledVirtualized() {
        return this.scaledVirtualized;
    }

    @Generated
    public VirtualizedScrollPane<ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>>> getVsPane() {
        return this.vsPane;
    }

    @Generated
    public TextStyleManager getTextStyleManager() {
        return this.textStyleManager;
    }

    @Generated
    public ParagraphStyleManager getParagraphStyleManager() {
        return this.paragraphStyleManager;
    }
}

