/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import com.jfoenix.controls.JFXListView;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntry;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.stage.Popup;
import javafx.stage.Window;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPopup<ListEntry extends PopupEntry, PositioningReference>
extends Popup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPopup.class);
    private final TranscriptTextArea transcriptTextArea;
    JFXListView<ListEntry> listView;

    protected AbstractPopup(TranscriptTextArea transcriptTextArea) {
        this.transcriptTextArea = transcriptTextArea;
        this.setAutoHide(true);
        this.listView = new JFXListView();
        this.listView.setMaxHeight(400.0);
        this.listView.setPrefWidth(165.0);
        this.listView.setMinHeight(60.0);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.listView);
        scrollPane.getStyleClass().add((Object)"suggestion-popup");
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.getContent().add((Object)scrollPane);
        this.listView.setOnMouseClicked(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 1 && this.listView.getSelectionModel().getSelectedItem() != null) {
                this.insertValue();
            }
        });
        this.listView.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.insertValue();
            }
            if (event.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.hide();
            }
            if (event.getCode().equals((Object)KeyCode.RIGHT)) {
                transcriptTextArea.moveTo(transcriptTextArea.getCaretPosition() + 1);
                this.hide();
            }
            if (event.getCode().equals((Object)KeyCode.LEFT)) {
                transcriptTextArea.moveTo(transcriptTextArea.getCaretPosition() - 1);
                this.hide();
            }
        });
    }

    private void insertValue() {
        PopupEntry text = (PopupEntry)this.listView.getSelectionModel().getSelectedItem();
        this.insert(text);
        this.hide();
    }

    abstract void insert(ListEntry var1);

    void showAt(ExtendedController controller, double x, double y) {
        this.getScene().getRoot().setEffect(((MainController)controller).getMenuBarController().getRoot().getEffect());
        this.show((Window)controller.getStage(), x, y);
        this.listView.getSelectionModel().select(0);
    }

    abstract void show(PositioningReference var1);

    @Generated
    public TranscriptTextArea getTranscriptTextArea() {
        return this.transcriptTextArea;
    }
}

