/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AutocompleteWord;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PartialHighlightedListCell;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PositioningReferencePopup;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class AutocompletePopup
extends PositioningReferencePopup<AutocompleteWord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutocompletePopup.class);
    private final ConfigurationService configurationService;
    private String lastPrefix;

    public AutocompletePopup(TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, GuiStateService guiStateService) {
        super(guiStateService, transcriptTextArea);
        this.configurationService = configurationService;
    }

    @PostConstruct
    public void init() {
        this.listView.setCellFactory(stringListView -> new PartialHighlightedListCell());
    }

    public void insert(AutocompleteWord word) {
        log.debug("Selected auto complete word, inserting.");
        this.getTranscriptTextArea().insertText(this.getTranscriptTextArea().getCaretPosition(), word.getText().substring(this.lastPrefix.length()));
    }

    public boolean findWordSuggestions(Set<String> wordSet, String prefix) {
        this.lastPrefix = prefix;
        if (prefix.length() < this.configurationService.getConfiguration().getAutocompletionThreshold()) {
            this.hide();
            return false;
        }
        List<AutocompleteWord> collect = wordSet.stream().filter(highlightable -> !highlightable.equals(prefix) && highlightable.startsWith(prefix)).map(f -> new AutocompleteWord(f, prefix.length())).sorted(Comparator.comparingInt(f -> f.getText().length())).toList();
        if (collect.isEmpty()) {
            this.hide();
            return false;
        }
        this.listView.setItems(FXCollections.observableList(new ArrayList<AutocompleteWord>(collect)));
        return true;
    }
}

