/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AbstractPopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntry;
import java.util.Optional;
import javafx.geometry.Bounds;
import org.apache.commons.lang3.tuple.Triple;

public abstract class PositioningReferencePopup<Entry extends PopupEntry>
extends AbstractPopup<Entry, Triple<String, Integer, Integer>> {
    private final GuiStateService guiStateService;

    protected PositioningReferencePopup(GuiStateService guiStateService, TranscriptTextArea transcriptTextArea) {
        super(transcriptTextArea);
        this.guiStateService = guiStateService;
    }

    public void show(Triple<String, Integer, Integer> positioningReference) {
        double x = -1.0;
        double y = -1.0;
        if (this.getTranscriptTextArea().getCaretBounds().isEmpty() && this.getBoundsOfFirstCharacterOfLastWord(positioningReference).isEmpty()) {
            this.getTranscriptTextArea().getVsPane().scrollYBy(100.0);
        }
        Optional characterBoundsOnScreen = this.getBoundsOfFirstCharacterOfLastWord(positioningReference);
        Optional caretBounds = this.getTranscriptTextArea().getCaretBounds();
        if (caretBounds.isPresent()) {
            x = ((Bounds)caretBounds.get()).getMaxX();
            y = ((Bounds)caretBounds.get()).getMaxY();
        }
        if (characterBoundsOnScreen.isPresent()) {
            x = ((Bounds)characterBoundsOnScreen.get()).getMinX();
            y = ((Bounds)characterBoundsOnScreen.get()).getMaxY();
        }
        this.showAt(this.guiStateService.getController(), x, y);
    }

    private Optional<Bounds> getBoundsOfFirstCharacterOfLastWord(Triple<String, Integer, Integer> lastWord) {
        int charIndex;
        if (lastWord == null || lastWord.getLeft() == null || ((String)lastWord.getLeft()).isEmpty()) {
            return Optional.empty();
        }
        for (charIndex = ((Integer)lastWord.getMiddle()).intValue(); charIndex < (Integer)lastWord.getRight() && (Character.isISOControl(this.getTranscriptTextArea().getText(charIndex, charIndex + 1).charAt(0)) || Character.isWhitespace(this.getTranscriptTextArea().getText(charIndex, charIndex + 1).charAt(0))); ++charIndex) {
        }
        if (charIndex >= (Integer)lastWord.getRight()) {
            return Optional.empty();
        }
        int startIndex = Math.min(charIndex, this.getTranscriptTextArea().getLength() - 1);
        int endIndex = Math.min(charIndex + 1, this.getTranscriptTextArea().getLength());
        return this.getTranscriptTextArea().getCharacterBoundsOnScreen(startIndex, endIndex);
    }
}

