/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerListCell;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AbstractPopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.ShowSpeakerPopupEvent;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Bounds;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SpeakerPopup
extends AbstractPopup<Speaker, SpeakerSegment> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerPopup.class);
    private final SpeakerService speakerService;
    private final GuiStateService guiStateService;
    SpeakerSegment speakerSegment = null;

    public SpeakerPopup(SpeakerService speakerService, TranscriptTextArea transcriptTextArea, GuiStateService guiStateService) {
        super(transcriptTextArea);
        this.speakerService = speakerService;
        this.guiStateService = guiStateService;
    }

    @PostConstruct
    public void init() {
        this.listView.setCellFactory(stringListView -> new SpeakerListCell());
    }

    @EventListener
    public void handleShowRequest(ShowSpeakerPopupEvent event) {
        this.setSpeakers(event.suggestedSpeakers());
        this.show(event.segment());
    }

    public void show(SpeakerSegment speakerSegment) {
        Platform.runLater(() -> {
            this.speakerSegment = speakerSegment;
            if (speakerSegment.getLabel() != null) {
                Bounds boundsOfTextArea = speakerSegment.getLabel().localToScreen(speakerSegment.getLabel().getBoundsInLocal());
                double x = 0.0;
                double y = 0.0;
                if (boundsOfTextArea != null) {
                    x = boundsOfTextArea.getMinX();
                    y = boundsOfTextArea.getMaxY();
                }
                this.showAt(this.guiStateService.getController(), x, y);
                return;
            }
            TranscriptTextArea textArea = this.getTranscriptTextArea();
            Optional caretBounds = textArea.getCaretBounds();
            Bounds boundsOfTextArea = textArea.localToScreen(textArea.getBoundsInLocal());
            double x = boundsOfTextArea.getMinX();
            double y = boundsOfTextArea.getMinY();
            if (caretBounds.isPresent()) {
                x = ((Bounds)caretBounds.get()).getMaxX();
                y = ((Bounds)caretBounds.get()).getMaxY();
            }
            this.showAt(this.guiStateService.getController(), x, y);
        });
    }

    public void setSpeakers(List<Speaker> speakers) {
        this.listView.setItems(FXCollections.observableArrayList(speakers));
    }

    void insert(Speaker speaker) {
        int pos = 0;
        List styledSegments = this.getTranscriptTextArea().getParagraph(this.getTranscriptTextArea().getCurrentParagraph()).getStyledSegments();
        for (StyledSegment s : styledSegments) {
            SpeakerSegment speakerSeg;
            pos += ((AbstractSegment)s.getSegment()).length();
            Object object = s.getSegment();
            if (!(object instanceof SpeakerSegment) || (speakerSeg = (SpeakerSegment)object).getLabel() != this.speakerSegment.getLabel()) continue;
            break;
        }
        int moveBy = pos - this.getTranscriptTextArea().getCaretColumn();
        this.getTranscriptTextArea().moveTo(this.getTranscriptTextArea().getCaretPosition() + moveBy);
        this.getTranscriptTextArea().getUndoManager().preventMerge();
        this.getTranscriptTextArea().deletePreviousChar();
        this.speakerService.insertSpeaker(speaker, false);
        this.getTranscriptTextArea().getUndoManager().preventMerge();
    }

    @Generated
    public SpeakerService getSpeakerService() {
        return this.speakerService;
    }
}

