/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceData;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntry;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntryListCell;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PositioningReferencePopup;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WordAlternativesPopup
extends PositioningReferencePopup<PopupEntry> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WordAlternativesPopup.class);
    private final MessageService messageService;
    private final GuiStateService guiStateService;
    private LowConfidenceSegment lowConfidenceSegment;

    public WordAlternativesPopup(TranscriptTextArea transcriptTextArea, MessageService messageService, GuiStateService guiStateService) {
        super(guiStateService, transcriptTextArea);
        this.messageService = messageService;
        this.guiStateService = guiStateService;
    }

    @PostConstruct
    public void init() {
        this.listView.setCellFactory(stringListView -> new PopupEntryListCell());
        SpacedText spacedText = new SpacedText(this.messageService.getLocaleBundle().getString("mainScreen.noAlternativesFound"), Double.valueOf(0.8));
        spacedText.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.listView.setPlaceholder((Node)spacedText);
    }

    void insert(PopupEntry alternative) {
        int index = this.getTranscriptTextArea().findAbsolutePositionOfSegment((AbstractSegment)this.lowConfidenceSegment);
        String selected = ((PopupEntry)this.listView.getSelectionModel().getSelectedItem()).getText();
        LowConfidenceSegment replacementSegment = this.getLowConfidenceReplacementSegment(selected);
        this.getTranscriptTextArea().replace(index, index + this.lowConfidenceSegment.length(), (Object)replacementSegment, (Object)((TextStyle)this.getTranscriptTextArea().getTextInsertionStyle()));
    }

    @NotNull
    private LowConfidenceSegment getLowConfidenceReplacementSegment(String selected) {
        LowConfidenceData lowConfidenceData = new LowConfidenceData();
        ArrayList<String> alternatives = new ArrayList<String>(this.lowConfidenceSegment.getAlternatives());
        alternatives.add(this.lowConfidenceSegment.getRealText());
        alternatives.remove(selected);
        lowConfidenceData.setWord(selected);
        lowConfidenceData.setAlternatives(alternatives);
        lowConfidenceData.setConfidence(lowConfidenceData.getConfidence());
        return new LowConfidenceSegment(lowConfidenceData, true);
    }

    public void show(LowConfidenceSegment lowConfidenceSegment) {
        this.lowConfidenceSegment = lowConfidenceSegment;
        if (lowConfidenceSegment == null) {
            log.warn("No low confidence segment set.");
            return;
        }
        Bounds bounds = lowConfidenceSegment.getTextNode().localToScreen(lowConfidenceSegment.getTextNode().getLayoutBounds());
        this.showAt(this.guiStateService.getController(), bounds.getMinX(), bounds.getMaxY());
    }

    public void addWordAlternativesToPopup(List<String> words) {
        this.listView.getItems().clear();
        if (!words.isEmpty()) {
            this.listView.setPrefHeight(-1.0);
            List<PopupEntry> popupEntries = words.stream().map(PopupEntry::new).toList();
            this.listView.getItems().addAll(popupEntries);
            this.listView.refresh();
        } else {
            this.listView.setPrefHeight(60.0);
        }
    }
}

