/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.menubar;

import com.jthemedetecor.util.OsInfo;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.ScenicView;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.Tooltip;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.ExportService;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.about.AboutController;
import eu.ewerkzeug.easytranscript3.mvc.license.LicenseController;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.mvc.main.MiscService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.DocumentSerializer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ZoomService;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.AutomaticTranscriptionStatusController;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.MenuBarService;
import eu.ewerkzeug.easytranscript3.mvc.programsettings.ProgramSettingsController;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.TimeTrackingController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.TranscriptCreationUIHelperService;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.CreateTranscriptController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.importtranscript.ImportTranscriptController;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.print.PrinterJob;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxmlView;
import org.controlsfx.control.PopOver;
import org.fxmisc.richtext.Caret;
import org.girod.javafx.svgimage.SVGImage;
import org.girod.javafx.svgimage.SVGLoader;
import org.jetbrains.annotations.NotNull;
import org.reactfx.EventStreams;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.stereotype.Component;

@FxmlView(value="menuBar.fxml")
@Component
@Lazy
public class MenuBarController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuBarController.class);
    private final LicenseService licenseService;
    private final ExportService exportService;
    private final SaveTranscriptService saveTranscriptService;
    private final MiscService miscService;
    private final CloseDialog closeDialog;
    private final UpdaterService updaterService;
    private final StatusService statusService;
    private final MenuBarService menuBarService;
    private final LoadTranscriptService loadTranscriptService;
    private final List<Tooltip> tooltipList = new ArrayList();
    private final PopOver automaticTranscriptionStatusPopover = new PopOver();
    private final STTStatusService sttStatusService;
    private final TranscriptTextArea transcriptTextArea;
    private final ZoomService zoomService;
    private final ConfigurationService configurationService;
    private final LicenseValidationService licenseValidationService;
    private final TranscriptCreationUIHelperService transcriptCreationUIHelperService;
    private final DocumentSerializer documentSerializer;
    private final TranscriptService transcriptService;
    private final DialogService dialogService;
    private final GuiStateService gUIStateService;
    @FXML
    private MenuItem changeMediaFileMenuItem;
    @FXML
    private MenuItem closeTranscriptMenuItem;
    @FXML
    private MenuItem printMenuItem;
    @FXML
    private MenuItem timeTrackingMenuItem;
    @FXML
    private Menu viewMenu;
    @FXML
    private MenuItem saveAsMenuItem;
    @FXML
    private MenuItem newMenuItem;
    @FXML
    private Menu fileMenu;
    @FXML
    private MenuBar menuBar;
    @FXML
    private Button undoButton;
    @FXML
    private Button redoButton;
    @FXML
    private Button cutButton;
    @FXML
    private Button copyButton;
    @FXML
    private Button pasteButton;
    @FXML
    private CheckMenuItem restrictWidthMenuItem;
    @FXML
    private CheckMenuItem showParagraphsNumberingMenuItem;
    @FXML
    private MenuItem saveMenuItem;
    @FXML
    private Button saveButton;
    @FXML
    private Menu recentlyOpenedMenu;
    @FXML
    private CheckMenuItem integrateVideoplayerMenuItem;
    @FXML
    private Button zoomInButton;
    @FXML
    private Button zoomOutButton;
    @FXML
    private Menu editMenu;
    @FXML
    private ToolBar toolBar;
    @FXML
    private Button automaticTranscriptionStatusButton;
    @Value(value="${easytranscript.debug-tools.enabled:false}")
    private boolean debugToolsEnabled;

    private void printTextArea(Runnable action) {
        this.transcriptTextArea.setShowCaret(Caret.CaretVisibility.OFF);
        IndexRange selection = this.transcriptTextArea.getSelection();
        this.transcriptTextArea.deselect();
        double zoom = this.zoomService.getZoomLevel().doubleValue();
        String dynamicCss = this.addPrintingCss();
        action.run();
        this.transcriptTextArea.setShowCaret(Caret.CaretVisibility.AUTO);
        this.transcriptTextArea.selectRange(selection.getStart(), selection.getEnd());
        this.zoomService.setZoom(zoom);
        this.gUIStateService.getMainStage().getScene().getStylesheets().remove((Object)dynamicCss);
    }

    @NotNull
    private String addPrintingCss() {
        String css = ".styled-text-area-text {\n    -fx-fill: black !important;\n}\n\n.lct-text-new {\n    -fx-fill: -fx-lct-text-color !important;\n}\n\n.lineno {\n    -fx-text-fill: black !important;\n}\n";
        String dynamicCss = "data:text/css," + css;
        this.gUIStateService.getMainStage().getScene().getStylesheets().add((Object)dynamicCss);
        return dynamicCss;
    }

    public void reset() {
    }

    public void initializeController() {
        Platform.runLater(() -> {
            this.menuBar.useSystemMenuBarProperty().bindBidirectional((Property)this.menuBarService.getUseSystemBarMenu());
            this.restrictWidthMenuItem.setSelected(this.configurationService.getConfiguration().getWidthOfTextAreaInCm() != -1.0);
            this.showParagraphsNumberingMenuItem.setSelected(this.configurationService.getConfiguration().getShowParagraphNumbers());
            if (OsInfo.isMacOsMojaveOrLater()) {
                this.menuBar.setVisible(false);
                this.menuBar.setManaged(false);
            }
            this.updaterService.startUpdateCheck(false);
        });
        this.editMenu.getItems().addAll((Collection)this.menuBarService.createEditMenuItems(true));
        log.debug("Binding properties.");
        this.saveMenuItem.disableProperty().bind((ObservableValue)this.statusService.savedProperty().or((ObservableBooleanValue)this.statusService.transcriptLoadedProperty().not()).or((ObservableBooleanValue)this.statusService.savingProperty()));
        this.saveButton.disableProperty().bind((ObservableValue)this.statusService.savedProperty().or((ObservableBooleanValue)this.statusService.transcriptLoadedProperty().not()).or((ObservableBooleanValue)this.statusService.savingProperty()));
        this.saveAsMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.changeMediaFileMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.closeTranscriptMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.timeTrackingMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.printMenuItem.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.toolBar.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.editMenu.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.viewMenu.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        this.copyButton.disableProperty().bind((ObservableValue)this.menuBarService.getSelectionBinding());
        this.cutButton.disableProperty().bind((ObservableValue)this.menuBarService.getSelectionBinding());
        this.configurationService.getConfiguration().getProgramRecentLoadedObservableList().addListener(change -> {
            log.debug("List changed: {}", (Object)this.configurationService.getConfiguration().getProgramRecentLoadedObservableList());
            Platform.runLater(() -> this.fillRecentLoadedMenu());
        });
        this.fillRecentLoadedMenu();
        this.integrateVideoplayerMenuItem.selectedProperty().bindBidirectional((Property)this.configurationService.getConfiguration().integrateVideoplayerProperty());
        EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribeForOne(change -> {
            this.zoomInButton.disableProperty().bind((ObservableValue)this.transcriptTextArea.getScaledVirtualized().getZoom().xProperty().isEqualTo(5.0, 0.0));
            this.zoomOutButton.disableProperty().bind((ObservableValue)this.transcriptTextArea.getScaledVirtualized().getZoom().xProperty().isEqualTo(0.8, 0.0));
        });
        this.transcriptTextArea.redoAvailableProperty().addListener((observableValue, aBoolean, t1) -> this.redoButton.setDisable(t1 == false));
        this.transcriptTextArea.undoAvailableProperty().addListener((observableValue, aBoolean, t1) -> this.undoButton.setDisable(t1 == false));
        this.toolBar.getItems().forEach(f -> {
            if (f instanceof Button) {
                this.tooltipList.add(new Tooltip(f, f.getAccessibleText()));
            }
        });
        this.initializesAutomaticTranscriptionStatusInfo();
        this.initializeScenicViewShortCut();
    }

    private void initializeScenicViewShortCut() {
        this.menuBar.sceneProperty().addListener((obs, oldScene, newScene) -> {
            if (newScene != null) {
                newScene.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
                    if (this.debugToolsEnabled && event.isControlDown() && event.isShiftDown() && event.getCode() == KeyCode.S) {
                        ScenicView.tryOpenScenicView((Stage)this.gUIStateService.getMainStage());
                        event.consume();
                    }
                });
            }
        });
    }

    private void initializesAutomaticTranscriptionStatusInfo() {
        this.sttStatusService.getShowStatusInfoPopOver().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.sttStatusService.getShowStatusInfoPopOver().set(false);
                this.showAutomaticTranscriptionStatusPopover();
            }
        });
        FxControllerAndView cav = this.fxWeaver.load(AutomaticTranscriptionStatusController.class, this.messageService.getLocaleBundle());
        SVGImage img = SVGLoader.load((URL)Objects.requireNonNull(this.getClass().getResource("automatic_status.svg")));
        Group graphic = new Group(new Node[]{img});
        this.automaticTranscriptionStatusButton.setGraphic((Node)graphic);
        this.automaticTranscriptionStatusPopover.setContentNode((Node)cav.getView().orElseThrow());
        this.setDisableOfStatusButton();
        ((AutomaticTranscriptionStatusController)cav.getController()).getCloseButton().setOnAction(e -> this.automaticTranscriptionStatusPopover.hide());
        this.automaticTranscriptionStatusButton.setOnAction(ev -> this.showAutomaticTranscriptionStatusPopover());
        log.debug("Adding phase listener for status button, current phase: {}", (Object)this.sttStatusService.getState());
        this.sttStatusService.getStateMachine().addStateListener((StateMachineListener)new /* Unavailable Anonymous Inner Class!! */);
        this.handleTransferProgressInfoPhaseChange(this.sttStatusService.getState());
        this.automaticTranscriptionStatusPopover.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
        this.automaticTranscriptionStatusPopover.setArrowSize(0.0);
        this.automaticTranscriptionStatusPopover.setDetachable(false);
        this.automaticTranscriptionStatusPopover.setAutoFix(false);
        this.automaticTranscriptionStatusPopover.setCloseButtonEnabled(false);
        this.automaticTranscriptionStatusPopover.setTitle("");
        this.automaticTranscriptionStatusPopover.setAutoHide(true);
    }

    private void handleTransferProgressInfoPhaseChange(String newValue) {
        log.debug("Status of transcription job changed to {}, setting disable status of status button", (Object)newValue);
        if (newValue.equals("UPLOADING")) {
            FxTimer.runLater((Duration)Duration.ofSeconds(2L), () -> this.showAutomaticTranscriptionStatusPopover());
        } else if (newValue.equals("IDLE")) {
            this.automaticTranscriptionStatusPopover.hide();
        }
        this.setDisableOfStatusButton();
    }

    private void setDisableOfStatusButton() {
        this.automaticTranscriptionStatusButton.setVisible(!this.sttStatusService.getState().equals("IDLE"));
    }

    private void showAutomaticTranscriptionStatusPopover() {
        if (this.licenseService.getUserLicense() == null || !this.licenseService.getUserLicense().isSttEnabled()) {
            return;
        }
        Platform.runLater(() -> {
            if (this.automaticTranscriptionStatusPopover.isShowing()) {
                return;
            }
            Bounds bounds = this.automaticTranscriptionStatusButton.localToScreen(this.automaticTranscriptionStatusButton.getBoundsInLocal());
            this.automaticTranscriptionStatusPopover.show((Node)this.automaticTranscriptionStatusButton, bounds.getMinX() + bounds.getWidth() / 2.0 + 27.0, bounds.getMinY() + bounds.getHeight() + 18.0);
            ((Node)this.automaticTranscriptionStatusPopover.getContentNode().getScene().getRoot().getChildrenUnmodifiable().getFirst()).requestFocus();
        });
    }

    public void createNewTranscript() {
        this.showAdditionalScreen(CreateTranscriptController.class, Modality.WINDOW_MODAL, true);
    }

    public void loadTranscriptWithFileChooser() {
        this.loadTranscriptService.openTranscriptWithFileChooser();
    }

    public void loadOnOpenFilesAction(String path) {
        this.closeDialog.showAndWait(() -> this.loadTranscriptService.openTranscript(Path.of(path, new String[0])));
    }

    public void closeTranscript() {
        this.miscService.closeTranscript();
    }

    public void saveTranscript(ActionEvent e) {
        e.consume();
        log.info("Save triggered.");
        if (this.transcriptService.getCurrentTranscript() != null && this.transcriptService.getCurrentTranscript().getTranscriptLocation() != null) {
            this.saveTranscriptService.save(this.transcriptService.getCurrentTranscript(), this.documentSerializer.serializeContent(this.transcriptTextArea.getDocument()), false);
        } else {
            log.error("Could not save transcript because transcript or location is null. Transcript != null? {}, Location != null? {}", (Object)(this.transcriptService.getCurrentTranscript() != null ? 1 : 0), (Object)(this.transcriptService.getCurrentTranscript().getTranscriptLocation() != null ? 1 : 0));
        }
        this.transcriptTextArea.requestFocus();
    }

    public void saveAs() {
        if (!this.licenseValidationService.isUserLicenseValid()) {
            Platform.runLater(() -> ((LicenseService)this.licenseService).showLicenseNotValidDialog());
            return;
        }
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        fileChooser.getExtensionFilters().add((Object)this.transcriptService.getEttFilter());
        File file = fileChooser.showSaveDialog((Window)this.gUIStateService.getMainStage());
        if (file != null) {
            if (!file.toPath().equals(this.transcriptService.getCurrentTranscript().getTranscriptLocation())) {
                this.transcriptService.getCurrentTranscript().setTranscriptLocation(file.toPath());
                this.configurationService.getConfiguration().addToRecentLoaded(this.transcriptService.getCurrentTranscript());
                this.configurationService.save();
                this.miscService.setTitle();
            }
            this.saveTranscript(new ActionEvent());
        }
    }

    public void changeMediaFile() {
        String pathS = this.transcriptCreationUIHelperService.openMediaFile(this.gUIStateService.getMainStage());
        if (pathS == null || pathS.isBlank()) {
            return;
        }
        Path path = Path.of(pathS, new String[0]);
        if (path.getParent() != null && path.toFile().exists() && path.toFile().isFile()) {
            this.transcriptService.getCurrentTranscript().setMediaLocation(path);
            log.debug("Media location set to {}", (Object)path);
            this.statusService.mediaNeedsReloadProperty().set(true);
            this.statusService.setSaved(false);
        } else {
            this.dialogService.get(this.getMessageService().getLocaleBundle().getString("problems.mediaFileNotFound")).showAndWait();
        }
    }

    public void importTranscript() {
        this.showAdditionalScreen(ImportTranscriptController.class, Modality.WINDOW_MODAL, false);
    }

    public void export() {
        log.debug("Triggered export menu item ...");
        if (this.transcriptService.getCurrentTranscript().getTranscriptLocation() == null) {
            return;
        }
        this.exportService.showExportDialog(this.transcriptTextArea.getDocument());
    }

    public void openTimeTracking() {
        if (this.transcriptService.getCurrentTranscript().getTranscriptLocation() == null) {
            return;
        }
        this.showAdditionalScreen(TimeTrackingController.class, Modality.WINDOW_MODAL, null, (Window)this.gUIStateService.getMainStage(), true, null);
    }

    public void print() {
        if (this.transcriptService.getCurrentTranscript().getTranscriptLocation() == null) {
            return;
        }
        log.debug("Printing transcript ...");
        if (!this.licenseValidationService.isUserLicenseValid()) {
            log.warn("License is not valid anymore.");
            this.licenseService.showLicenseNotValidDialog();
            return;
        }
        PrinterJob job = PrinterJob.createPrinterJob();
        log.debug("Created printer job.");
        if (job != null) {
            if (job.showPrintDialog((Window)this.gUIStateService.getMainStage())) {
                this.printTextArea(() -> {
                    job.getJobSettings().setJobName("easytranscript - " + String.valueOf(this.transcriptService.getCurrentTranscript().getTranscriptLocation().getFileName()));
                    job.printPage((Node)this.transcriptTextArea);
                    job.endJob();
                    log.debug("Printed transcript.");
                });
            }
        } else {
            this.dialogService.get(this.getMessageService().getLocaleBundle().getString("problems.cannotPrint")).showAndWait();
        }
        this.transcriptTextArea.requestFocus();
    }

    public void openSettings() {
        this.showAdditionalScreen(ProgramSettingsController.class, Modality.WINDOW_MODAL);
    }

    public void closeProgram() {
        this.miscService.closeProgram();
    }

    public void toggleWidthRestriction() {
        if (!this.transcriptTextArea.isVisible()) {
            return;
        }
        if (this.configurationService.getConfiguration().getWidthOfTextAreaInCm() == -1.0) {
            this.configurationService.getConfiguration().setWidthOfTextAreaInCm(22.0);
        } else {
            this.configurationService.getConfiguration().setWidthOfTextAreaInCm(-1.0);
        }
    }

    public void toggleParagraphsNumbering() {
        if (!this.transcriptTextArea.isVisible()) {
            return;
        }
        this.configurationService.getConfiguration().setShowParagraphNumbers(!this.configurationService.getConfiguration().getShowParagraphNumbers());
        this.configurationService.save();
    }

    public void showMailForSupport() {
        try {
            if (!Desktop.isDesktopSupported()) {
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.MAIL)) {
                URI mailto = new URI("mailto:support@easytranscript.de?subject=Feedback");
                desktop.mail(mailto);
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Could not send feedback", (Throwable)e);
        }
    }

    public void showSendErrorReport() {
        this.exceptionAlert.showModal(true);
    }

    public void showAbout() {
        this.transcriptTextArea.requestFocus();
        this.showAdditionalScreen(AboutController.class, Modality.WINDOW_MODAL);
    }

    public void checkForUpdates() {
        this.updaterService.startUpdateCheck(true);
    }

    public void registerEasytranscript() {
        this.transcriptTextArea.requestFocus();
        ExtendedController extendedController = this.gUIStateService.getController().showAdditionalScreen(LicenseController.class, Modality.WINDOW_MODAL, false);
        extendedController.getStage().hide();
        extendedController.getStage().show();
    }

    private void fillRecentLoadedMenu() {
        log.debug("Going to fill recent loaded menu...");
        this.recentlyOpenedMenu.getItems().clear();
        ObservableList recent = this.configurationService.getConfiguration().getProgramRecentLoadedObservableList();
        int i = 0;
        while (i < recent.size()) {
            MenuItem item = new MenuItem();
            String filename = Path.of((String)recent.get(i), new String[0]).getFileName().toString();
            if (filename.contains(".")) {
                filename = filename.substring(0, filename.lastIndexOf("."));
            }
            item.setText(filename);
            int finalI = i++;
            item.setOnAction(event -> this.closeDialog.showAndWait(() -> {
                if (new File((String)recent.get(finalI)).exists()) {
                    this.loadTranscriptService.openTranscript(Path.of((String)recent.get(finalI), new String[0]));
                } else {
                    this.dialogService.get(this.getMessageService().getLocaleBundle().getString("problems.transcriptFileNotFound")).showAndWait();
                    recent.remove(recent.get(finalI));
                    this.configurationService.save();
                }
            }));
            this.recentlyOpenedMenu.getItems().add((Object)item);
        }
    }

    public void zoomOut() {
        if (this.transcriptTextArea.isVisible()) {
            this.zoomService.zoom(false);
            this.transcriptTextArea.requestFocus();
        }
    }

    public void zoomIn() {
        if (this.transcriptTextArea.isVisible()) {
            this.zoomService.zoom(true);
            this.transcriptTextArea.requestFocus();
        }
    }

    public void undo() {
        this.menuBarService.undo();
    }

    public void redo() {
        this.menuBarService.redo();
    }

    public void cut() {
        this.menuBarService.cut();
    }

    public void copy() {
        this.menuBarService.copy();
    }

    public void paste() {
        this.menuBarService.paste();
    }

    public void openSearch() {
        this.menuBarService.showSearch();
    }

    @Generated
    public MenuBarController(LicenseService licenseService, ExportService exportService, SaveTranscriptService saveTranscriptService, MiscService miscService, CloseDialog closeDialog, UpdaterService updaterService, StatusService statusService, MenuBarService menuBarService, LoadTranscriptService loadTranscriptService, STTStatusService sttStatusService, TranscriptTextArea transcriptTextArea, ZoomService zoomService, ConfigurationService configurationService, LicenseValidationService licenseValidationService, TranscriptCreationUIHelperService transcriptCreationUIHelperService, DocumentSerializer documentSerializer, TranscriptService transcriptService, DialogService dialogService, GuiStateService gUIStateService) {
        this.licenseService = licenseService;
        this.exportService = exportService;
        this.saveTranscriptService = saveTranscriptService;
        this.miscService = miscService;
        this.closeDialog = closeDialog;
        this.updaterService = updaterService;
        this.statusService = statusService;
        this.menuBarService = menuBarService;
        this.loadTranscriptService = loadTranscriptService;
        this.sttStatusService = sttStatusService;
        this.transcriptTextArea = transcriptTextArea;
        this.zoomService = zoomService;
        this.configurationService = configurationService;
        this.licenseValidationService = licenseValidationService;
        this.transcriptCreationUIHelperService = transcriptCreationUIHelperService;
        this.documentSerializer = documentSerializer;
        this.transcriptService = transcriptService;
        this.dialogService = dialogService;
        this.gUIStateService = gUIStateService;
    }

    @Generated
    public MenuItem getNewMenuItem() {
        return this.newMenuItem;
    }

    @Generated
    public Menu getFileMenu() {
        return this.fileMenu;
    }

    @Generated
    public MenuBar getMenuBar() {
        return this.menuBar;
    }
}

