/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.menubar.searchbar;

import com.jfoenix.controls.JFXTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.JFXTextFieldSkin;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.searchbar.SearchbarController;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.searchbar.SearchbarService;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.IndexedCheckModel;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionImpl;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="search.fxml")
@Component
@Lazy
public class SearchbarController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchbarController.class);
    private static final int SEARCH_ONLY_FULL_WORDS = 0;
    private static final int SEARCH_CASE_SENSITIVE = 1;
    private static final int SEARCH_REGEX = 2;
    private static final Duration SEARCH_DELAY = Duration.ofMillis(500L);
    private final ArrayList<SelectionImpl<ParStyle, AbstractSegment<?>, TextStyle>> newSelections = new ArrayList();
    private final ArrayList<SelectionImpl<ParStyle, AbstractSegment<?>, TextStyle>> oldSelections = new ArrayList();
    private final BooleanProperty searchResultsReady = new SimpleBooleanProperty(false);
    private final SearchbarService searchbarService;
    private final TranscriptTextArea transcriptTextArea;
    private final SimpleBooleanProperty clearingInProgress = new SimpleBooleanProperty(false);
    Subscription plainTextSubscription;
    private boolean focusAfterSucceed;
    private int buildSelectionsIndex = 0;
    private Timer buildSelectionsTimer;
    private Timer clearSelectionsTimer;
    private SearchService searchService = new SearchService(this);
    @FXML
    private Text currentSearchWord;
    @FXML
    private JFXTextField searchTextField;
    @FXML
    private JFXTextField replaceTextField;
    @FXML
    private HBox inputsHBox;
    @FXML
    private CheckComboBox<String> checkComboBox;

    void selectRange(TranscriptTextArea textArea, int start, int end) {
        textArea.selectRange(start, end);
        this.scrollSelectedIntoView(textArea);
    }

    private void scrollSelectedIntoView(TranscriptTextArea textArea) {
        Platform.runLater(() -> ((TranscriptTextArea)textArea).requestFollowCaret());
    }

    void replaceText(TranscriptTextArea textArea, IndexRange range, String replacementText) {
        this.transcriptTextArea.runInPreventUndoMerge(() -> textArea.replaceText(range, replacementText));
        this.scrollSelectedIntoView(textArea);
    }

    public void reset() {
    }

    public void initializeController() {
        this.getThemeService().setStyleSheets(this.getStage().getScene());
        this.searchbarService.getSearchBarOpenedProperty().addListener((observable, old, t1) -> {
            this.root.setVisible(t1.booleanValue());
            this.root.setManaged(t1.booleanValue());
            if (!old.booleanValue() && t1.booleanValue()) {
                this.searchTextField.requestFocus();
                this.findAll();
                this.plainTextSubscription = this.transcriptTextArea.plainTextChanges().successionEnds(SEARCH_DELAY).subscribe(change -> this.findAll(false));
            }
        });
        this.searchTextField = new JFXTextField();
        this.searchTextField.setSkin((Skin)new JFXTextFieldSkin((TextField)this.searchTextField));
        this.searchTextField.setPromptText(this.getMessageService().getLocaleBundle().getString("mainScreen.search"));
        this.searchTextField.setMinWidth(0.0);
        this.searchTextField.setPrefWidth(50.0);
        EventStreams.changesOf((ObservableValue)this.searchTextField.textProperty()).successionEnds(SEARCH_DELAY).subscribe(change -> this.findAll());
        this.searchTextField.setOnAction(event -> this.findNext(false));
        this.replaceTextField = new JFXTextField();
        this.replaceTextField.setPromptText(this.getMessageService().getLocaleBundle().getString("mainScreen.replace"));
        this.replaceTextField.setSkin((Skin)new JFXTextFieldSkin((TextField)this.replaceTextField));
        this.replaceTextField.setMinWidth(0.0);
        this.replaceTextField.setPrefWidth(50.0);
        this.replaceTextField.setOnAction(event -> this.replace());
        HBox.setHgrow((Node)this.searchTextField, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.replaceTextField, (Priority)Priority.ALWAYS);
        this.inputsHBox.getChildren().addAll((Object[])new Node[]{this.searchTextField, this.replaceTextField});
        this.initializeOptionsCheckComboBox();
        this.initializeSearchService();
        this.buildSelectionsTimer = FxTimer.createPeriodic((Duration)Duration.ofMillis(1L), () -> {
            if (this.newSelections.isEmpty()) {
                this.buildSelectionsTimer.stop();
                this.buildSelectionsIndex = 0;
                return;
            }
            this.transcriptTextArea.addSelection((Selection)this.newSelections.get(this.buildSelectionsIndex));
            ++this.buildSelectionsIndex;
            if (this.buildSelectionsIndex >= this.newSelections.size()) {
                this.buildSelectionsTimer.stop();
                this.buildSelectionsIndex = 0;
                log.debug("Finished creating selections.");
            }
        });
        this.clearSelectionsTimer = FxTimer.createPeriodic((Duration)Duration.ofMillis(3L), () -> {
            if (this.oldSelections.isEmpty()) {
                log.debug("Selections are empty.");
                this.clearSelectionsTimer.stop();
                this.clearingInProgress.set(false);
                log.debug("Finished clearing selections.");
                return;
            }
            SelectionImpl s = (SelectionImpl)this.oldSelections.getFirst();
            s.deselect();
            this.transcriptTextArea.removeSelection((Selection)s);
            s.dispose();
            this.oldSelections.remove(s);
        });
    }

    private void initializeOptionsCheckComboBox() {
        ObservableList strings = FXCollections.observableArrayList();
        strings.add(0, (Object)this.getMessageService().getLocaleBundle().getString("mainScreen.onlyFullWords"));
        strings.add(1, (Object)this.getMessageService().getLocaleBundle().getString("mainScreen.caseSensitive"));
        strings.add(2, (Object)this.getMessageService().getLocaleBundle().getString("mainScreen.regex"));
        this.checkComboBox.getItems().addAll((Collection)strings);
        this.checkComboBox.setTitle(this.getMessageService().getLocaleBundle().getString("mainScreen.searchOptions"));
        this.checkComboBox.getStyleClass().add((Object)"combo-box-empty");
        IndexedCheckModel checkModel = this.checkComboBox.getCheckModel();
        EventStreams.changesOf((ObservableValue)this.checkComboBox.getItemBooleanProperty(2)).subscribe(change -> this.checkComboBox.getCheckModel().clearCheck(0));
        EventStreams.changesOf((ObservableValue)this.checkComboBox.getItemBooleanProperty(0)).subscribe(change -> this.checkComboBox.getCheckModel().clearCheck(2));
        checkModel.getCheckedIndices().addListener(change -> {
            int size = checkModel.getCheckedItems().size();
            if (size == 0) {
                this.checkComboBox.getStyleClass().add((Object)"combo-box-empty");
                this.checkComboBox.setTitle(this.getMessageService().getLocaleBundle().getString("mainScreen.searchOptions"));
                return;
            }
            this.checkComboBox.getStyleClass().remove((Object)"combo-box-empty");
            this.checkComboBox.setTitle(String.format("(%d) %s", size, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)checkModel.getCheckedItems())));
            this.findAll();
            this.selectActiveHit();
        });
    }

    private void initializeSearchService() {
        this.searchService.setOnRunning(workerStateEvent -> this.searchResultsReady.set(false));
        this.searchService.setOnSucceeded(workerStateEvent -> {
            this.searchResultsReady.set(true);
            if (this.focusAfterSucceed) {
                this.selectActiveHit();
                this.focusAfterSucceed = false;
            }
        });
        this.searchService.setOnFailed(workerStateEvent -> this.searchResultsReady.set(true));
    }

    public void close() {
        log.debug("Closing search bar ...");
        this.clearHits();
        this.clearHighlights();
        this.plainTextSubscription.unsubscribe();
        this.searchbarService.close();
    }

    public void findAll() {
        this.findAll(true);
    }

    public void findAll(boolean focusAfterSucceed) {
        if (this.searchService == null) {
            this.searchService = new SearchService(this);
        }
        this.searchService.restart();
        this.focusAfterSucceed = focusAfterSucceed;
    }

    public void clearHighlights() {
        log.debug("Clearing highlights...");
        this.clearingInProgress.set(true);
        this.oldSelections.addAll(this.newSelections);
        Platform.runLater(() -> this.clearSelectionsTimer.restart());
    }

    private void clearHits() {
        this.searchbarService.getHits().clear();
        this.setActiveHitIndex(-1, false);
    }

    public void findPrevious() {
        if (this.searchbarService.getHits().isEmpty()) {
            return;
        }
        int previous = this.searchbarService.getActiveHitIndex() - 1;
        if (previous < 0) {
            previous = this.searchbarService.getHits().size() - 1;
        }
        this.setActiveHitIndex(previous, true);
    }

    public void findNext(boolean previousWasReplaced) {
        if (this.searchbarService.getHits().isEmpty()) {
            return;
        }
        int next = this.searchbarService.getActiveHitIndex() + (previousWasReplaced ? 0 : 1);
        if (next >= this.searchbarService.getHits().size()) {
            next = 0;
        }
        this.setActiveHitIndex(next, true);
    }

    public void findNext() {
        this.findNext(false);
    }

    private void setActiveHitIndex(int index, boolean selectActiveHit) {
        int oldActiveHitIndex = this.searchbarService.getActiveHitIndex();
        this.searchbarService.setActiveHitIndex(index);
        this.updateCurrentSearchWord();
        if (selectActiveHit) {
            this.selectActiveHit();
        }
        if (oldActiveHitIndex < 0 && this.searchbarService.getActiveHitIndex() < 0) {
            return;
        }
        this.searchbarService.fireHitsChanged();
    }

    private void selectActiveHit() {
        if (this.searchbarService.getActiveHitIndex() < 0) {
            int caretPosition = this.transcriptTextArea.getCaretPosition();
            this.transcriptTextArea.selectRange(caretPosition, caretPosition);
            return;
        }
        JFXTextField focused = this.replaceTextField.isFocused() ? this.replaceTextField : this.searchTextField;
        IndexRange activeHit = this.getActiveHit();
        this.selectRange(this.transcriptTextArea, activeHit.getStart(), activeHit.getEnd());
        focused.requestFocus();
    }

    public void replace() {
        IndexRange activeHit = this.getActiveHit();
        if (activeHit == null || !this.searchResultsReady.getValue().booleanValue()) {
            if (activeHit == null) {
                log.debug("Active hit is null. Cannot replace.");
            }
            if (!this.searchResultsReady.getValue().booleanValue()) {
                log.debug("Search result is not ready. Cannot replace.");
            }
            return;
        }
        String replace = this.replaceTextField.getText();
        Pattern regexReplacePattern = this.regexReplacePattern();
        if (regexReplacePattern != null && (replace = this.regexReplace(regexReplacePattern, activeHit, replace)) == null) {
            return;
        }
        this.replaceText(this.transcriptTextArea, activeHit, replace);
        FxTimer.runLater((Duration)SEARCH_DELAY.plusMillis(10L), () -> {
            this.findNext(true);
            this.selectActiveHit();
        });
    }

    public void replaceAll() {
        if (this.searchbarService.getHits().isEmpty() || !this.searchResultsReady.getValue().booleanValue()) {
            return;
        }
        String replace = this.replaceTextField.getText();
        Pattern regexReplacePattern = this.regexReplacePattern();
        MultiChangeBuilder multiChange = this.transcriptTextArea.createMultiChange(this.searchbarService.getHits().size());
        for (IndexRange hit : this.searchbarService.getHits()) {
            String replace2 = replace;
            if (regexReplacePattern != null && (replace2 = this.regexReplace(regexReplacePattern, hit, replace)) == null) {
                return;
            }
            multiChange.replaceText(hit.getStart(), hit.getEnd(), replace2);
        }
        this.transcriptTextArea.commitMultiChange(multiChange);
        this.transcriptTextArea.requestFocus();
    }

    IndexRange getActiveHit() {
        return this.searchbarService.getActiveHitIndex() >= 0 ? (IndexRange)this.searchbarService.getHits().get(this.searchbarService.getActiveHitIndex()) : null;
    }

    private Pattern regexReplacePattern() {
        if (!this.checkComboBox.getCheckModel().isChecked(2)) {
            return null;
        }
        String replace = this.replaceTextField.getText();
        if (replace.indexOf(36) < 0 && replace.indexOf(92) < 0) {
            return null;
        }
        String find = this.searchTextField.getText();
        Object pattern = this.checkComboBox.getCheckModel().isChecked(1) ? find : "(?i)" + find;
        try {
            return Pattern.compile((String)pattern);
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
    }

    private String regexReplace(Pattern regexReplacePattern, IndexRange indexRange, String replace) {
        try {
            String text = this.transcriptTextArea.getText(indexRange.getStart(), indexRange.getEnd());
            return regexReplacePattern.matcher(text).replaceFirst(replace);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }

    private void updateCurrentSearchWord() {
        if (this.searchTextField.getText().isEmpty()) {
            this.currentSearchWord.setText("");
        } else {
            this.currentSearchWord.setText(MessageFormat.format("{0} / {1}", this.searchbarService.getActiveHitIndex() + 1, this.searchbarService.getHits().size()));
        }
    }

    @Generated
    public SearchbarController(SearchbarService searchbarService, TranscriptTextArea transcriptTextArea) {
        this.searchbarService = searchbarService;
        this.transcriptTextArea = transcriptTextArea;
    }
}

