/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.player;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.player.Player;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import eu.ewerkzeug.easytranscript3.mvc.player.fx.FXPlayer;
import eu.ewerkzeug.easytranscript3.mvc.player.vlcj.VLCJPlayer;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.media.MediaException;
import lombok.Generated;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlayerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerService.class);
    private final StatusService statusService;
    private final TranscriptTextArea transcriptTextArea;
    private final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss-SS").withZone(ZoneId.of("GMT"));
    private final ConfigurationService configurationService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final TranscriptService transcriptService;
    private final ExceptionAlert exceptionAlert;
    private boolean addedMediaNeedsReloadListener = false;
    private Subscription mediaNeedsReloadSubscription;

    public void playPause() {
        PlayerState state = (PlayerState)Main.getPlayer().stateProperty().getValue();
        log.debug("Player state: {}", (Object)state.toString());
        if (state.equals((Object)PlayerState.PAUSED) && this.configurationService.getConfiguration().isAutoRewindAfterPause()) {
            this.changeTime(false);
        }
        if (state.equals((Object)PlayerState.LOADED) || state.equals((Object)PlayerState.PAUSED) || state.equals((Object)PlayerState.STOPPED)) {
            Main.getPlayer().play();
            log.debug("Playing.");
            log.debug("Speed: {}", (Object)Main.getPlayer().rateProperty().get());
            log.debug("Volume: {}", (Object)Main.getPlayer().volumeProperty().get());
            if (this.configurationService.getConfiguration().isUseSavedLastPlayerTime() && !this.transcriptService.getCurrentTranscript().isAlreadyJumpedToLastPlayerTime() && this.transcriptService.getCurrentTranscript().getLastPlayerTime() >= 0L) {
                log.debug("Jumping to last player time {}.", (Object)this.transcriptService.getCurrentTranscript().getLastPlayerTime());
                FxTimer.runLater((Duration)Duration.ofMillis(200L), () -> {
                    Main.getPlayer().setTime(this.transcriptService.getCurrentTranscript().getLastPlayerTime());
                    this.transcriptService.getCurrentTranscript().setAlreadyJumpedToLastPlayerTime(true);
                });
            }
            this.transcriptTextArea.requestFocus();
        } else if (state.equals((Object)PlayerState.PLAYING)) {
            Main.getPlayer().pause();
            this.transcriptTextArea.requestFocus();
        }
    }

    public void changeTime(boolean forward) {
        PlayerState state = (PlayerState)Main.getPlayer().stateProperty().getValue();
        if (!state.equals((Object)PlayerState.PAUSED) && !state.equals((Object)PlayerState.PLAYING)) {
            return;
        }
        if (!forward) {
            Main.getPlayer().rewind((long)this.configurationService.getConfiguration().getWindingInterval());
        } else {
            Main.getPlayer().fastForward((long)this.configurationService.getConfiguration().getWindingInterval());
        }
        Player player = Main.getPlayer();
        if (player instanceof VLCJPlayer) {
            VLCJPlayer vlcjPlayer = (VLCJPlayer)player;
            if (state.equals((Object)PlayerState.PAUSED)) {
                vlcjPlayer.getTimeProperty().setValue((Number)(vlcjPlayer.getTimeProperty().getValue() + (long)this.configurationService.getConfiguration().getWindingInterval() * 1000L * (long)(forward ? 1 : -1)));
            }
        }
        this.transcriptTextArea.requestFocus();
        log.debug("Changed playback time to position {} with interval {}", (Object)Main.getPlayer().getTime(), (Object)this.configurationService.getConfiguration().getWindingInterval());
    }

    public void loadMedia() {
        log.debug("Loading media ...");
        log.debug("Current player state: {}", Main.getPlayer().stateProperty().get());
        Main.getPlayer().stateProperty().set((Object)PlayerState.INITIALIZED);
        try {
            Path media = this.transcriptService.getCurrentTranscript().getMediaLocation();
            if (media == null || media.toFile().isDirectory()) {
                log.warn("Media is invalid: null or a directory.");
                return;
            }
            if (media.getParent() == null) {
                media = this.transcriptService.getTemporaryTranscriptLocation(this.transcriptService.getCurrentTranscript().getUnzipUuid()).resolve(media);
            }
            Main.getPlayer().loadMedia(media);
        }
        catch (FileNotFoundException ex) {
            log.error("Media file not found.", (Throwable)ex);
            this.exceptionAlert.showModal();
        }
        catch (MediaException ex) {
            Platform.runLater(() -> this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.FXnotSupported")).showAndWait());
            log.warn("Media format not supported: {}", (Object)this.transcriptService.getCurrentTranscript().getMediaLocation(), (Object)ex);
        }
    }

    public void createPlayer() {
        log.debug("Creating player ...");
        boolean changeOfPlayer = Main.getPlayer() instanceof VLCJPlayer && !this.configurationService.getConfiguration().isUseVLCPlayer() || Main.getPlayer() instanceof FXPlayer && this.configurationService.getConfiguration().isUseVLCPlayer();
        log.debug("Player should be changed: {}", (Object)changeOfPlayer);
        if (Main.getPlayer() != null && changeOfPlayer) {
            Main.getPlayer().release();
            this.addedMediaNeedsReloadListener = false;
        }
        if (Main.getPlayer() == null || changeOfPlayer) {
            if (this.configurationService.getConfiguration().isUseVLCPlayer()) {
                this.createVLCPlayerOrFallbackToFX();
            } else {
                Main.setPlayer((Player)new FXPlayer(this.messageService, this.dialogService));
            }
        } else {
            log.debug("Player already created.");
        }
        this.addMediaNeedsReloadListener();
        log.info("Player is ready.");
    }

    private void createVLCPlayerOrFallbackToFX() {
        try {
            Main.setPlayer((Player)new VLCJPlayer(this.messageService, this.configurationService, this.dialogService));
        }
        catch (NullPointerException e) {
            log.error("VLC Installation was not found. Falling back to FXPlayer.", (Throwable)e);
            Main.setPlayer((Player)new FXPlayer(this.messageService, this.dialogService));
            this.configurationService.getConfiguration().setUseVLCPlayer(false);
        }
    }

    private void addMediaNeedsReloadListener() {
        if (this.addedMediaNeedsReloadListener) {
            return;
        }
        this.statusService.mediaNeedsReloadProperty().addListener((observable, oldBoolean, newBoolean) -> {
            log.debug("Media needs reload set to {}", newBoolean);
            if (this.statusService.isMediaNeedsReload()) {
                this.mediaNeedsReloadSubscription = EventStreams.changesOf((ObservableValue)Main.getPlayer().stateProperty()).subscribe(change -> {
                    if (change.getNewValue() == PlayerState.LOADED) {
                        this.statusService.setMediaNeedsReload(false);
                        this.mediaNeedsReloadSubscription.unsubscribe();
                    }
                });
                this.loadMedia();
            }
        });
        this.addedMediaNeedsReloadListener = true;
    }

    @Generated
    public PlayerService(StatusService statusService, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, MessageService messageService, DialogService dialogService, TranscriptService transcriptService, ExceptionAlert exceptionAlert) {
        this.statusService = statusService;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.transcriptService = transcriptService;
        this.exceptionAlert = exceptionAlert;
    }

    @Generated
    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }
}

