/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.player.fx;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.io.ETFileNotFoundException;
import eu.ewerkzeug.easytranscript3.mvc.player.Player;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import eu.ewerkzeug.easytranscript3.mvc.player.fx.FXPlayer;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.media.AudioTrack;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.media.VideoTrack;
import javafx.stage.FileChooser;
import javafx.util.Duration;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXPlayer
implements Player {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FXPlayer.class);
    private static final ArrayList<FileChooser.ExtensionFilter> supportedFormats = new ArrayList();
    private static final SimpleBooleanProperty interfaceListensToStatusChangesProperty = new SimpleBooleanProperty();
    private final MessageService messageService;
    private final DialogService dialogService;
    private final StackPane mediaPlayerHolder = new StackPane();
    private final IntegerProperty maximumVolume = new SimpleIntegerProperty(100);
    private final ObjectProperty<Path> mediaPath = new SimpleObjectProperty();
    private final ObjectProperty<PlayerState> state = new SimpleObjectProperty((Object)PlayerState.NOT_INITIALIZED);
    private final LongProperty durationProperty = new SimpleLongProperty(0L);
    private MediaPlayer mediaPlayer;
    private MediaView mediaView;
    private Media media;
    private double tmpRate = 1.0;

    public FXPlayer(MessageService messageService, DialogService dialogService) {
        log.debug("Initializing FXPlayer...");
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.initSupportedFormats();
        this.mediaPlayerHolder.setStyle("-fx-background-color: transparent");
        this.state.addListener((observable, oldValue, newValue) -> log.debug("Changed to state {}", newValue));
        this.mediaPlayerHolder.widthProperty().addListener((observable, oldValue, newValue) -> this.mediaView.setFitWidth(newValue.doubleValue()));
        this.mediaPlayerHolder.heightProperty().addListener((observable, oldValue, newValue) -> this.mediaView.setFitHeight(newValue.doubleValue()));
    }

    public static List<FileChooser.ExtensionFilter> getSupportedFormats() {
        return supportedFormats;
    }

    public void initSupportedFormats() {
        FileChooser.ExtensionFilter audioFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("createTranscriptScreen.filePickerAudioFiles"), new String[]{"*.mp3", "*.aiff", "*.aif", "*.wav", "*.aac", "*.3gp", "*.mp4", "*.m4a", "*.mpg", "*.mpeg"});
        FileChooser.ExtensionFilter videoFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("createTranscriptScreen.filePickerVideoFiles"), new String[]{"*.flv", "*.f4v", "*.mp4", "*.m4v"});
        FileChooser.ExtensionFilter mediaFilter = new FileChooser.ExtensionFilter(this.messageService.getLocaleBundle().getString("createTranscriptScreen.filePickerMediaFiles"), (String[])Stream.of(audioFilter.getExtensions(), videoFilter.getExtensions()).flatMap(Collection::stream).toArray(String[]::new));
        supportedFormats.add(mediaFilter);
        supportedFormats.add(audioFilter);
        supportedFormats.add(videoFilter);
    }

    public Pane getPlayerPane() {
        return this.mediaPlayerHolder;
    }

    public void loadMedia(Path path) throws FileNotFoundException, MediaException {
        log.debug("Loading media: {}", (Object)path);
        if (!path.toFile().exists()) {
            throw new ETFileNotFoundException(this.messageService.getLocaleBundle().getString("problems.mediaFileNotFound"), "Media file does not exist");
        }
        if (this.media != null) {
            this.release();
        }
        log.debug("Creating new media player.");
        this.mediaPath.setValue((Object)path);
        this.media = new Media(path.toUri().toString());
        this.mediaPlayer = new MediaPlayer(this.media);
        log.debug("Adding state listeners.");
        this.mediaPlayer.statusProperty().addListener((observableValue, status, status2) -> this.setETPlayerStatus(status2));
        this.mediaPlayer.setOnError(() -> {
            log.error("There was a media Player error.", (Throwable)this.mediaPlayer.getError());
            this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.FXnotSupported")).showAndWait();
        });
        this.media.setOnError(() -> {
            log.error("There was a media error.", (Throwable)this.media.getError());
            this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.FXnotSupported")).showAndWait();
        });
        this.mediaPlayerHolder.getChildren().remove((Object)this.mediaView);
        this.mediaView = new MediaView(this.mediaPlayer);
        this.mediaPlayerHolder.getChildren().add((Object)this.mediaView);
        StackPane.setAlignment((Node)this.mediaView, (Pos)Pos.CENTER);
        this.mediaView.setFitWidth(this.mediaPlayerHolder.getWidth());
        this.setETPlayerStatus(this.mediaPlayer.getStatus());
        log.info("Media loaded.");
    }

    private void setETPlayerStatus(MediaPlayer.Status status) {
        if (status == null) {
            this.state.setValue((Object)PlayerState.NOT_INITIALIZED);
            return;
        }
        switch (1.$SwitchMap$javafx$scene$media$MediaPlayer$Status[status.ordinal()]) {
            case 1: {
                this.safelySetPlayerState(PlayerState.STOPPED);
                break;
            }
            case 2: {
                this.safelySetPlayerState(PlayerState.PAUSED);
                break;
            }
            case 3: {
                this.safelySetPlayerState(PlayerState.PLAYING);
                break;
            }
            case 4: {
                this.safelySetPlayerState(PlayerState.LOADED);
                this.durationProperty.setValue((Number)((long)this.mediaPlayer.getTotalDuration().toMillis()));
                this.testMedia();
                break;
            }
            case 5: {
                this.release();
                Main.setPlayer((Player)new FXPlayer(this.messageService, this.dialogService));
                this.safelySetPlayerState(PlayerState.ERROR);
                break;
            }
            case 6: {
                this.safelySetPlayerState(PlayerState.INITIALIZED);
                break;
            }
            case 7: {
                this.safelySetPlayerState(PlayerState.RELEASED);
                break;
            }
            default: {
                this.safelySetPlayerState(PlayerState.NOT_INITIALIZED);
            }
        }
    }

    private void testMedia() {
        if (this.media.getDuration().isIndefinite() || this.media.getDuration().equals((Object)Duration.ZERO) || this.media.getDuration().isUnknown()) {
            Platform.runLater(() -> {
                log.error("Media seems to have odd properties.");
                log.error("Duration: {}", (Object)this.media.getDuration());
                this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.FXnotSupported")).showAndWait();
            });
        } else {
            log.info("Media seems to be playable and fully supported.");
        }
    }

    private void safelySetPlayerState(PlayerState playerState) {
        if (this.state.get() == PlayerState.NOT_INITIALIZED && (playerState == PlayerState.STOPPED || playerState == PlayerState.PLAYING || playerState == PlayerState.PAUSED)) {
            log.debug("Cannot go from {} to {}", (Object)PlayerState.NOT_INITIALIZED, (Object)playerState);
        } else {
            this.state.set((Object)playerState);
        }
    }

    public boolean isVideo() {
        if (Main.getPlayer() == null) {
            log.warn("Could not check if media is video, because the player is null");
            return false;
        }
        return this.mediaPlayer.getMedia().getHeight() > 0;
    }

    public Dimension getVideoDimension() {
        if (this.isVideo()) {
            return new Dimension(this.media.getWidth(), this.media.getHeight());
        }
        return null;
    }

    public void play() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.play();
            if (SystemUtils.IS_OS_MAC && Main.getPlayer() instanceof FXPlayer) {
                log.debug("System is Mac OS and player is FXPlayer. Setting rate...");
                if (this.tmpRate > 0.0) {
                    Main.getPlayer().rateProperty().set(this.tmpRate);
                    this.tmpRate = -1.0;
                }
                log.debug("Rate: {}", (Object)Main.getPlayer().rateProperty().get());
                log.debug("Rate: {}", (Object)this.mediaPlayer.getRate());
                this.mediaPlayer.setRate(Main.getPlayer().rateProperty().get() - 0.1);
                this.mediaPlayer.setRate(Main.getPlayer().rateProperty().get() + 0.1);
            }
        }
    }

    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.stop();
            }
            catch (NullPointerException e) {
                log.warn("Could not stop media player.", (Throwable)e);
            }
        }
    }

    public void release() {
        this.stop();
        if (this.mediaPlayer != null) {
            this.mediaPlayer.dispose();
        }
        this.state.set((Object)PlayerState.RELEASED);
        interfaceListensToStatusChangesProperty.set(false);
    }

    public void rewind(long s) {
        this.fastForward(-s);
    }

    public void fastForward(long s) {
        this.mediaPlayer.seek(((Duration)this.mediaPlayer.currentTimeProperty().get()).add(Duration.seconds((double)s)));
    }

    public long getTime() {
        Duration currentTime = this.mediaPlayer.getCurrentTime();
        return (long)currentTime.toMillis();
    }

    public void setTime(long ms) {
        this.mediaPlayer.seek(Duration.millis((double)ms));
    }

    public long getDuration() {
        return this.durationProperty.get();
    }

    public LongProperty durationProperty() {
        return this.durationProperty;
    }

    public long getDurationOf(Path path) {
        CountDownLatch latch = new CountDownLatch(1);
        long[] mediaLength = new long[]{0L};
        Media tmpMedia = new Media(path.toUri().toString());
        MediaPlayer tmpMediaPlayer = new MediaPlayer(tmpMedia);
        tmpMediaPlayer.setOnReady(() -> {
            Duration duration = tmpMediaPlayer.getTotalDuration();
            mediaLength[0] = (long)duration.toMillis();
            latch.countDown();
        });
        tmpMedia.setOnError(latch::countDown);
        tmpMediaPlayer.setOnHalted(latch::countDown);
        tmpMediaPlayer.setOnError(latch::countDown);
        tmpMediaPlayer.play();
        boolean wasCountDown = latch.await(4L, TimeUnit.SECONDS);
        if (!wasCountDown || mediaLength[0] <= 0L) {
            log.error("Could not determine length in time");
        }
        tmpMediaPlayer.stop();
        tmpMediaPlayer.dispose();
        return mediaLength[0];
    }

    public void setVolume(double value) {
        this.mediaPlayer.setVolume(value);
    }

    public void setRate(double value) {
        boolean paused = this.mediaPlayer.getStatus().equals((Object)MediaPlayer.Status.PAUSED);
        if (!paused) {
            this.mediaPlayer.setRate(value);
            this.tmpRate = -1.0;
        } else {
            this.tmpRate = value;
        }
    }

    public void logMediaDebugInformation() {
        log.debug("Media debug information");
        log.debug("-----------------------");
        if (this.media == null) {
            log.debug("Media not loaded, no information available. Is the media path still correct?");
            return;
        }
        log.debug("Duration: {}", (Object)this.mediaPlayer.getTotalDuration());
        log.debug("Audio Tracks count: {}", (Object)this.mediaPlayer.getMedia().getTracks().stream().filter(AudioTrack.class::isInstance).count());
        log.debug("Video Tracks count: {}", (Object)this.mediaPlayer.getMedia().getTracks().stream().filter(VideoTrack.class::isInstance).count());
        log.debug("Video dimension: [{},{}]", (Object)this.mediaPlayer.getMedia().getWidth(), (Object)this.mediaPlayer.getMedia().getHeight());
    }

    public ObjectProperty<Path> mediaPathProperty() {
        return this.mediaPath;
    }

    public ObjectProperty<PlayerState> stateProperty() {
        return this.state;
    }

    public DoubleProperty volumeProperty() {
        return this.mediaPlayer.volumeProperty();
    }

    public DoubleProperty rateProperty() {
        return this.mediaPlayer.rateProperty();
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public boolean isMediaLoaded() {
        return this.mediaPlayer != null && this.mediaPlayer.getMedia() != null;
    }

    public boolean doesInterfaceListenToStatusChanges() {
        return interfaceListensToStatusChangesProperty.getValue();
    }

    public void setInterfaceListensToStatusChanges(boolean addedTimeListener) {
        interfaceListensToStatusChangesProperty.set(addedTimeListener);
    }

    public IntegerProperty maximumVolumeProperty() {
        return this.maximumVolume;
    }
}

