/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.mvc.player.fx.FXPlayer;
import eu.ewerkzeug.easytranscript3.mvc.player.vlcj.VLCJPlayer;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.io.File;
import java.util.Collection;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class TranscriptCreationUIHelperService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranscriptCreationUIHelperService.class);
    private final ConfigurationService configurationService;
    private final TranscriptService transcriptService;

    public String openMediaFile(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        fileChooser.getExtensionFilters().addAll((Collection)(this.configurationService.getConfiguration().isUseVLCPlayer() ? VLCJPlayer.getSupportedFormats() : FXPlayer.getSupportedFormats()));
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            Main.setRecentOpenedFileChooserPath((File)file.toPath().getParent().toFile());
            return file.toString();
        }
        return "";
    }

    public void updateGridPanesOfTranscriptPropertyScreen(String path, GridPane gridPane) {
        if (path.isEmpty()) {
            ((ColumnConstraints)gridPane.getColumnConstraints().getFirst()).setPercentWidth(0.0);
            gridPane.setHgap(0.0);
        } else {
            gridPane.setHgap(15.0);
            ((ColumnConstraints)gridPane.getColumnConstraints().getFirst()).setPercentWidth(70.0);
        }
    }

    public void setTranscriptLocation(Label transcriptLocationLabel, boolean useEttExtension) {
        File file;
        Stage stage = (Stage)transcriptLocationLabel.getScene().getWindow();
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        if (useEttExtension) {
            fileChooser.getExtensionFilters().add((Object)this.transcriptService.getEttFilter());
        }
        if ((file = fileChooser.showSaveDialog((Window)stage)) != null) {
            transcriptLocationLabel.setText(file.toString());
            Main.setRecentOpenedFileChooserPath((File)file.toPath().getParent().toFile());
        }
    }

    @Generated
    public TranscriptCreationUIHelperService(ConfigurationService configurationService, TranscriptService transcriptService) {
        this.configurationService = configurationService;
        this.transcriptService = transcriptService;
    }
}

