/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.validation.RequiredFieldValidator;
import com.jfoenix.validation.base.ValidatorBase;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.SttLanguageService;
import eu.ewerkzeug.easytranscript3.commons.TutorialService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textformattingcontrol.TextFormattingService;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.tutorials.CreateTranscriptTutorial;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.DocumentSerializer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.transcript.TranscriptCreationUIHelperService;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.JobCreationService;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SpeakerFileEntryController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SpeakerFileEntryFactory;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SttLanguage;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SumPersonDurationsTask;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.TranscriptionRuleSet;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTService;
import eu.ewerkzeug.easytranscript3.networking.license.LicenseInvalidException;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.AutomaticTranscriptService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextOps;
import org.jspecify.annotations.NonNull;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

@FxmlView(value="createTranscriptScreen.fxml")
@Component
@StageTitle(value="%createTranscriptScreen.Title")
@Lazy
public class CreateTranscriptController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateTranscriptController.class);
    private final SaveTranscriptService saveTranscriptService;
    private final TranscriptCreationUIHelperService transcriptCreationUIHelperService;
    private final STTService sttService;
    private final StatusService statusService;
    private final CloseDialog closeDialog;
    private final LoadTranscriptService loadTranscriptService;
    private final TutorialService tutorialService;
    private final ExecutorService executorService;
    private final JobCreationService jobCreationService;
    private final ToggleGroup transcriptCreationModeToggleGroup = new ToggleGroup();
    private final SimpleBooleanProperty allAutomaticMediaFilesValid = new SimpleBooleanProperty(false);
    private final List<Subscription> subscriptions = new ArrayList();
    private final LicenseService licenseService;
    private final SttLanguageService sttLanguageService;
    private final SimpleBooleanProperty showDetailsProperty = new SimpleBooleanProperty(false);
    private final SimpleLongProperty totalDurationProperty = new SimpleLongProperty(0L);
    private final SimpleLongProperty totalBalanceProperty = new SimpleLongProperty(-1L);
    private final TranscriptTextArea transcriptTextArea;
    private final ConfigurationService configurationService;
    private final SpeakerFileEntryFactory speakerFileEntryFactory;
    private final DocumentSerializer documentSerializer;
    private final TextFormattingService textFormattingService;
    private final TranscriptService transcriptService;
    private final AutomaticTranscriptService automaticTranscriptService;
    private final MessageService messageService;
    public Label automaticOptionStatusLabel;
    public Label vlcIntegrationManualLabel;
    public SpacedText mediaLocationSpacedText;
    public Text insufficientBalanceText;
    private Hyperlink buyCreditsLink;
    @FXML
    private Text totalDurationText;
    @FXML
    private Text totalBalanceText;
    @FXML
    private VBox dataPrivacyVBox;
    @FXML
    private VBox transcriptionRulesVBox;
    @FXML
    private VBox automaticMediaFilesVBox;
    @FXML
    private HBox buttonBarHBox;
    @FXML
    private VBox savingLocationVBox;
    @FXML
    private VBox typeOfTranscriptVBox;
    @FXML
    private Button cancelButton;
    @FXML
    private Button finishButton;
    @FXML
    private Button createTranscriptButton;
    @FXML
    private Button mediaFileButton;
    @FXML
    private GridPane mediaPathGridPane;
    @FXML
    private GridPane transcriptPathGridPane;
    @FXML
    private JFXRadioButton manualRadioButton;
    @FXML
    private JFXRadioButton automaticallyRadioButton;
    @FXML
    private VBox settingsManualVBox;
    @FXML
    private VBox settingsAutomaticVBox;
    @FXML
    private Button addAdditionalFileButton;
    @FXML
    private Button showDetailsButton;
    @FXML
    private Label transcriptPathLabel;
    @FXML
    private VBox scrollContentVBox;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private Label mediaPathLabel;
    @FXML
    private VBox addedFilesAutomaticVBox;
    @FXML
    private Button backButton;
    @FXML
    private VBox firstPageContentVBox;
    @FXML
    private JFXComboBox<String> languageComboBox;
    @FXML
    private VBox languageVBox;
    @FXML
    private JFXComboBox<TranscriptionRuleSet> transcriptRuleSelectionComboBox;
    @FXML
    private JFXCheckBox agreeToDataPrivacyCheckBox;

    public void initializeController() {
        log.debug("Initializing create transcript screen...");
        this.initializeScrollPane();
        this.initializeStageBindings();
        this.initializeLabelAndButtonTexts();
        this.initializeVlcIntegrationLabel();
        this.initializeRadioButtons();
        this.initializeAdditionalFileButton();
        this.initializeAutomaticSpeakerValidationOnRemoveListener();
        this.initializeDurationAndBalanceBinding();
        this.initializeRuleSelectionComboBox();
        this.initializeLanguageComboBox();
        this.initializeTypeOfTranscriptionVBox();
        this.initializeAutomaticTranscriptionRadioBinding();
        this.stage.setOnCloseRequest(arg_0 -> this.onClose(arg_0));
        this.stage.setOnShown(windowEvent -> this.showTutorial());
        this.showManualCreationFields();
    }

    private void initializeAutomaticSpeakerValidationOnRemoveListener() {
        this.getSubscriptions().add(EventStreams.changesOf((ObservableList)this.addedFilesAutomaticVBox.getChildren()).subscribe(change -> this.updateAllAutomaticMediaFilesValidBinding()));
        this.updateAllAutomaticMediaFilesValidBinding();
    }

    private void initializeDurationAndBalanceBinding() {
        if (this.licenseService.getUserLicense() == null) {
            log.debug("No user license found. Disabling duration and balance binding.");
            return;
        }
        this.getSubscriptions().add(EventStreams.changesOf((ObservableList)this.addedFilesAutomaticVBox.getChildren()).subscribe(change -> {
            AutomaticTranscriptCreationInfo automaticInfo = this.getAutomaticTranscriptCreationInfo();
            this.sumPersonDuration(automaticInfo, false).subscribe(l -> {
                this.totalDurationProperty.set(l.longValue());
                this.totalDurationText.setText(Duration.of(this.totalDurationProperty.get(), ChronoUnit.SECONDS).toMinutes() + " " + this.messageService.getLocaleBundle().getString("programSettings.minutes"));
            });
        }));
        try {
            this.licenseService.getBalanceInSeconds().subscribe(l -> {
                this.totalBalanceProperty.set(l.longValue());
                this.totalBalanceText.setText(Duration.of(this.totalBalanceProperty.get(), ChronoUnit.SECONDS).toMinutes() + " " + this.messageService.getLocaleBundle().getString("programSettings.minutes"));
            });
        }
        catch (NullPointerException e) {
            log.warn("No user license found. Disabling duration and balance binding.");
        }
        EventStreams.changesOf((ObservableValue)this.totalDurationProperty).subscribe(change -> {
            this.totalDurationText.getStyleClass().remove((Object)"error");
            this.insufficientBalanceText.setManaged(false);
            this.insufficientBalanceText.setVisible(false);
            if (this.buyCreditsLink != null) {
                this.buyCreditsLink.setManaged(false);
                this.buyCreditsLink.setVisible(false);
            }
            if (((Number)change.getNewValue()).longValue() > this.totalBalanceProperty.get() && this.totalBalanceProperty.get() != -1L) {
                this.totalBalanceText.getStyleClass().add((Object)"error");
                this.insufficientBalanceText.setManaged(true);
                this.insufficientBalanceText.setVisible(true);
                if (this.buyCreditsLink == null) {
                    this.createBuyCreditsLink();
                }
                if (this.buyCreditsLink != null) {
                    this.buyCreditsLink.setManaged(true);
                    this.buyCreditsLink.setVisible(true);
                }
            }
        });
    }

    private void createBuyCreditsLink() {
        this.buyCreditsLink = new Hyperlink(this.messageService.getLocaleBundle().getString("createTranscriptScreen.buyCredits"));
        this.buyCreditsLink.setOnAction(e -> this.openBuyCreditsUrl());
        Parent parent = this.insufficientBalanceText.getParent();
        if (parent instanceof Pane) {
            Pane parent2 = (Pane)parent;
            int index = parent2.getChildren().indexOf((Object)this.insufficientBalanceText);
            parent2.getChildren().add(index + 1, (Object)this.buyCreditsLink);
        }
    }

    private void openBuyCreditsUrl() {
        String lang = this.configurationService.getConfiguration().getProgramLanguage();
        String url = "https://easytranscript.de/pricing#automatic-transcription";
        if ("de".equalsIgnoreCase(lang)) {
            url = "https://easytranscript.de/preise#automatic-transcription";
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("Could not open buy credits url", (Throwable)e);
        }
    }

    private void initializeVlcIntegrationLabel() {
        this.vlcIntegrationManualLabel.managedProperty().bind((ObservableValue)this.configurationService.getConfiguration().useVLCPlayerProperty().not());
        this.vlcIntegrationManualLabel.visibleProperty().bind((ObservableValue)this.configurationService.getConfiguration().useVLCPlayerProperty().not());
    }

    private void initializeTypeOfTranscriptionVBox() {
        if (this.licenseService.getUserLicense() == null || !this.licenseService.getUserLicense().isSttEnabled()) {
            this.typeOfTranscriptVBox.setVisible(false);
            this.typeOfTranscriptVBox.setManaged(false);
            Insets margin = VBox.getMargin((Node)this.savingLocationVBox);
            VBox.setMargin((Node)this.savingLocationVBox, (Insets)new Insets(margin.getRight(), margin.getBottom(), margin.getLeft(), 0.0));
        }
    }

    private void initializeAdditionalFileButton() {
        this.addedFilesAutomaticVBox.getChildren().addListener(c -> {
            if (!this.addedFilesAutomaticVBox.getChildren().isEmpty()) {
                this.addAdditionalFileButton.setText(this.messageService.getLocaleBundle().getString("createTranscriptScreen.addAdditionalFiles"));
            } else {
                this.addAdditionalFileButton.setText(this.messageService.getLocaleBundle().getString("general.select"));
            }
            this.addAdditionalFileButton.setText(this.addAdditionalFileButton.getText() + " \u203a");
        });
        this.addAdditionalFileButton.managedProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.showDetailsProperty, (ObservableBooleanValue)Bindings.isEmpty((ObservableList)this.addedFilesAutomaticVBox.getChildren())));
        this.addAdditionalFileButton.visibleProperty().bind((ObservableValue)this.addAdditionalFileButton.managedProperty());
        this.showDetailsButton.managedProperty().bind((ObservableValue)this.addAdditionalFileButton.managedProperty().not());
        this.showDetailsButton.visibleProperty().bind((ObservableValue)this.addAdditionalFileButton.managedProperty().not());
    }

    private void initializeStageBindings() {
        this.stage.maxWidthProperty().bind((ObservableValue)((AnchorPane)this.root).maxWidthProperty());
    }

    private void initializeLabelAndButtonTexts() {
        this.mediaPathLabel.textProperty().addListener((observable, oldValue, newValue) -> this.transcriptCreationUIHelperService.updateGridPanesOfTranscriptPropertyScreen(newValue, this.mediaPathGridPane));
        this.transcriptPathLabel.textProperty().addListener((observable, oldValue, newValue) -> this.transcriptCreationUIHelperService.updateGridPanesOfTranscriptPropertyScreen(newValue, this.transcriptPathGridPane));
        this.mediaFileButton.setText(this.mediaFileButton.getText() + " \u203a");
        this.createTranscriptButton.setText(this.createTranscriptButton.getText() + " \u203a");
        this.addAdditionalFileButton.setText(this.addAdditionalFileButton.getText() + " \u203a");
        VBox.setMargin((Node)this.mediaLocationSpacedText, (Insets)new Insets(0.0, 0.0, this.configurationService.getConfiguration().isUseVLCPlayer() ? 28.0 : 14.0, 0.0));
    }

    private void initializeAutomaticTranscriptionRadioBinding() {
        Consumer<Boolean> setDisableOfAutomaticallyRadioButton = newValue -> Platform.runLater(() -> {
            if (!newValue.booleanValue()) {
                UserLicense userLicense = this.licenseService.getUserLicense();
                if (userLicense == null) {
                    log.warn("Disabling settings for automatic transcript generation as user license is null.");
                    this.automaticallyRadioButton.setDisable(true);
                    this.automaticOptionStatusLabel.setText(this.messageService.getLocaleBundle().getString("createTranscriptScreen.notLoggedIn"));
                } else {
                    this.automaticallyRadioButton.setDisable(false);
                }
            } else {
                this.automaticallyRadioButton.setDisable(true);
            }
        });
        this.automaticOptionStatusLabel.managedProperty().bind((ObservableValue)this.automaticallyRadioButton.disableProperty());
        this.automaticOptionStatusLabel.visibleProperty().bind((ObservableValue)this.automaticallyRadioButton.disableProperty());
        this.getSubscriptions().add(EventStreams.changesOf((ObservableValue)LicenseService.getLoading()).subscribe(booleanChange -> setDisableOfAutomaticallyRadioButton.accept((Boolean)booleanChange.getNewValue())));
        setDisableOfAutomaticallyRadioButton.accept(LicenseService.getLoading().get());
    }

    private void initializeRuleSelectionComboBox() {
        this.transcriptRuleSelectionComboBox.setPromptText(this.messageService.getLocaleBundle().getString("createTranscriptScreen.TranscriptionRules"));
        this.transcriptRuleSelectionComboBox.getItems().setAll((Object[])TranscriptionRuleSet.values());
        this.transcriptRuleSelectionComboBox.setConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        this.transcriptRuleSelectionComboBox.getValidators().add((Object)new RequiredFieldValidator(this.messageService.getLocaleBundle().getString("createTranscriptScreen.pleaseChooseRuleSet")));
        this.transcriptRuleSelectionComboBox.getSelectionModel().selectedItemProperty().addListener((obs, old, newVal) -> this.transcriptRuleSelectionComboBox.validate());
        this.transcriptRuleSelectionComboBox.focusedProperty().addListener((obs, old, newVal) -> {
            if (Boolean.FALSE.equals(newVal)) {
                this.transcriptRuleSelectionComboBox.validate();
            }
        });
    }

    private void initializeLanguageComboBox() {
        this.languageComboBox.setPromptText(this.messageService.getLocaleBundle().getString("createTranscriptScreen.language"));
        this.languageComboBox.getItems().setAll(this.sttLanguageService.getSupportedAzureLanguages().stream().map(SttLanguage::label).toList());
        this.languageComboBox.setValidators(new ValidatorBase[]{new RequiredFieldValidator(this.messageService.getLocaleBundle().getString("createTranscriptScreen.pleaseChooseLanguage")), new /* Unavailable Anonymous Inner Class!! */});
        this.languageComboBox.getSelectionModel().selectedItemProperty().addListener((obs, old, newVal) -> this.languageComboBox.validate());
        this.languageComboBox.focusedProperty().addListener((obs, old, newVal) -> {
            if (Boolean.FALSE.equals(newVal)) {
                this.languageComboBox.validate();
            }
        });
        this.textFormattingService.addAutoCompletePopup(this.languageComboBox);
    }

    private void initializeScrollPane() {
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.requestFocus();
        this.scrollContentVBox.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty());
    }

    private void onClose(WindowEvent windowEvent) {
        this.unsubscribeAllSubscriptions();
    }

    private void initializeRadioButtons() {
        this.transcriptCreationModeToggleGroup.getToggles().addAll((Object[])new Toggle[]{this.manualRadioButton, this.automaticallyRadioButton});
        this.transcriptCreationModeToggleGroup.selectToggle((Toggle)this.manualRadioButton);
        this.manualRadioButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                log.warn("Boolean value is null.", (Throwable)new NullPointerException());
                return;
            }
            if (newValue.booleanValue()) {
                this.showManualCreationFields();
            } else {
                this.showAutomaticCreationFields();
            }
        });
    }

    private void showAutomaticCreationFields() {
        this.settingsManualVBox.setVisible(false);
        this.settingsManualVBox.setManaged(false);
        this.finishButton.disableProperty().unbind();
        this.bindFinishButtonForAutomatic();
        this.settingsAutomaticVBox.setVisible(true);
        this.settingsAutomaticVBox.setManaged(true);
        this.mediaPathLabel.setText("");
        if (this.transcriptPathLabel.getText().endsWith(".ett")) {
            this.transcriptPathLabel.setText(this.transcriptPathLabel.getText().substring(0, this.transcriptPathLabel.getText().lastIndexOf(".ett")));
        }
    }

    private void showManualCreationFields() {
        this.settingsAutomaticVBox.setVisible(false);
        this.settingsAutomaticVBox.setManaged(false);
        this.agreeToDataPrivacyCheckBox.setSelected(false);
        this.bindDisablePropertyOfFinishButton();
        this.addedFilesAutomaticVBox.getChildren().clear();
        this.transcriptRuleSelectionComboBox.setValue(null);
        this.settingsManualVBox.setVisible(true);
        this.settingsManualVBox.setManaged(true);
        this.addFileExtensionIfMissing();
    }

    private void bindDisablePropertyOfFinishButton() {
        this.finishButton.disableProperty().unbind();
        this.finishButton.disableProperty().bind((ObservableValue)this.transcriptPathLabel.textProperty().isEmpty().or((ObservableBooleanValue)this.mediaPathLabel.textProperty().isEmpty()).or((ObservableBooleanValue)this.statusService.savingProperty()));
    }

    public void reset() {
        this.transcriptPathLabel.setText("");
        this.mediaPathLabel.setText("");
        this.totalDurationProperty.set(0L);
        this.totalDurationProperty.set(0L);
        this.totalDurationText.setText("?");
        this.totalBalanceText.setText("?");
        this.transcriptCreationModeToggleGroup.selectToggle((Toggle)this.manualRadioButton);
        this.bindDisablePropertyOfFinishButton();
    }

    private void bindFinishButtonForAutomatic() {
        this.finishButton.disableProperty().unbind();
        this.finishButton.disableProperty().bind((ObservableValue)this.transcriptPathLabel.textProperty().isEmpty().or((ObservableBooleanValue)this.allAutomaticMediaFilesValid.not()).or((ObservableBooleanValue)this.transcriptRuleSelectionComboBox.getSelectionModel().selectedItemProperty().isNull()).or((ObservableBooleanValue)this.getInvalidSelectedLanguageBinding()).or((ObservableBooleanValue)this.agreeToDataPrivacyCheckBox.selectedProperty().not()).or((ObservableBooleanValue)this.statusService.savingProperty()).or((ObservableBooleanValue)Bindings.createBooleanBinding(() -> this.totalBalanceProperty.get() - this.totalDurationProperty.get() < 0L && this.totalBalanceProperty.get() != -1L, (Observable[])new Observable[]{this.totalBalanceProperty, this.totalDurationProperty})));
    }

    public @NonNull BooleanBinding getInvalidSelectedLanguageBinding() {
        return this.languageComboBox.getSelectionModel().selectedItemProperty().isNull().or((ObservableBooleanValue)Bindings.createBooleanBinding(() -> this.sttLanguageService.getLanguageByLabel((String)this.languageComboBox.getSelectionModel().getSelectedItem()) == null, (Observable[])new Observable[]{this.languageComboBox.getSelectionModel().selectedItemProperty()}));
    }

    private void updateAllAutomaticMediaFilesValidBinding() {
        ObservableList children = this.addedFilesAutomaticVBox.getChildren();
        if (children.isEmpty()) {
            this.allAutomaticMediaFilesValid.set(false);
            return;
        }
        boolean allValid = children.stream().map(node -> (SpeakerFileEntryController)node.getUserData()).filter(Objects::nonNull).allMatch(ctrl -> ctrl.getValidProperty().get());
        this.allAutomaticMediaFilesValid.setValue(Boolean.valueOf(allValid));
        log.info("All automatic media files valid: {}", (Object)this.allAutomaticMediaFilesValid.get());
    }

    public void close() {
        this.subscriptions.forEach(Subscription::unsubscribe);
        ((Stage)this.cancelButton.getScene().getWindow()).close();
    }

    public void finish() {
        log.debug("Finished entering information for transcript.");
        if (this.manualRadioButton.isSelected()) {
            this.finishManualTranscriptionCreation();
        } else {
            this.finishAutomaticTranscriptionCreation();
        }
    }

    private void finishAutomaticTranscriptionCreation() {
        log.debug("Creating an automatic transcript.");
        this.finishButton.getScene().setCursor(Cursor.WAIT);
        this.statusService.setSaving(true);
        this.statusService.setSavingProgress(100);
        AutomaticTranscriptCreationInfo meta = this.getAutomaticTranscriptCreationInfo();
        long totalSize = this.jobCreationService.calculateCombinedSize(meta);
        this.sumPersonDuration(meta, true).then(this.processTranscriptCreation(meta, totalSize)).doOnError(arg_0 -> this.handleCreationError(arg_0)).doFinally(signal -> this.resetUIStateAfterProcessing()).subscribe(uuid -> Platform.runLater(() -> this.close()));
    }

    private Mono<Long> sumPersonDuration(AutomaticTranscriptCreationInfo meta, boolean enforceRecalculation) {
        return Mono.create(sink -> {
            SumPersonDurationsTask task = new SumPersonDurationsTask(meta, enforceRecalculation);
            task.setOnRunning(e -> log.debug("Summing durations for participants..."));
            task.setOnSucceeded(e -> {
                meta.setDurationInSeconds((Long)task.getValue() / 1000L);
                log.debug("Completed summing durations: {}", (Object)meta.getDurationInSeconds());
                sink.success((Object)((Long)task.getValue() / 1000L));
            });
            task.setOnFailed(e -> {
                log.error("Failed to sum durations.", task.getException());
                sink.error(task.getException());
            });
            this.executorService.submit((Runnable)task);
        });
    }

    private Mono<String> processTranscriptCreation(AutomaticTranscriptCreationInfo meta, long totalSize) {
        return this.jobCreationService.canCreateAutomaticTranscript(meta, totalSize).flatMap(result -> this.handleTranscriptCreationDecisions(meta, totalSize, result)).flatMap(unused -> this.jobCreationService.createAutomaticTranscriptionJob(meta));
    }

    private Mono<String> handleTranscriptCreationDecisions(AutomaticTranscriptCreationInfo meta, long totalSize, Tuple2<Boolean, Boolean> result) {
        boolean isTooBig = (Boolean)result.getT1();
        boolean isAlreadyRunning = (Boolean)result.getT2();
        if (isTooBig) {
            return this.handleTooBigError(totalSize);
        }
        if (isAlreadyRunning) {
            return this.handleAlreadyRunningJob(meta);
        }
        return Mono.just((Object)"");
    }

    private Mono<String> handleTooBigError(long totalSize) {
        return this.sttService.getMaxUploadSize().flatMap(maxSize -> {
            this.jobCreationService.showTooBigError(totalSize, maxSize);
            return Mono.empty();
        });
    }

    private Mono<String> handleAlreadyRunningJob(AutomaticTranscriptCreationInfo meta) {
        return Mono.fromCallable(() -> {
            CompletableFuture future = new CompletableFuture();
            Platform.runLater(() -> {
                try {
                    ButtonType result = this.jobCreationService.showAlreadyRunningWarning();
                    future.complete(result);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
            return (ButtonType)future.get();
        }).flatMap(buttonType -> {
            if (ButtonType.YES.equals(buttonType)) {
                return Mono.just((Object)"");
            }
            return Mono.empty();
        });
    }

    private void handleCreationError(Throwable throwable) {
        log.error("An error occurred during transcription creation.", throwable);
        if (!(throwable instanceof LicenseInvalidException)) {
            this.exceptionAlert.showModal();
        }
    }

    private void resetUIStateAfterProcessing() {
        Platform.runLater(() -> {
            this.finishButton.getScene().setCursor(Cursor.DEFAULT);
            this.statusService.setSaving(false);
        });
    }

    AutomaticTranscriptCreationInfo getAutomaticTranscriptCreationInfo() {
        AutomaticTranscriptCreationInfo meta = this.automaticTranscriptService.getCurrentInfo();
        meta.setTranscriptLocation(Path.of(this.transcriptPathLabel.getText(), new String[0]));
        SttLanguage language = this.sttLanguageService.getLanguageByLabel((String)this.languageComboBox.getValue());
        if (language == null) {
            log.warn("No stt language was detected. Input: {}", this.languageComboBox.getValue());
            meta.setLanguage("de-DE");
        } else {
            meta.setLanguage(language.tag());
        }
        meta.setTranscriptionRuleSet((TranscriptionRuleSet)this.transcriptRuleSelectionComboBox.getValue());
        meta.getPersons().clear();
        meta.getPersons().addAll((Collection)this.jobCreationService.getAllPersons(this.addedFilesAutomaticVBox));
        return meta;
    }

    private void finishManualTranscriptionCreation() {
        log.debug("Creating a manual transcript.");
        this.closeDialog.showAndWait(false, () -> this.createManualTranscript());
    }

    private void createManualTranscript() {
        this.transcriptService.setCurrentTranscript(new Transcript());
        this.addFileExtensionIfMissing();
        if (this.jobCreationService.mediaFileDoesNotExist(Path.of(this.mediaPathLabel.getText(), new String[0]))) {
            return;
        }
        if (this.jobCreationService.isTranscriptLocationNotWritable(Path.of(this.transcriptPathLabel.getText(), new String[0]).getParent())) {
            return;
        }
        this.transcriptService.getCurrentTranscript().setMediaLocation(Path.of(this.mediaPathLabel.getText(), new String[0]));
        this.transcriptService.getCurrentTranscript().setTranscriptLocation(Path.of(this.transcriptPathLabel.getText(), new String[0]));
        log.debug("Creating new Transcript ...");
        this.statusService.setShowProgressForSaving(true);
        this.saveTranscriptService.setOnFailed(event -> {
            log.error("Failed to save", event.getSource().getException());
            this.exceptionAlert.showModal();
            this.statusService.setShowProgressForSaving(false);
        });
        this.saveTranscriptService.setOnSucceeded(event -> {
            this.statusService.setShowProgressForSaving(false);
            this.saveTranscriptService.setOnSucceeded(null);
            if (Files.exists(this.transcriptService.getCurrentTranscript().getTranscriptLocation(), new LinkOption[0])) {
                this.loadTranscriptService.openTranscript(this.transcriptService.getCurrentTranscript().getTranscriptLocation());
            } else if (Boolean.TRUE.equals(this.saveTranscriptService.getValue())) {
                log.error("Newly created transcript does not exist.");
                this.exceptionAlert.showModal();
            }
            this.close();
            this.saveTranscriptService.setOnSucceeded(null);
        });
        this.saveTranscriptService.save(this.transcriptService.getCurrentTranscript(), this.documentSerializer.serializeContent((StyledDocument)ReadOnlyStyledDocument.fromString((String)"", (Object)((ParStyle)this.transcriptTextArea.getInitialParagraphStyle()), (Object)((TextStyle)this.transcriptTextArea.getInitialTextStyle()), (TextOps)TranscriptTextArea.STYLED_TEXT_OPS)), false, false, true, false);
    }

    private void addFileExtensionIfMissing() {
        if (!this.transcriptPathLabel.getText().endsWith(".ett") && !this.transcriptPathLabel.getText().isBlank()) {
            this.transcriptPathLabel.setText(this.transcriptPathLabel.getText() + ".ett");
        }
    }

    public void setMediaFile() {
        String media = this.transcriptCreationUIHelperService.openMediaFile((Stage)this.transcriptPathLabel.getScene().getWindow());
        if (!media.isEmpty()) {
            this.mediaPathLabel.setText(media);
        }
    }

    public void setTranscriptLocation() {
        this.transcriptCreationUIHelperService.setTranscriptLocation(this.transcriptPathLabel, true);
        if (this.manualRadioButton.isSelected() && !this.transcriptPathLabel.getText().isEmpty() && !this.transcriptPathLabel.getText().endsWith(".ett")) {
            this.transcriptPathLabel.setText(this.transcriptPathLabel.getText() + ".ett");
        }
    }

    public void addAdditionalFile() {
        String media = this.transcriptCreationUIHelperService.openMediaFile((Stage)this.transcriptPathLabel.getScene().getWindow());
        if (!media.isEmpty()) {
            SpeakerFileEntryController speakerFileEntryController = this.speakerFileEntryFactory.create(media, (BooleanProperty)this.showDetailsProperty);
            VBox rootNode = speakerFileEntryController.getRoot();
            rootNode.setUserData((Object)speakerFileEntryController);
            this.addedFilesAutomaticVBox.getChildren().add((Object)speakerFileEntryController.getRoot());
            this.subscriptions.add(EventStreams.changesOf((ObservableValue)speakerFileEntryController.getValidProperty()).subscribe(change -> this.updateAllAutomaticMediaFilesValidBinding()));
            this.updateAllAutomaticMediaFilesValidBinding();
        }
    }

    public void openPrivacyPolicy() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(this.messageService.getLocaleBundle().getString("createTranscriptScreen.privacyURL")));
            } else {
                log.error("Desktop is not supported.");
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("", (Throwable)e);
            this.exceptionAlert.showModal();
        }
    }

    private void showTutorial() {
        if (this.configurationService.getConfiguration().getSeenTutorials().contains("CreateTranscript")) {
            return;
        }
        CreateTranscriptTutorial tutorial = (CreateTranscriptTutorial)this.tutorialService.getTutorialBean(CreateTranscriptTutorial.class);
        tutorial.setSkipMenu(true);
        this.tutorialService.show((Tutorial)tutorial).subscribeForOne(ignored -> {
            this.configurationService.getConfiguration().getSeenTutorials().add("CreateTranscript");
            this.configurationService.save();
        });
    }

    public void showDetails() {
        this.showDetailsProperty.set(true);
    }

    @Generated
    public CreateTranscriptController(SaveTranscriptService saveTranscriptService, TranscriptCreationUIHelperService transcriptCreationUIHelperService, STTService sttService, StatusService statusService, CloseDialog closeDialog, LoadTranscriptService loadTranscriptService, TutorialService tutorialService, ExecutorService executorService, JobCreationService jobCreationService, LicenseService licenseService, SttLanguageService sttLanguageService, TranscriptTextArea transcriptTextArea, ConfigurationService configurationService, SpeakerFileEntryFactory speakerFileEntryFactory, DocumentSerializer documentSerializer, TextFormattingService textFormattingService, TranscriptService transcriptService, AutomaticTranscriptService automaticTranscriptService, MessageService messageService) {
        this.saveTranscriptService = saveTranscriptService;
        this.transcriptCreationUIHelperService = transcriptCreationUIHelperService;
        this.sttService = sttService;
        this.statusService = statusService;
        this.closeDialog = closeDialog;
        this.loadTranscriptService = loadTranscriptService;
        this.tutorialService = tutorialService;
        this.executorService = executorService;
        this.jobCreationService = jobCreationService;
        this.licenseService = licenseService;
        this.sttLanguageService = sttLanguageService;
        this.transcriptTextArea = transcriptTextArea;
        this.configurationService = configurationService;
        this.speakerFileEntryFactory = speakerFileEntryFactory;
        this.documentSerializer = documentSerializer;
        this.textFormattingService = textFormattingService;
        this.transcriptService = transcriptService;
        this.automaticTranscriptService = automaticTranscriptService;
        this.messageService = messageService;
    }

    @Generated
    public SimpleBooleanProperty getAllAutomaticMediaFilesValid() {
        return this.allAutomaticMediaFilesValid;
    }

    @Generated
    public VBox getDataPrivacyVBox() {
        return this.dataPrivacyVBox;
    }

    @Generated
    public VBox getTranscriptionRulesVBox() {
        return this.transcriptionRulesVBox;
    }

    @Generated
    public VBox getAutomaticMediaFilesVBox() {
        return this.automaticMediaFilesVBox;
    }

    @Generated
    public HBox getButtonBarHBox() {
        return this.buttonBarHBox;
    }

    @Generated
    public VBox getSavingLocationVBox() {
        return this.savingLocationVBox;
    }

    @Generated
    public VBox getTypeOfTranscriptVBox() {
        return this.typeOfTranscriptVBox;
    }

    @Generated
    public Button getFinishButton() {
        return this.finishButton;
    }

    @Generated
    public JFXRadioButton getManualRadioButton() {
        return this.manualRadioButton;
    }

    @Generated
    public JFXRadioButton getAutomaticallyRadioButton() {
        return this.automaticallyRadioButton;
    }

    @Generated
    public VBox getSettingsManualVBox() {
        return this.settingsManualVBox;
    }

    @Generated
    public Button getShowDetailsButton() {
        return this.showDetailsButton;
    }

    @Generated
    public Label getTranscriptPathLabel() {
        return this.transcriptPathLabel;
    }

    @Generated
    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Generated
    public Label getMediaPathLabel() {
        return this.mediaPathLabel;
    }

    @Generated
    public VBox getAddedFilesAutomaticVBox() {
        return this.addedFilesAutomaticVBox;
    }

    @Generated
    public JFXComboBox<String> getLanguageComboBox() {
        return this.languageComboBox;
    }

    @Generated
    public VBox getLanguageVBox() {
        return this.languageVBox;
    }

    @Generated
    public JFXComboBox<TranscriptionRuleSet> getTranscriptRuleSelectionComboBox() {
        return this.transcriptRuleSelectionComboBox;
    }

    @Generated
    public JFXCheckBox getAgreeToDataPrivacyCheckBox() {
        return this.agreeToDataPrivacyCheckBox;
    }
}

