/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript;

import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.GenerationState;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SpeakerFileEntryController;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferException;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.utils.STTUtils;
import eu.ewerkzeug.easytranscript3.networking.license.LicenseInvalidException;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseValidationService;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

@Service
public class JobCreationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobCreationService.class);
    private final STTService sttService;
    private final STTStatusService sttStatusService;
    private final STTDeletionService sttDeletionService;
    private final STTDialogService sttDialogService;
    private final LicenseService licenseService;
    private final StatusService statusService;
    private final LicenseValidationService licenseValidationService;
    private final MessageService messageService;
    private final AlertService alertService;
    private final DialogService dialogService;

    @NotNull
    private static Person getPerson(SpeakerFileEntryController entry) {
        Person speaker = new Person();
        String name = entry.getSpeakerNameTextField().getText().trim();
        if (name.isEmpty()) {
            name = "Person 1";
        }
        if (name.contains(" ")) {
            speaker.setFirstname(name.substring(0, name.lastIndexOf(" ")));
            speaker.setLastname(name.substring(name.lastIndexOf(" ") + 1));
        } else {
            speaker.setFirstname(name);
        }
        speaker.setUuid(UUID.randomUUID().toString());
        speaker.setMediaPath(Path.of(entry.getMediaPathLabel().getText(), new String[0]));
        speaker.getProperties().setStartOffset(entry.getDurationPickerController().getDuration().toMillis());
        return speaker;
    }

    public Mono<Tuple2<Boolean, Boolean>> canCreateAutomaticTranscript(AutomaticTranscriptCreationInfo meta, long totalSize) {
        if (!this.licenseValidationService.isUserLicenseValid()) {
            this.licenseService.showLicenseNotValidDialog();
            return Mono.error((Throwable)new LicenseInvalidException("License not valid."));
        }
        if (this.isTranscriptLocationNotWritable(meta.getTranscriptLocation().getParent())) {
            return Mono.error((Throwable)new IOException("Not writable"));
        }
        if (this.checkIfCurrentlyUpOrDownloading()) {
            return Mono.error((Throwable)new TransferException("Currently transfer in progress.", 0));
        }
        Mono tooBig = this.sttService.getMaxUploadSize().map(maxUploadSize -> totalSize > maxUploadSize);
        return Mono.zip((Mono)tooBig, (Mono)this.isAutomaticTranscriptionAlreadyRunning());
    }

    private boolean checkIfCurrentlyUpOrDownloading() {
        ETDialog dialog = this.sttDialogService.createUploadDownloadCancelAlert(this.sttStatusService.isDownloading(), this.sttStatusService.isUploading());
        if (dialog != null) {
            ButtonType buttonType = dialog.showAndWait();
            if (buttonType != ButtonType.YES) {
                return true;
            }
            this.sttDeletionService.cancelAllOngoingTransfers();
        }
        return false;
    }

    private Mono<Boolean> isAutomaticTranscriptionAlreadyRunning() {
        return this.sttService.getJobStatus().doOnError(e -> {
            log.error("Got error when trying to get job status.", e);
            String title = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToGetStatusTitle");
            String content = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToGetStatus");
            this.showSimpleDialog(title, content);
        }).map(res -> {
            log.info("Result: {}", res);
            return res.getBody() != null && GenerationState.isTranscriptGenerationInProgress((GenerationState)((AutomaticTranscriptStatus)res.getBody()).getStatus());
        });
    }

    ButtonType showAlreadyRunningWarning() {
        log.debug("Transcription job already exists. Showing cancel dialog ...");
        ETButtonType yesButtonType = new ETButtonType(ButtonType.YES, false, true);
        return this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("createTranscriptScreen.projectAlreadyRunningTitle"), this.messageService.getLocaleBundle().getString("createTranscriptScreen.projectAlreadyRunning"), Modality.APPLICATION_MODAL, Arrays.asList(yesButtonType, new ETButtonType(ButtonType.NO, true, false))).showAndWait();
    }

    public Mono<ResponseEntity<Void>> deleteAutomaticTranscriptionJob() {
        return this.sttDeletionService.deleteTranscriptionJob().doOnError(WebClientResponseException.class, e -> {
            log.error("", (Throwable)e);
            if (e.getStatusCode().value() == HttpStatus.UNAUTHORIZED.value()) {
                this.sttDialogService.showUnauthorizedError();
            } else if (e.getStatusCode().value() >= 400 && e.getStatusCode().value() < 500) {
                this.showSimpleDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToDeleteProjectTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToDeleteProject"));
            } else {
                this.alertService.showServerError();
            }
        }).doOnError(WebClientRequestException.class, webClientRequestException -> this.alertService.showConnectionError());
    }

    Mono<String> createAutomaticTranscriptionJob(AutomaticTranscriptCreationInfo meta) {
        log.debug("Creating automatic transcription job ...");
        this.statusService.setShowProgressForSaving(true);
        return this.sttService.createAutomaticTranscriptionJob(meta).flatMap(arg_0 -> this.handleAutomaticTranscriptionJobCreationErrorCases(arg_0)).doOnError(WebClientResponseException.class, e -> {
            log.error("Could not create job because of an unknown reason.", (Throwable)e);
            this.alertService.showServerError();
            this.sttStatusService.resetCurrentProcess();
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
        }).doOnError(WebClientRequestException.class, e -> {
            log.error("Could not create job because of an unknown reason.", (Throwable)e);
            this.alertService.showConnectionError();
            this.sttStatusService.resetCurrentProcess();
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
        }).doOnError(Exception.class, exception -> {
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
            this.sttStatusService.resetCurrentProcess();
        }).doOnNext(uuid -> {
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
            log.info("Created transcription job {}", uuid);
            try {
                meta.setUuid(uuid);
                this.sttStatusService.startUploadOfMediaFiles();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw e;
            }
        });
    }

    private Mono<String> handleAutomaticTranscriptionJobCreationErrorCases(ResponseEntity<String> response) {
        if (response == null || response.getStatusCode().value() >= 500) {
            this.alertService.showServerError();
            this.sttStatusService.resetCurrentProcess();
        } else if (response.getStatusCode().value() == HttpStatus.BAD_REQUEST.value()) {
            log.error("Transcription job already exists. Showing cancel dialog ...");
            String title = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle");
            String content = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectGenericClientError");
            this.showSimpleDialog(title, content);
            this.sttStatusService.resetCurrentProcess();
        } else if (response.getStatusCode().value() == HttpStatus.UNAUTHORIZED.value()) {
            this.sttDialogService.showUnauthorizedError();
            this.sttStatusService.resetCurrentProcess();
        } else if (response.getStatusCode().value() == HttpStatus.TOO_MANY_REQUESTS.value()) {
            String title = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle");
            String content = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectAlreadyRunning");
            this.showSimpleDialog(title, content);
            this.sttStatusService.resetCurrentProcess();
        }
        if (response == null || !response.getStatusCode().is2xxSuccessful()) {
            log.error("Could not create job: " + (response != null ? response.getStatusCode().toString() : "-1"));
            return Mono.empty();
        }
        return Mono.justOrEmpty((Object)((String)response.getBody()));
    }

    long calculateCombinedSize(AutomaticTranscriptCreationInfo meta) {
        long totalSize = 0L;
        for (Person p : meta.getPersons()) {
            try {
                FileChannel imageFileChannel = FileChannel.open(p.getMediaPath(), new OpenOption[0]);
                try {
                    totalSize += imageFileChannel.size();
                }
                finally {
                    if (imageFileChannel == null) continue;
                    imageFileChannel.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to read media file for calculating total size.", (Throwable)e);
                this.showSimpleDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToReadMediaFile"));
                return -1L;
            }
        }
        return totalSize;
    }

    @NotNull
    List<Person> getAllPersons(VBox addedFilesAutomaticVBox) {
        return addedFilesAutomaticVBox.getChildren().stream().map(Node::getUserData).map(SpeakerFileEntryController.class::cast).filter(e -> !this.mediaFileDoesNotExist(Path.of(e.getMediaPathLabel().getText(), new String[0]))).map(JobCreationService::getPerson).toList();
    }

    @NotNull
    Set<String> getDictionaryWords(GridPane dictionaryGridPane) {
        return dictionaryGridPane.getChildren().stream().filter(TextField.class::isInstance).map(TextField.class::cast).map(TextInputControl::getText).filter(text -> !text.isBlank()).collect(Collectors.toSet());
    }

    void showTooBigError(long totalSize, Long maxSize) {
        log.warn("Selected media files are too big to be uploaded ({}, allowed: {}).", (Object)totalSize, (Object)maxSize);
        String content = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.quotaExceededBeforeUploading");
        MessageFormat formatter = new MessageFormat(content, this.messageService.getLocaleBundle().getLocale());
        Platform.runLater(() -> this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), formatter.format(new Object[]{STTUtils.humanReadableByteCountSI((long)totalSize), STTUtils.humanReadableByteCountSI((long)maxSize)}), Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    private void showSimpleDialog(String title, String content) {
        Platform.runLater(() -> this.dialogService.createDialog(title, content, Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    public boolean isTranscriptLocationNotWritable(Path transcriptLocation) {
        File file = transcriptLocation.toFile();
        if (!file.exists() || !file.isDirectory()) {
            log.error("Transcript location {} is not writable!", (Object)transcriptLocation);
            this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.locationOfTranscriptDoesNotExist")).showAndWait();
            return true;
        }
        return false;
    }

    public boolean mediaFileDoesNotExist(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            this.dialogService.get(this.messageService.getLocaleBundle().getString("problems.mediaFileNotFound")).showAndWait();
            return true;
        }
        return false;
    }

    @Generated
    public JobCreationService(STTService sttService, STTStatusService sttStatusService, STTDeletionService sttDeletionService, STTDialogService sttDialogService, LicenseService licenseService, StatusService statusService, LicenseValidationService licenseValidationService, MessageService messageService, AlertService alertService, DialogService dialogService) {
        this.sttService = sttService;
        this.sttStatusService = sttStatusService;
        this.sttDeletionService = sttDeletionService;
        this.sttDialogService = sttDialogService;
        this.licenseService = licenseService;
        this.statusService = statusService;
        this.licenseValidationService = licenseValidationService;
        this.messageService = messageService;
        this.alertService = alertService;
        this.dialogService = dialogService;
    }
}

