/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.RequiredFieldValidator;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.DurationPickerController;
import eu.ewerkzeug.easytranscript3.mvc.transcript.TranscriptCreationUIHelperService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@FxmlView(value="speakerFileEntry.fxml")
public class SpeakerFileEntryController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerFileEntryController.class);
    private final TranscriptCreationUIHelperService transcriptCreationUIHelperService;
    private final MessageService messageService;
    @FXML
    private VBox root;
    @FXML
    private Label mediaPathLabel;
    @FXML
    private Button removeSpeakerButton;
    @FXML
    private Button mediaFileButton;
    @FXML
    private JFXTextField speakerNameTextField;
    @FXML
    private HBox detailsHBox;
    @FXML
    private DurationPickerController durationPickerController;
    private final SimpleBooleanProperty validProperty = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty showDetailsProperty = new SimpleBooleanProperty(false);

    @FXML
    public void initialize() {
        this.detailsHBox.visibleProperty().bind((ObservableValue)this.showDetailsProperty);
        this.detailsHBox.managedProperty().bind((ObservableValue)this.showDetailsProperty);
        this.mediaFileButton.setText(this.mediaFileButton.getText() + " \u203a");
        this.removeSpeakerButton.setOnAction(event -> this.removeSpeaker());
        this.mediaFileButton.setOnAction(event -> {
            String media = this.transcriptCreationUIHelperService.openMediaFile((Stage)this.mediaFileButton.getScene().getWindow());
            if (media != null && !media.isEmpty()) {
                this.mediaPathLabel.setText(media);
            }
        });
        this.mediaPathLabel.textProperty().addListener((obs, old, newValue) -> this.checkForValidity());
        this.speakerNameTextField.textProperty().addListener((obs, old, newValue) -> this.checkForValidity());
        this.showDetailsProperty.addListener((obs, old, newValue) -> this.checkForValidity());
        this.setupValidation();
    }

    private void setupValidation() {
        ResourceBundle bundle = this.messageService.getLocaleBundle();
        this.speakerNameTextField.getValidators().add((Object)new RequiredFieldValidator(bundle.getString("createTranscriptScreen.pleaseEnterName")));
        this.speakerNameTextField.focusedProperty().addListener((obs, old, isFocused) -> {
            if (!isFocused.booleanValue()) {
                this.speakerNameTextField.validate();
            }
        });
    }

    private void checkForValidity() {
        this.validProperty.set(!this.mediaPathLabel.getText().isBlank() && (!this.showDetailsProperty.get() || !this.speakerNameTextField.getText().isBlank()));
    }

    public void removeSpeaker() {
        Parent parent = this.root.getParent();
        if (parent instanceof Pane) {
            Pane pane = (Pane)parent;
            pane.getChildren().remove((Object)this.root);
        }
    }

    public void prepare(String mediaPath, BooleanProperty showDetails) {
        if (mediaPath != null) {
            this.mediaPathLabel.setText(mediaPath);
        }
        if (showDetails != null) {
            this.showDetailsProperty.bind((ObservableValue)showDetails);
        }
    }

    @Generated
    public TranscriptCreationUIHelperService getTranscriptCreationUIHelperService() {
        return this.transcriptCreationUIHelperService;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public Label getMediaPathLabel() {
        return this.mediaPathLabel;
    }

    @Generated
    public Button getRemoveSpeakerButton() {
        return this.removeSpeakerButton;
    }

    @Generated
    public Button getMediaFileButton() {
        return this.mediaFileButton;
    }

    @Generated
    public JFXTextField getSpeakerNameTextField() {
        return this.speakerNameTextField;
    }

    @Generated
    public HBox getDetailsHBox() {
        return this.detailsHBox;
    }

    @Generated
    public DurationPickerController getDurationPickerController() {
        return this.durationPickerController;
    }

    @Generated
    public SimpleBooleanProperty getValidProperty() {
        return this.validProperty;
    }

    @Generated
    public SimpleBooleanProperty getShowDetailsProperty() {
        return this.showDetailsProperty;
    }

    @Generated
    public SpeakerFileEntryController(TranscriptCreationUIHelperService transcriptCreationUIHelperService, MessageService messageService) {
        this.transcriptCreationUIHelperService = transcriptCreationUIHelperService;
        this.messageService = messageService;
    }

    @Generated
    public VBox getRoot() {
        return this.root;
    }
}

