/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.updater;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javafx.concurrent.Task;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTask
extends Task<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadTask.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final URL downloadURL;
    private final Path localInstallerTmpPath;
    private InputStream downloadInputStream;

    public DownloadTask(URL downloadURL, Path localInstallerTmpPath) {
        this.downloadURL = downloadURL;
        this.localInstallerTmpPath = localInstallerTmpPath;
    }

    protected Void call() throws Exception {
        log.debug("Starting to download update: {}", (Object)this.downloadURL.toString());
        this.updateProgress(-1.0, 100.0);
        try {
            URLConnection urlConnection = this.downloadURL.openConnection();
            urlConnection.connect();
            long fileSize = urlConnection.getContentLengthLong();
            log.debug("FileSize of update: {}", (Object)fileSize);
            if (fileSize > 0L && fileSize < 100L) {
                throw new IOException("Update file seems to be damaged or too small.");
            }
            if (this.localInstallerTmpPath.getParent() != null) {
                Files.createDirectories(this.localInstallerTmpPath.getParent(), new FileAttribute[0]);
            }
            try (OutputStream output = Files.newOutputStream(this.localInstallerTmpPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                int n;
                this.downloadInputStream = urlConnection.getInputStream();
                byte[] buffer = new byte[8192];
                long downloaded = 0L;
                while ((n = this.downloadInputStream.read(buffer)) != -1) {
                    if (this.isCancelled()) {
                        log.debug("Download cancelled by user.");
                        break;
                    }
                    output.write(buffer, 0, n);
                    downloaded += (long)n;
                    if (fileSize <= 0L) continue;
                    this.updateProgress(downloaded / 1000L, fileSize / 1000L);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to download binary.", (Throwable)e);
            throw e;
        }
        finally {
            if (this.downloadInputStream != null) {
                this.downloadInputStream.close();
            }
        }
        return null;
    }

    @Generated
    public InputStream getDownloadInputStream() {
        return this.downloadInputStream;
    }
}

