/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.updater;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.fx.MarkdownToFXConverter;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETProgressBarController;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MiscService;
import eu.ewerkzeug.easytranscript3.mvc.updater.DownloadTask;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
@FxmlView(value="updaterScreen.fxml")
@StageTitle(value="%updaterScreen.Title")
@Lazy
public class UpdaterController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdaterController.class);
    private final ExecutorService executorService;
    private final DecimalFormat percentageFormat = new DecimalFormat("#0");
    private final DecimalFormat mbTwoDecimals = new DecimalFormat("#0.00");
    private final MiscService miscService;
    private final ConfigurationService configurationService;
    private final MarkdownToFXConverter markdownToFXConverter;
    private final DialogService dialogService;
    private final WebClient.Builder webClientBuilder;
    @FXML
    public SpacedText updateChannelInformation;
    private WebClient webClient;
    @FXML
    private Label totalSizeText;
    @FXML
    private Label currentSizeText;
    @FXML
    private ETProgressBarController progressBarController;
    @FXML
    private Label progressBarText;
    @FXML
    private VBox downloadProgressInformationVBox;
    @FXML
    private Button cancelButton;
    @FXML
    private Button installButton;
    @FXML
    private VBox changelogVBox;
    @FXML
    private Label currentVersionText;
    @FXML
    private Label newVersionText;
    private String newVersion;
    private String channel;
    private ChangeListener<? super Number> percentageListener;
    private ChangeListener<? super Number> workDoneListener;
    private ChangeListener<? super Number> totalWorkListener;
    private DownloadTask task;

    @PostConstruct
    public void setup() {
        this.webClient = this.webClientBuilder.build();
    }

    @FXML
    void close() {
        if (this.task != null) {
            this.task.cancel(true);
            if (this.task.getDownloadInputStream() != null) {
                try {
                    this.task.getDownloadInputStream().close();
                }
                catch (IOException e) {
                    log.error("Could not close input Stream.", (Throwable)e);
                }
            }
        }
        ((Stage)this.cancelButton.getScene().getWindow()).close();
    }

    public void setNewVersion(Version newVersion) {
        this.newVersion = newVersion.toString();
    }

    @FXML
    public void initializeController() {
        log.debug("Initialized update controller screen.");
    }

    public void install() {
        log.debug("Installing update ...");
        this.installButton.setDisable(true);
        this.downloadProgressInformationVBox.setVisible(true);
        this.progressBarController.setValue(0.0);
        String fileName = this.determineFilename();
        String os = this.determineOS();
        if (os == null) {
            return;
        }
        Path localInstallerTmpPath = Main.getEasytranscriptTempDirectory().resolve(fileName);
        URL downloadURL = this.getDownloadURL(os, fileName);
        if (downloadURL == null) {
            log.error("DownloadURL is null in UpdateController#install.");
            this.exceptionAlert.showModal();
            return;
        }
        this.task = new DownloadTask(downloadURL, localInstallerTmpPath);
        this.workDoneListener = (observable, oldValue, newValue) -> this.currentSizeText.setText(this.mbTwoDecimals.format(newValue.doubleValue() / 1000.0));
        this.totalWorkListener = (observable, oldValue, newValue) -> this.totalSizeText.setText(this.mbTwoDecimals.format(newValue.doubleValue() / 1000.0) + " MB");
        this.percentageListener = (observable, oldValue, newValue) -> {
            double val = Math.round(newValue.doubleValue() * 100.0);
            this.progressBarText.setText(this.percentageFormat.format(val < 0.0 ? 0.0 : val) + "%");
        };
        this.progressBarController.valueProperty().bind((ObservableValue)this.task.progressProperty().multiply(100));
        this.task.workDoneProperty().addListener((ChangeListener)new WeakChangeListener(this.workDoneListener));
        this.task.totalWorkProperty().addListener((ChangeListener)new WeakChangeListener(this.totalWorkListener));
        this.task.progressProperty().addListener((ChangeListener)new WeakChangeListener(this.percentageListener));
        this.task.setOnSucceeded(event -> this.onFinishedDownload(localInstallerTmpPath, downloadURL));
        this.task.setOnFailed(workerStateEvent -> this.onFailedDownload());
        this.executorService.submit((Runnable)this.task);
    }

    public URL getDownloadURL(String os, String fileName) {
        try {
            return URI.create(String.join((CharSequence)"/", "https://get.easytranscript.de/easytranscript3", this.channel, this.newVersion, os, fileName).replace(" ", "%20")).toURL();
        }
        catch (MalformedURLException e) {
            log.error("Could not create download url.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected String determineOS() {
        if (SystemUtils.IS_OS_MAC) {
            return "mac";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return "windows";
        }
        log.error("Unsupported os: {}", (Object)System.getProperty("os.name"));
        this.exceptionAlert.showModal();
        return null;
    }

    @NotNull
    protected String determineFilename() {
        String postfix = "";
        String installExtension = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            postfix = "-setup";
            installExtension = "exe";
        } else if (SystemUtils.IS_OS_MAC) {
            if (System.getProperty("os.arch").equals("aarch64")) {
                postfix = "_aarch64";
            }
            installExtension = "dmg";
        }
        return "easytranscript_" + this.newVersion + postfix + "." + installExtension;
    }

    private void onFailedDownload() {
        this.dialogService.get(this.getMessageService().getLocaleBundle().getString("updaterScreen.failedToDownload"), Alert.AlertType.WARNING).showAndWait();
        this.close();
    }

    private void onFinishedDownload(Path localInstallerTmpPath, URL downloadURL) {
        log.debug("Download was successful. Validating...");
        this.percentageListener = null;
        this.workDoneListener = null;
        this.totalWorkListener = null;
        this.progressBarController.valueProperty().unbind();
        this.progressBarController.setValue(0.0);
        this.progressBarText.setText(this.getMessageService().getLocaleBundle().getString("updaterScreen.validating"));
        if (this.isHashOfDownloadInvalid(localInstallerTmpPath, downloadURL)) {
            this.close();
            return;
        }
        this.startInstaller(localInstallerTmpPath);
    }

    public boolean isHashOfDownloadInvalid(Path localInstallerTmpPath, URL downloadURL) {
        try {
            String calculatedHash;
            String downloadedHash = (String)this.webClient.get().uri(downloadURL.toString() + ".sha256", new Object[0]).retrieve().bodyToMono(String.class).block();
            if (downloadedHash == null) {
                log.error("Downloaded hash is null.");
                this.exceptionAlert.showModal();
                return true;
            }
            if (downloadedHash.contains(" ")) {
                downloadedHash = downloadedHash.substring(0, downloadedHash.indexOf(" "));
            }
            downloadedHash = downloadedHash.trim();
            try (InputStream fis = Files.newInputStream(localInstallerTmpPath, new OpenOption[0]);){
                calculatedHash = DigestUtils.sha256Hex((InputStream)fis);
            }
            if (!downloadedHash.equalsIgnoreCase(calculatedHash)) {
                log.error("Hashes are not equal. {}(downloaded) != {}(calculated)", (Object)downloadedHash, (Object)calculatedHash);
                this.exceptionAlert.showModal();
                return true;
            }
            log.info("Hashes are equal: {}", (Object)downloadedHash);
            return false;
        }
        catch (Exception e) {
            log.error("Validation of download failed.", (Throwable)e);
            this.exceptionAlert.showModal();
            return true;
        }
    }

    protected void startInstaller(Path localInstallerTmpPath) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                log.debug("Launching installer on Windows...");
                Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", "\"\"", localInstallerTmpPath.toString()});
            } else if (SystemUtils.IS_OS_MAC) {
                log.debug("Mounting dmg on macOS...");
                Runtime.getRuntime().exec(new String[]{"open", localInstallerTmpPath.toString()});
            } else {
                log.debug("Running installer on Linux/other...");
                Runtime.getRuntime().exec(new String[]{localInstallerTmpPath.toString()});
            }
            Platform.runLater(() -> ((MiscService)this.miscService).closeProgram());
        }
        catch (Exception e) {
            log.error("Could not start installer.", (Throwable)e);
            this.dialogService.get(this.getMessageService().getLocaleBundle().getString("updaterScreen.couldNotStartInstaller")).showAndWait();
        }
    }

    public void reset() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.progressBarController.setChangeable(false);
        this.downloadProgressInformationVBox.setVisible(false);
        this.newVersionText.setText(this.newVersion);
        this.currentVersionText.setText(this.configurationService.getVersion().toString());
        this.updateChannelInformation.setText(MessageFormat.format(this.getMessageService().getLocaleBundle().getString("updaterScreen.updateChannelInformation"), this.configurationService.getConfiguration().getChannel().equals((Object)Channel.BETA) ? this.getMessageService().getLocaleBundle().getString("updaterScreen.betaVersion") : this.getMessageService().getLocaleBundle().getString("updaterScreen.stableVersion")));
        this.progressBarText.setText("");
        this.progressBarController.valueProperty().unbind();
        this.progressBarController.setValue(0.0);
        this.currentSizeText.textProperty().unbind();
        this.currentSizeText.setText("");
        this.totalSizeText.textProperty().unbind();
        this.totalSizeText.setText("");
        this.installButton.setDisable(false);
        Platform.runLater(() -> {
            this.changelogVBox.getChildren().clear();
            VBox content = this.markdownToFXConverter.parseMarkdownToTextFlow((String)this.getStage().getUserData());
            content.setDisable(true);
            this.changelogVBox.getChildren().add((Object)content);
        });
    }

    @Generated
    public UpdaterController(ExecutorService executorService, MiscService miscService, ConfigurationService configurationService, MarkdownToFXConverter markdownToFXConverter, DialogService dialogService, WebClient.Builder webClientBuilder) {
        this.executorService = executorService;
        this.miscService = miscService;
        this.configurationService = configurationService;
        this.markdownToFXConverter = markdownToFXConverter;
        this.dialogService = dialogService;
        this.webClientBuilder = webClientBuilder;
    }

    @Generated
    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }
}

