/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.updater;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.SpringBootJavaFxApplication;
import eu.ewerkzeug.easytranscript3.commons.RuntimeUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterController;
import eu.ewerkzeug.easytranscript3.mvc.updater.UpdaterService;
import eu.ewerkzeug.easytranscript3.service.ConfigurationService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.reactfx.util.FxTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class UpdaterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdaterService.class);
    static final String BASE_URL = "https://get.easytranscript.de/easytranscript3";
    private final UpdaterController updaterController;
    private final ExecutorService executorService;
    private final WebClient.Builder webClientBuilder;
    private final ConfigurationService configurationService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final GuiStateService guiStateService;
    private WebClient webClient;

    public Pair<Version, Channel> check(Version versionToCheckAgainst, boolean checkBetaChannel) {
        log.debug("Checking for new version, current version: {}, checking beta: {}", (Object)versionToCheckAgainst.toString(), (Object)checkBetaChannel);
        String versionStringStable = this.getVersionString(Channel.STABLE);
        Version version = null;
        Channel channel = null;
        if (versionStringStable != null) {
            try {
                version = Version.parse((String)versionStringStable);
                channel = Channel.STABLE;
            }
            catch (Exception e) {
                log.error("could not parse version string to version.", (Throwable)e);
            }
        }
        if (checkBetaChannel) {
            String versionStringBeta = this.getVersionString(Channel.BETA);
            Version betaVersion = null;
            if (versionStringBeta != null) {
                try {
                    betaVersion = Version.parse((String)versionStringBeta);
                }
                catch (Exception e) {
                    log.error("could not parse version string to version.", (Throwable)e);
                }
            }
            if (betaVersion != null && betaVersion.isHigherThan(version)) {
                version = betaVersion;
                channel = Channel.BETA;
            }
        }
        if (version != null && versionToCheckAgainst.isLowerThan(version)) {
            return Pair.of((Object)version, (Object)channel);
        }
        return Pair.of((Object)this.configurationService.getVersion(), (Object)this.configurationService.getConfiguration().getChannel());
    }

    private String getVersionString(Channel channel) {
        try {
            Object versionString = (String)this.webClient.get().uri("https://get.easytranscript.de/easytranscript3/" + channel.toString().toLowerCase() + "/latest-version", new Object[0]).retrieve().bodyToMono(String.class).block();
            if (versionString == null || ((String)versionString).trim().isEmpty()) {
                return null;
            }
            if (((String)(versionString = ((String)versionString).trim())).split("\\.").length == 2) {
                versionString = (String)versionString + ".0";
            }
            log.debug("Got version string \"{}\" for channel {} from server.", versionString, (Object)channel);
            return versionString;
        }
        catch (Exception e) {
            log.warn("Unable to detect latest version with channel {}", (Object)channel, (Object)e);
            return null;
        }
    }

    @PostConstruct
    public void setup() {
        this.webClient = this.webClientBuilder.build();
    }

    public void startUpdateCheck(boolean informUserIfUpToDate) {
        boolean[] startUpdateScreen = new boolean[]{false};
        Version[] newVersion = new Version[1];
        Channel[] newChannel = new Channel[1];
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        this.executorService.submit((Runnable)task);
        task.setOnSucceeded(workerStateEvent -> this.runLaterDelayed(() -> Platform.runLater(() -> {
            if (startUpdateScreen[0]) {
                if (this.isNotBundledJRE() || this.areUpdatesManagedBySystem()) {
                    log.debug("Showing website dialog instead of changelog.");
                    this.showInstructionsOnHowToUpdate();
                } else {
                    this.updaterController.setNewVersion(newVersion[0]);
                    this.updaterController.setChannel(newChannel[0].toString());
                    String url = "%s/changelogs/changelog_%s.md".formatted(BASE_URL, this.configurationService.getConfiguration().getProgramLanguage());
                    log.debug("Loading changelog from {}", (Object)url);
                    this.webClient.get().uri(url, new Object[0]).retrieve().bodyToMono(String.class).onErrorResume(error -> {
                        log.error("Failed to retrieve changelog.", error);
                        return Mono.just((Object)this.messageService.getLocaleBundle().getString("updaterScreen.couldNotLoadChangelog"));
                    }).subscribe(originalResult -> Platform.runLater(() -> {
                        String result = originalResult.isBlank() ? this.messageService.getLocaleBundle().getString("updaterScreen.couldNotLoadChangelog") : originalResult;
                        this.guiStateService.getController().showAdditionalScreen(UpdaterController.class, Modality.WINDOW_MODAL, (Object)result);
                    }));
                }
            } else if (informUserIfUpToDate) {
                this.dialogService.get(this.messageService.getLocaleBundle().getString("updaterScreen.easytranscriptIsUpToDateTitle"), this.messageService.getLocaleBundle().getString("updaterScreen.easytranscriptIsUpToDate")).showAndWait();
            }
        })));
    }

    protected void runLaterDelayed(Runnable runnable) {
        FxTimer.runLater((Duration)Duration.of(4L, ChronoUnit.SECONDS), (Runnable)runnable);
    }

    private void showInstructionsOnHowToUpdate() {
        ETButtonType toWebsite = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("updaterScreen.goToWebsite"), ButtonBar.ButtonData.NEXT_FORWARD), false, false);
        ETButtonType cancelType = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("general.cancel"), ButtonBar.ButtonData.CANCEL_CLOSE), false, true);
        ButtonType response = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("updaterScreen.howToUpdateTitle"), this.messageService.getLocaleBundle().getString("updaterScreen.howToUpdateContent"), Modality.WINDOW_MODAL, List.of(cancelType, toWebsite)).showAndWait();
        if (response == toWebsite.getButtonType()) {
            SpringBootJavaFxApplication.getApplication().getHostServices().showDocument("https://easytranscript.de");
        }
    }

    protected boolean areUpdatesManagedBySystem() {
        return false;
    }

    protected boolean isNotBundledJRE() {
        return !RuntimeUtils.isBundledJRE();
    }

    @Generated
    public UpdaterService(UpdaterController updaterController, ExecutorService executorService, WebClient.Builder webClientBuilder, ConfigurationService configurationService, MessageService messageService, DialogService dialogService, GuiStateService guiStateService) {
        this.updaterController = updaterController;
        this.executorService = executorService;
        this.webClientBuilder = webClientBuilder;
        this.configurationService = configurationService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.guiStateService = guiStateService;
    }

    @Generated
    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }
}

