/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.welcome;

import eu.ewerkzeug.easytranscript3.commons.types.RecentLoaded;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentListCell
extends ListCell<RecentLoaded> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecentListCell.class);
    private final double width;
    @FXML
    public Button deleteButton;
    @FXML
    private Label titleLabel;
    @FXML
    private Label pathLabel;
    @FXML
    private HBox rootHBox;
    @FXML
    private VBox textVbox;
    private FXMLLoader mLLoader;

    RecentListCell(double width) {
        this.width = width;
    }

    protected void updateItem(RecentLoaded recentLoaded, boolean empty) {
        super.updateItem((Object)recentLoaded, empty);
        if (empty || recentLoaded == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            if (this.mLLoader == null) {
                this.mLLoader = new FXMLLoader(this.getClass().getResource("/eu/ewerkzeug/easytranscript3/mvc/welcome/recentlistcell/recentListCell.fxml"));
                this.mLLoader.setController((Object)this);
                try {
                    this.mLLoader.load();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            this.textVbox.setPrefWidth(this.width - 55.0);
            this.textVbox.setMaxWidth(this.width - 55.0);
            this.rootHBox.setPrefWidth(this.width - 55.0);
            this.setOnMouseEntered(event -> {
                this.deleteButton.setVisible(true);
                this.deleteButton.getScene().setCursor(Cursor.HAND);
            });
            this.setOnMouseExited(event -> {
                this.deleteButton.getScene().setCursor(Cursor.DEFAULT);
                this.deleteButton.setVisible(false);
            });
            this.deleteButton.setOnMouseEntered(event -> this.deleteButton.setOpacity(1.0));
            this.deleteButton.setOnMouseExited(event -> this.deleteButton.setOpacity(0.5));
            this.deleteButton.setOnAction(event -> recentLoaded.setToBeDeleted(true));
            this.pathLabel.setMaxWidth(this.rootHBox.getPrefWidth());
            this.titleLabel.setMaxWidth(this.rootHBox.getPrefWidth());
            this.titleLabel.setText(recentLoaded.getTitle());
            this.pathLabel.setText(recentLoaded.getPath());
            this.setText(null);
            this.setGraphic((Node)this.rootHBox);
        }
    }
}

