/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class STTDialogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTDialogService.class);
    private final MessageService messageService;
    private final DialogService dialogService;

    public ETDialog createUploadDownloadCancelAlert(boolean downloading, boolean uploading) {
        String content;
        log.debug("Creating upload download cancel alert ...");
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType buttonTypeYes = new ETButtonType(ButtonType.YES, true, false);
        ETButtonType buttonTypeNo = new ETButtonType(ButtonType.NO, false, false);
        buttons.add(buttonTypeYes);
        buttons.add(buttonTypeNo);
        if (downloading) {
            content = this.messageService.getLocaleBundle().getString("mainScreen.filesAreBeingDownloaded");
        } else if (uploading) {
            content = this.messageService.getLocaleBundle().getString("mainScreen.filesAreBeingUploaded");
        } else {
            return null;
        }
        return this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("mainScreen.filesAutomaticTranscriptionNotificationTitle"), content, Modality.WINDOW_MODAL, buttons);
    }

    public void showUploadInfoDialog() {
        Platform.runLater(() -> {
            ETDialog dialog = this.dialogService.createDialog("", this.messageService.getLocaleBundle().getString("createTranscriptScreen.uploadForAutomaticTranscriptionNotification"), Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false)));
            dialog.getStage().show();
        });
    }

    public Mono<ButtonType> showSuccessfulDownloadDialog() {
        log.debug("Preparing successful download dialog...");
        return Mono.create(sink -> {
            Runnable openDialog = () -> {
                ETDialog dialog = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.successfullyDownloadedTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.successfullyDownloaded"), Modality.APPLICATION_MODAL, Arrays.asList(new ETButtonType(ButtonType.YES, true, false), new ETButtonType(ButtonType.NO, false, true)));
                dialog.getStage().setAlwaysOnTop(true);
                dialog.getStage().requestFocus();
                log.debug("Showing successful dialog now...");
                ButtonType buttonType = dialog.showAndWait();
                sink.success((Object)buttonType);
            };
            Platform.runLater((Runnable)openDialog);
        });
    }

    public void showUnauthorizedError() {
        String title = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.unauthorizedTitle");
        String content = this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.unauthorized");
        Platform.runLater(() -> this.dialogService.createDialog(title, content, Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    @Generated
    public STTDialogService(MessageService messageService, DialogService dialogService) {
        this.messageService = messageService;
        this.dialogService = dialogService;
    }
}

