/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.GuiStateService;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.CredentialsService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import eu.ewerkzeug.easytranscript3.service.AutomaticTranscriptService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import eu.ewerkzeug.easytranscript3.service.TranscriptService;
import io.netty.channel.ConnectTimeoutException;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javafx.application.Platform;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class STTDownloadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTDownloadService.class);
    private static final int MAX_DOWNLOAD_RETRIES = 3;
    private static final long DOWNLOAD_RETRY_DELAY_MS = 2000L;
    private final STTStatusService sttStatusService;
    private final WebClient sttWebClient;
    private final STTDialogService sttDialogService;
    private final CredentialsService credentialsService;
    private final AlertService alertService;
    private final AutomaticTranscriptService automaticTranscriptService;
    private final MessageService messageService;
    private final DialogService dialogService;
    private final TranscriptService transcriptService;
    private final ExceptionAlert exceptionAlert;
    private final GuiStateService guiStateService;

    @NotNull
    private static Path moveFilesSafely(Path tmpEttFile, Path destination) throws IOException {
        int i = 2;
        while (Files.exists(destination, new LinkOption[0])) {
            destination = Path.of(destination.getParent().toString(), String.valueOf(destination.getFileName()) + " (" + i + ")");
            ++i;
        }
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        Files.move(tmpEttFile, destination, new CopyOption[0]);
        return destination;
    }

    public void handleDownloadingPhase() {
        Runnable download = () -> {
            Disposable disposable = this.asyncDownloadTranscript(this.automaticTranscriptService.getCurrentInfo()).subscribe(void_ -> log.info("Downloaded transcript successfully."));
            this.sttStatusService.getOngoingRequests().add(disposable);
        };
        if (this.automaticTranscriptService.getCurrentInfo().getTranscriptLocation() != null && !this.automaticTranscriptService.getCurrentInfo().getTranscriptLocation().toString().isEmpty()) {
            download.run();
        } else {
            Platform.runLater(() -> {
                ETButtonType chooseFolder = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.chooseLocation"), ButtonBar.ButtonData.YES), true, false);
                ButtonType buttonType = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.chooseFolderForDownloadTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.chooseFolderForDownload"), Modality.WINDOW_MODAL, Arrays.asList(new ETButtonType(ButtonType.CANCEL, false, true), chooseFolder)).showAndWait();
                if (buttonType != null && buttonType.equals(chooseFolder.getButtonType())) {
                    File file = this.chooseAlternativeTranscriptLocation();
                    if (file != null) {
                        this.automaticTranscriptService.getCurrentInfo().setTranscriptLocation(file.toPath());
                        download.run();
                    } else {
                        this.sttStatusService.resetCurrentProcess();
                    }
                } else {
                    this.sttStatusService.resetCurrentProcess();
                }
            });
        }
    }

    private Mono<Void> asyncDownloadTranscript(AutomaticTranscriptCreationInfo info) {
        log.debug("Downloading transcript {}...", (Object)info.getUuid());
        return this.downloadTranscript(info).doOnSuccess(path -> {
            if (path != null) {
                log.info("Downloaded transcript {}", (Object)info.getUuid());
                this.moveDownloadedTranscript(path);
            }
        }).then();
    }

    private Mono<Path> downloadTranscript(AutomaticTranscriptCreationInfo info) {
        return this.attemptDownload(info).retryWhen((Retry)Retry.fixedDelay((long)3L, (Duration)Duration.ofMillis(2000L)).filter(e -> e instanceof SocketTimeoutException || e instanceof ConnectTimeoutException)).onErrorResume(e -> {
            log.error("Failed to download project: {}", (Object)e.getMessage(), e);
            this.alertService.showServerError();
            return Mono.empty();
        });
    }

    private Mono<Path> attemptDownload(AutomaticTranscriptCreationInfo info) {
        HashMap authHeaders = this.credentialsService.getDeviceIdAuthHeaders();
        return this.sttWebClient.get().uri("/projects/" + info.getUuid() + "/download", new Object[0]).headers(httpHeaders -> {
            if (authHeaders != null) {
                authHeaders.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            }
        }).exchangeToMono(response -> {
            if (response.statusCode().isError()) {
                this.handleResponseErrors(response.statusCode());
                return response.releaseBody().then(Mono.empty());
            }
            long len = response.headers().asHttpHeaders().getContentLength();
            log.debug("Total length of downloadable project zip: {}", (Object)len);
            this.sttStatusService.getTransferProgressInfo().setTotalLength(len);
            Path tempZipFile = this.createTempDownloadFile();
            Date first = new Date();
            Flux stream = response.bodyToFlux(DataBuffer.class).doOnNext(dataBuffer -> {
                int bytesRead = dataBuffer.readableByteCount();
                this.sttStatusService.updateTransferProgress(bytesRead, first);
            });
            log.debug("Writing downloaded zip file to {}", (Object)tempZipFile.toAbsolutePath());
            return DataBufferUtils.write((Publisher)stream, (Path)tempZipFile, (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE}).then(Mono.just((Object)tempZipFile));
        });
    }

    private void moveDownloadedTranscript(Path tmpEttFile) {
        log.debug("Moving downloaded transcript ...");
        try {
            Path destination = this.automaticTranscriptService.getCurrentInfo().getTranscriptLocation();
            destination = STTDownloadService.moveFilesSafely((Path)tmpEttFile, (Path)destination);
            this.automaticTranscriptService.getCurrentInfo().setTranscriptLocation(destination);
            this.finishProjectGeneration();
            this.automaticTranscriptService.deleteSavedFile();
            log.info("Moved downloaded transcript to {}", (Object)destination.toAbsolutePath());
        }
        catch (IOException e) {
            log.error("Could not move transcript.", (Throwable)e);
            Platform.runLater(() -> {
                ETButtonType chooseFolder = new ETButtonType(new ButtonType(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.chooseLocation"), ButtonBar.ButtonData.YES), true, false);
                ButtonType buttonType = this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.folderNotWritableTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.folderNotWritable"), Modality.APPLICATION_MODAL, Arrays.asList(chooseFolder, new ETButtonType(ButtonType.CANCEL, false, true))).showAndWait();
                if (buttonType.equals(chooseFolder.getButtonType())) {
                    this.automaticTranscriptService.getCurrentInfo().setTranscriptLocation(this.chooseAlternativeTranscriptLocation().toPath());
                    this.moveDownloadedTranscript(tmpEttFile);
                } else {
                    this.sttStatusService.resetCurrentProcess();
                }
            });
        }
    }

    private void handleResponseErrors(HttpStatusCode statusCode) {
        if (statusCode.value() == HttpStatus.UNAUTHORIZED.value()) {
            log.error("User is not authorized to download.");
            this.sttDialogService.showUnauthorizedError();
        } else if (statusCode.value() == HttpStatus.NOT_FOUND.value()) {
            log.error("Illegal state reached. Project should be ready to download but server says otherwise.");
            this.exceptionAlert.showModal();
        } else if (statusCode.is4xxClientError() || statusCode.is5xxServerError()) {
            log.error("Server error during project download: {}", (Object)statusCode);
            this.alertService.showServerError();
        }
    }

    private Path createTempDownloadFile() {
        Path tempZipFile = this.getTempDirectory().resolve("et3-" + String.valueOf(UUID.randomUUID()) + ".zip");
        tempZipFile.toFile().deleteOnExit();
        return tempZipFile;
    }

    protected Path getTempDirectory() {
        return Main.getEasytranscriptTempDirectory();
    }

    private File chooseAlternativeTranscriptLocation() {
        File file;
        log.warn("Original transcript location was not usable. Choosing alternative transcript location ...");
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)this.transcriptService.getEttFilter());
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        if ((file = fileChooser.showSaveDialog((Window)this.guiStateService.getMainStage())) != null) {
            Main.setRecentOpenedFileChooserPath((File)file.toPath().getParent().toFile());
        }
        return file;
    }

    private void finishProjectGeneration() {
        this.sttStatusService.switchToFinishedPhase();
    }

    @Generated
    public STTDownloadService(STTStatusService sttStatusService, WebClient sttWebClient, STTDialogService sttDialogService, CredentialsService credentialsService, AlertService alertService, AutomaticTranscriptService automaticTranscriptService, MessageService messageService, DialogService dialogService, TranscriptService transcriptService, ExceptionAlert exceptionAlert, GuiStateService guiStateService) {
        this.sttStatusService = sttStatusService;
        this.sttWebClient = sttWebClient;
        this.sttDialogService = sttDialogService;
        this.credentialsService = credentialsService;
        this.alertService = alertService;
        this.automaticTranscriptService = automaticTranscriptService;
        this.messageService = messageService;
        this.dialogService = dialogService;
        this.transcriptService = transcriptService;
        this.exceptionAlert = exceptionAlert;
        this.guiStateService = guiStateService;
    }
}

