/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.CredentialsService;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.listener.STTStateListener;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.STTEvent;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferException;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDownloadService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTUploadService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTWebSocketService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.utils.StateMachineUtils;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.SignatureException;
import javax.security.auth.login.AccountExpiredException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

@Service
public class STTService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTService.class);
    public static final String PROJECTS_ROUTE = "/projects/";
    public static final int MAX_RECONNECT_TRIES = 3;
    private final STTWebSocketService sttWebSocketService;
    private final STTUploadService sttUploadService;
    private final STTDownloadService sttDownloadService;
    private final STTStatusService statusService;
    private final WebClient sttWebClient;
    private final STTStatusService sttStatusService;
    private final StateMachine<String, STTEvent> stateMachine;
    private final STTStateListener stateListener;
    private final LicenseService licenseService;
    private final CredentialsService credentialsService;
    private final AlertService alertService;
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;
    private long maxUploadSize = 20000000L;
    private boolean maxUploadSizeRetrieved = false;

    @PostConstruct
    public void setup() {
        try {
            this.licenseService.loadLicenseFromDisk();
        }
        catch (IOException | SignatureException | AccountExpiredException e) {
            log.error("Could not load license from disk.", (Throwable)e);
        }
        this.stateMachine.addStateListener((StateMachineListener)this.stateListener);
    }

    private Mono<Long> retrieveMaxUploadSize() {
        log.debug("Getting max upload size ...");
        return this.credentialsService.executeAuthenticated(headers -> this.sttWebClient.get().uri("/projects/maxUploadSize", new Object[0]).headers(headers).retrieve().bodyToMono(Long.class)).doOnSuccess(response -> {
            this.maxUploadSize = response;
            this.maxUploadSizeRetrieved = true;
            log.info("Retrieved maximum upload size for automatic transcript generation: {}.", (Object)this.maxUploadSize);
        });
    }

    public Mono<Long> getMaxUploadSize() {
        if (!this.maxUploadSizeRetrieved) {
            return this.retrieveMaxUploadSize().doOnError(e -> this.alertService.showConnectionError());
        }
        return Mono.just((Object)this.maxUploadSize);
    }

    public Mono<ResponseEntity<AutomaticTranscriptStatus>> getJobStatus() {
        log.debug("Getting status of current project ...");
        return this.credentialsService.executeAuthenticated(headers -> this.sttWebClient.get().uri("/projects/status", new Object[0]).headers(headers).retrieve().toEntity(AutomaticTranscriptStatus.class)).onErrorResume(WebClientException.class, e -> {
            log.error("Got error", (Throwable)e);
            if (e instanceof WebClientResponseException) {
                WebClientResponseException ex = (WebClientResponseException)e;
                if (ex.getStatusCode().is4xxClientError()) {
                    return Mono.error((Throwable)new TransferException("Could not get project status because of client error.", ex.getStatusCode().value()));
                }
                return Mono.error((Throwable)new TransferException("Could not get project status because of server error.", ex.getStatusCode().value()));
            }
            return Mono.error((Throwable)e);
        }).doOnSuccess(res -> this.statusService.getLatestStatus().set((Object)((AutomaticTranscriptStatus)res.getBody())));
    }

    public Mono<ResponseEntity<String>> createAutomaticTranscriptionJob(AutomaticTranscriptCreationInfo projectInformation) {
        log.info("Creating project ...");
        StateMachineUtils.restartMachine((StateMachine)this.stateMachine);
        return this.credentialsService.executeAuthenticated(headers -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.sttWebClient.post().uri("/projects", new Object[0])).headers(headers)).body((BodyInserter)BodyInserters.fromMultipartData((String)"project", (Object)projectInformation)).retrieve().toEntity(String.class)).onErrorResume(WebClientResponseException.class, Mono::error);
    }

    @Generated
    public STTWebSocketService getSttWebSocketService() {
        return this.sttWebSocketService;
    }

    @Generated
    public STTUploadService getSttUploadService() {
        return this.sttUploadService;
    }

    @Generated
    public STTDownloadService getSttDownloadService() {
        return this.sttDownloadService;
    }

    @Generated
    public STTStatusService getStatusService() {
        return this.statusService;
    }

    @Generated
    public WebClient getSttWebClient() {
        return this.sttWebClient;
    }

    @Generated
    public STTStatusService getSttStatusService() {
        return this.sttStatusService;
    }

    @Generated
    public StateMachine<String, STTEvent> getStateMachine() {
        return this.stateMachine;
    }

    @Generated
    public STTStateListener getStateListener() {
        return this.stateListener;
    }

    @Generated
    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    @Generated
    public CredentialsService getCredentialsService() {
        return this.credentialsService;
    }

    @Generated
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Generated
    public String getLicenseServerUrl() {
        return this.licenseServerUrl;
    }

    @Generated
    public boolean isMaxUploadSizeRetrieved() {
        return this.maxUploadSizeRetrieved;
    }

    @Generated
    public STTService(STTWebSocketService sttWebSocketService, STTUploadService sttUploadService, STTDownloadService sttDownloadService, STTStatusService statusService, WebClient sttWebClient, STTStatusService sttStatusService, StateMachine<String, STTEvent> stateMachine, STTStateListener stateListener, LicenseService licenseService, CredentialsService credentialsService, AlertService alertService) {
        this.sttWebSocketService = sttWebSocketService;
        this.sttUploadService = sttUploadService;
        this.sttDownloadService = sttDownloadService;
        this.statusService = statusService;
        this.sttWebClient = sttWebClient;
        this.sttStatusService = sttStatusService;
        this.stateMachine = stateMachine;
        this.stateListener = stateListener;
        this.licenseService = licenseService;
        this.credentialsService = credentialsService;
        this.alertService = alertService;
    }
}

