/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.STTEvent;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferProgressInfo;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.utils.StateMachineUtils;
import java.util.Collections;
import java.util.Date;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateMachine;
import org.springframework.stereotype.Service;
import reactor.core.Disposable;

@Service
public class STTStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTStatusService.class);
    private final Set<Disposable> ongoingRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final TransferProgressInfo transferProgressInfo = new TransferProgressInfo();
    private final BooleanProperty showStatusInfoPopOver = new SimpleBooleanProperty();
    private final SimpleObjectProperty<AutomaticTranscriptStatus> latestStatus = new SimpleObjectProperty(null);
    private final StateMachine<String, STTEvent> stateMachine;
    private int reconnectTriesLeft = 10;

    public boolean isUploading() {
        return this.getState().equals("UPLOADING");
    }

    public boolean isDownloading() {
        return this.getState().equals("DOWNLOADING");
    }

    public Long getAverageWrittenPerSecond() {
        OptionalDouble rollingAvg = this.getTransferProgressInfo().getWrittenPerSecond().stream().mapToLong(f -> f).average();
        if (rollingAvg.isPresent()) {
            return (long)(Math.ceil(rollingAvg.getAsDouble() / 1000.0) * 1000.0);
        }
        return null;
    }

    public void updateTransferProgress(int bytesRead, Date first) {
        TransferProgressInfo info = this.getTransferProgressInfo();
        info.setTransferred(info.getTransferred() + (long)bytesRead);
        info.setWrittenPerSecondTmp(info.getWrittenPerSecondTmp() + (long)bytesRead);
        if (new Date().getTime() - first.getTime() > 1000L) {
            info.getWrittenPerSecond().add((Object)info.getWrittenPerSecondTmp());
            info.setWrittenPerSecondTmp(0L);
            if (info.getWrittenPerSecond().size() > 5) {
                info.getWrittenPerSecond().removeFirst();
            }
            first.setTime(new Date().getTime());
        }
    }

    public void startUploadOfMediaFiles() {
        StateMachineUtils.sendEvent((StateMachine)this.stateMachine, (Object)STTEvent.START_UPLOAD);
    }

    public void startDownloadOfTranscript() {
        StateMachineUtils.sendEvent((StateMachine)this.stateMachine, (Object)STTEvent.START_DOWNLOAD);
    }

    public void switchToGeneratingPhase() {
        StateMachineUtils.sendEvent((StateMachine)this.stateMachine, (Object)STTEvent.START_GENERATION);
    }

    public void switchToFinishedPhase() {
        StateMachineUtils.sendEvent((StateMachine)this.stateMachine, (Object)STTEvent.START_SUCCESS);
    }

    public void resetCurrentProcess() {
        StateMachineUtils.restartMachine((StateMachine)this.stateMachine);
    }

    public String getState() {
        return (String)this.stateMachine.getState().getId();
    }

    @Generated
    public Set<Disposable> getOngoingRequests() {
        return this.ongoingRequests;
    }

    @Generated
    public TransferProgressInfo getTransferProgressInfo() {
        return this.transferProgressInfo;
    }

    @Generated
    public BooleanProperty getShowStatusInfoPopOver() {
        return this.showStatusInfoPopOver;
    }

    @Generated
    public SimpleObjectProperty<AutomaticTranscriptStatus> getLatestStatus() {
        return this.latestStatus;
    }

    @Generated
    public StateMachine<String, STTEvent> getStateMachine() {
        return this.stateMachine;
    }

    @Generated
    public int getReconnectTriesLeft() {
        return this.reconnectTriesLeft;
    }

    @Generated
    public STTStatusService(StateMachine<String, STTEvent> stateMachine) {
        this.stateMachine = stateMachine;
    }

    @Generated
    public void setReconnectTriesLeft(int reconnectTriesLeft) {
        this.reconnectTriesLeft = reconnectTriesLeft;
    }
}

