/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.service;

import eu.ewerkzeug.easytranscript3.commons.CredentialsService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.DialogService;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.ETFileBody;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferException;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferProgressInfo;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.service.AlertService;
import eu.ewerkzeug.easytranscript3.service.AutomaticTranscriptService;
import eu.ewerkzeug.easytranscript3.service.MessageService;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class STTUploadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(STTUploadService.class);
    private final STTDialogService sttDialogService;
    private final STTStatusService statusService;
    private final STTDeletionService deletionService;
    private final WebClient sttWebClient;
    private final CredentialsService credentialsService;
    private final AlertService alertService;
    private final DialogService dialogService;
    private final MessageService messageService;
    private final AutomaticTranscriptService automaticTranscriptService;
    private final ExceptionAlert exceptionAlert;

    public Mono<List<Person>> uploadMediaFiles() {
        log.debug("Uploading media files ...");
        try {
            this.statusService.getTransferProgressInfo().calculateTotalLength(this.automaticTranscriptService.getCurrentInfo());
        }
        catch (IOException e) {
            log.error("Could not calculate total upload size.", (Throwable)e);
            return Mono.error((Throwable)e);
        }
        AutomaticTranscriptCreationInfo info = this.automaticTranscriptService.getCurrentInfo();
        if (info.getPersons().isEmpty()) {
            log.error("Could not upload media files. No persons added.");
            return Mono.error(IllegalArgumentException::new);
        }
        if (info.getUuid() == null || info.getUuid().isBlank()) {
            log.error("Could not upload media files. Uuid is empty.");
            return Mono.error(IllegalArgumentException::new);
        }
        return Flux.concat(info.getPersons().stream().map(person -> this.uploadMedia(info.getUuid(), person).map(p -> p).onErrorResume(e -> {
            person.setException((Exception)e);
            return Mono.just((Object)person);
        }).doOnSuccess(p -> {
            if (p == null || p.getException() == null) {
                this.statusService.getTransferProgressInfo().getCompletedUploads().add((Object)p.getUuid());
                log.info("Uploaded media file for person {}", (Object)p.getUuid());
            } else {
                log.error("Upload of media file for person {} failed.", (Object)person.getUuid(), (Object)person.getException());
            }
        })).toList()).doOnComplete(() -> log.info("Upload media files for project {}", (Object)info.getUuid())).collectList();
    }

    public void handleUploadingPhase() {
        this.automaticTranscriptService.save(this.automaticTranscriptService.getCurrentInfo());
        this.sttDialogService.showUploadInfoDialog();
        this.statusService.getShowStatusInfoPopOver().setValue(Boolean.valueOf(true));
        Mono uploadFlow = this.uploadMediaFiles().publishOn(Schedulers.boundedElastic()).doOnError(Exception.class, e -> {
            this.handleMediaFileUploadError(e);
            this.deletionService.deleteTranscriptionJob().subscribe();
        });
        Disposable overallProcess = uploadFlow.flatMap(people -> {
            if (people.isEmpty()) {
                return Mono.empty();
            }
            return this.startTranscription(this.automaticTranscriptService.getCurrentInfo().getUuid()).doOnError(WebClientResponseException.class, arg_0 -> this.handleStartTranscriptionError(arg_0));
        }).subscribe(res -> {
            if (res.getStatusCode().is2xxSuccessful()) {
                log.info("Transcription started successfully.");
                this.statusService.switchToGeneratingPhase();
            }
        }, err -> log.error("Transcription failed", err));
        this.statusService.getOngoingRequests().add(overallProcess);
    }

    private void handleStartTranscriptionError(WebClientResponseException e) {
        Platform.runLater(() -> {
            HttpStatusCode statusCode = e.getStatusCode();
            if (statusCode.value() == HttpStatus.UNAUTHORIZED.value()) {
                log.error("Got unauthorized error when trying to upload.");
                this.sttDialogService.showUnauthorizedError();
            } else if (statusCode.value() == HttpStatus.CONFLICT.value()) {
                log.error("Got conflict error when trying to upload.");
                this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectGenericClientError"), Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.value() == HttpStatus.BAD_REQUEST.value()) {
                log.error("Got bad request error when trying to upload.");
                this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectAlreadyRunning"), Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.value() == HttpStatus.PAYMENT_REQUIRED.value()) {
                log.error("insufficient balance when trying to start transcription.");
                this.dialogService.createDialog("", this.messageService.getLocaleBundle().getString("createTranscriptScreen.insufficientBalance"), Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.is4xxClientError()) {
                log.error("Got other client error when trying to upload.");
                this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectGenericClientError"), Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (statusCode.is5xxServerError()) {
                log.error("Got server error when trying to upload.");
                this.alertService.showServerError();
            }
            this.statusService.resetCurrentProcess();
        });
    }

    @NotNull
    private Mono<Person> uploadMedia(String projectUuid, Person person) {
        return this.executeUploadRequest(projectUuid, person, false).onErrorResume(e -> {
            WebClientResponseException webClientResponseException;
            if (e instanceof WebClientResponseException && ((webClientResponseException = (WebClientResponseException)e).getStatusCode().value() == 401 || webClientResponseException.getStatusCode().value() == 403)) {
                log.warn("Request with deviceId auth failed with status {}. Retrying with full authentication.", (Object)webClientResponseException.getStatusCode());
                return this.executeUploadRequest(projectUuid, person, true);
            }
            return Mono.error((Throwable)e);
        }).thenReturn((Object)person);
    }

    private Mono<Void> executeUploadRequest(String projectUuid, Person person, boolean fullAuth) {
        MultipartBodyBuilder builder = new MultipartBodyBuilder();
        ETFileBody fileBody = new ETFileBody(person.getMediaPath().toFile());
        fileBody.setListener(arg_0 -> this.updateTransferProgress(arg_0));
        try {
            builder.part("file", (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.sttWebClient.post().uri("/projects/" + projectUuid + "/" + person.getUuid(), new Object[0])).contentType(MediaType.MULTIPART_FORM_DATA).headers(headers -> {
            HashMap authHeaders;
            HashMap hashMap = authHeaders = fullAuth ? this.credentialsService.getAuthHeadersForFullAuthentication() : this.credentialsService.getDeviceIdAuthHeaders();
            if (authHeaders != null) {
                authHeaders.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
            }
        })).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)builder.build())).retrieve().onStatus(HttpStatusCode::isError, response -> Mono.error((Throwable)new TransferException("Upload failed: " + String.valueOf(response.statusCode()), response.statusCode().value()))).toBodilessEntity().then();
    }

    private void updateTransferProgress(long delta) {
        TransferProgressInfo transferProgressInfo = this.statusService.getTransferProgressInfo();
        transferProgressInfo.setWrittenPerSecondTmp(transferProgressInfo.getWrittenPerSecondTmp() + delta);
        transferProgressInfo.setTransferred(transferProgressInfo.getTransferred() + delta);
        long diff = new Date().getTime() - transferProgressInfo.getSecondsDate().getTime();
        if (diff >= 1000L) {
            this.handleTransferRateAdjustment(diff, transferProgressInfo);
        }
    }

    private void handleTransferRateAdjustment(long diff, TransferProgressInfo transferProgressInfo) {
        if (diff > 1500L) {
            log.warn("High RTT for sending 4096b: {}ms!", (Object)diff);
        }
        transferProgressInfo.setSecondsDate(new Date());
        transferProgressInfo.getWrittenPerSecond().add((Object)transferProgressInfo.getWrittenPerSecondTmp());
        transferProgressInfo.setWrittenPerSecondTmp(0L);
        if (transferProgressInfo.getWrittenPerSecond().size() > 5) {
            transferProgressInfo.getWrittenPerSecond().removeFirst();
        }
    }

    public void handleMediaFileUploadError(Exception e) {
        log.error("Could not upload media file.", (Throwable)e);
        this.statusService.resetCurrentProcess();
        if (e instanceof IllegalArgumentException) {
            this.exceptionAlert.showModal();
        } else if (e instanceof NullPointerException) {
            log.error("Exception is a NullPointerException.");
            this.alertService.showServerError();
        } else if (e instanceof WebClientRequestException || e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof UnknownHostException) {
            this.alertService.showConnectionError();
        } else if (e instanceof IOException) {
            log.error("Exception is an IOException.");
            Platform.runLater(() -> this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToReadMediaFile"), Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
        } else if (e instanceof TransferException) {
            TransferException ex = (TransferException)e;
            log.error("Exception is a TransferException.");
            log.error("Status code: {}", (Object)ex.getStatus());
            if (ex.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
                log.error("User is not authorized to upload media.");
                this.sttDialogService.showUnauthorizedError();
            } else if (ex.getStatus() == HttpStatus.LOCKED.value()) {
                log.error("Project is already running.");
                this.exceptionAlert.showModal();
            } else if (ex.getStatus() == HttpStatus.BAD_REQUEST.value()) {
                log.error("Upload was not a multipart request.");
                this.exceptionAlert.showModal();
            } else if (ex.getStatus() == HttpStatus.INSUFFICIENT_STORAGE.value()) {
                this.dialogService.createDialog(this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), this.messageService.getLocaleBundle().getString("automaticTranscriptionStatus.quotaExceededWhileUploading"), Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait();
            } else if (ex.getStatus() == HttpStatus.ALREADY_REPORTED.value()) {
                log.error("File for speaker already uploaded.");
                this.exceptionAlert.showModal();
                log.error("");
            } else {
                this.alertService.showServerError();
            }
        } else {
            this.alertService.showServerError();
        }
    }

    private Mono<ResponseEntity<Void>> startTranscription(String uuid) {
        log.debug("Starting transcription of project with uuid {} ...", (Object)uuid);
        return this.credentialsService.executeAuthenticated(headers -> {
            WebClient.RequestBodySpec uri = (WebClient.RequestBodySpec)this.sttWebClient.post().uri("/projects/" + uuid, new Object[0]);
            uri = (WebClient.RequestBodySpec)uri.headers(headers);
            return uri.retrieve().toBodilessEntity();
        }).onErrorResume(WebClientResponseException.class, Mono::error);
    }

    @Generated
    public STTUploadService(STTDialogService sttDialogService, STTStatusService statusService, STTDeletionService deletionService, WebClient sttWebClient, CredentialsService credentialsService, AlertService alertService, DialogService dialogService, MessageService messageService, AutomaticTranscriptService automaticTranscriptService, ExceptionAlert exceptionAlert) {
        this.sttDialogService = sttDialogService;
        this.statusService = statusService;
        this.deletionService = deletionService;
        this.sttWebClient = sttWebClient;
        this.credentialsService = credentialsService;
        this.alertService = alertService;
        this.dialogService = dialogService;
        this.messageService = messageService;
        this.automaticTranscriptService = automaticTranscriptService;
        this.exceptionAlert = exceptionAlert;
    }
}

